/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class RIPEMD160HMacTest
implements Test {
    static final String[] keys = new String[]{"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "4a656665", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "0102030405060708090a0b0c0d0e0f10111213141516171819", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
    static final String[] digests = new String[]{"24cb4bd67d20fc1a5d2ed7732dcc39377f0a5668", "dda6c0213a485a9e24f4742064a7f033b43c4069", "b0b105360de759960ab4f35298e116e295d8e7c1", "d5ca862f4d21d5e610e18b4cf1beb97a4365ecf4", "7619693978f91d90539ae786500ff3d8e0518e39", "6466ca07ac5eac29e1bd523e5ada7605b791fd8b", "69ea60798d71616cce5fd0871e23754cd75d5a0a"};
    static final String[] messages = new String[]{"Hi There", "what do ya want for nothing?", "0xdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", "0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd", "Test With Truncation", "Test Using Larger Than Block-Size Key - Hash Key First", "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data"};

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "RIPEMD160HMac";
    }

    public static void main(String[] stringArray) {
        RIPEMD160HMacTest rIPEMD160HMacTest = new RIPEMD160HMacTest();
        TestResult testResult = rIPEMD160HMacTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        HMac hMac = new HMac((Digest)new RIPEMD160Digest());
        byte[] byArray = new byte[hMac.getMacSize()];
        int n = 0;
        while (n < messages.length) {
            byte[] byArray2 = messages[n].getBytes();
            if (messages[n].startsWith("0x")) {
                byArray2 = Hex.decode((String)messages[n].substring(2));
            }
            hMac.init((CipherParameters)new KeyParameter(Hex.decode((String)keys[n])));
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray, 0);
            if (!RIPEMD160HMacTest.arraysEqual(byArray, Hex.decode((String)digests[n]))) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Vector " + n + " failed");
            }
            ++n;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

