/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64 {
    private static final byte[] encodingTable;
    private static final byte[] decodingTable;

    public static byte[] encode(byte[] byArray) {
        int n = byArray.length % 3;
        byte[] byArray2 = n == 0 ? new byte[4 * byArray.length / 3] : new byte[4 * (byArray.length / 3 + 1)];
        int n2 = byArray.length - n;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = byArray[n3] & 0xFF;
            int n6 = byArray[n3 + 1] & 0xFF;
            int n7 = byArray[n3 + 2] & 0xFF;
            byArray2[n4] = encodingTable[n5 >>> 2 & 0x3F];
            byArray2[n4 + 1] = encodingTable[(n5 << 4 | n6 >>> 4) & 0x3F];
            byArray2[n4 + 2] = encodingTable[(n6 << 2 | n7 >>> 6) & 0x3F];
            byArray2[n4 + 3] = encodingTable[n7 & 0x3F];
            n3 += 3;
            n4 += 4;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                int n8 = byArray[byArray.length - 1] & 0xFF;
                n3 = n8 >>> 2 & 0x3F;
                n4 = n8 << 4 & 0x3F;
                byArray2[byArray2.length - 4] = encodingTable[n3];
                byArray2[byArray2.length - 3] = encodingTable[n4];
                byArray2[byArray2.length - 2] = 61;
                byArray2[byArray2.length - 1] = 61;
                break;
            }
            case 2: {
                int n9 = byArray[byArray.length - 2] & 0xFF;
                int n10 = byArray[byArray.length - 1] & 0xFF;
                n3 = n9 >>> 2 & 0x3F;
                n4 = (n9 << 4 | n10 >>> 4) & 0x3F;
                int n11 = n10 << 2 & 0x3F;
                byArray2[byArray2.length - 4] = encodingTable[n3];
                byArray2[byArray2.length - 3] = encodingTable[n4];
                byArray2[byArray2.length - 2] = encodingTable[n11];
                byArray2[byArray2.length - 1] = 61;
            }
        }
        return byArray2;
    }

    public static byte[] decode(byte[] byArray) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        byte[] byArray2 = byArray[byArray.length - 2] == 61 ? new byte[(byArray.length / 4 - 1) * 3 + 1] : (byArray[byArray.length - 1] == 61 ? new byte[(byArray.length / 4 - 1) * 3 + 2] : new byte[byArray.length / 4 * 3]);
        int n = 0;
        int n2 = 0;
        while (n < byArray.length - 4) {
            by4 = decodingTable[byArray[n]];
            by3 = decodingTable[byArray[n + 1]];
            by2 = decodingTable[byArray[n + 2]];
            by = decodingTable[byArray[n + 3]];
            byArray2[n2] = (byte)(by4 << 2 | by3 >> 4);
            byArray2[n2 + 1] = (byte)(by3 << 4 | by2 >> 2);
            byArray2[n2 + 2] = (byte)(by2 << 6 | by);
            n += 4;
            n2 += 3;
        }
        if (byArray[byArray.length - 2] == 61) {
            by4 = decodingTable[byArray[byArray.length - 4]];
            by3 = decodingTable[byArray[byArray.length - 3]];
            byArray2[byArray2.length - 1] = (byte)(by4 << 2 | by3 >> 4);
        } else if (byArray[byArray.length - 1] == 61) {
            by4 = decodingTable[byArray[byArray.length - 4]];
            by3 = decodingTable[byArray[byArray.length - 3]];
            by2 = decodingTable[byArray[byArray.length - 2]];
            byArray2[byArray2.length - 2] = (byte)(by4 << 2 | by3 >> 4);
            byArray2[byArray2.length - 1] = (byte)(by3 << 4 | by2 >> 2);
        } else {
            by4 = decodingTable[byArray[byArray.length - 4]];
            by3 = decodingTable[byArray[byArray.length - 3]];
            by2 = decodingTable[byArray[byArray.length - 2]];
            by = decodingTable[byArray[byArray.length - 1]];
            byArray2[byArray2.length - 3] = (byte)(by4 << 2 | by3 >> 4);
            byArray2[byArray2.length - 2] = (byte)(by3 << 4 | by2 >> 2);
            byArray2[byArray2.length - 1] = (byte)(by2 << 6 | by);
        }
        return byArray2;
    }

    private static boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    public static byte[] decode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Base64.decode(string, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("exception decoding base64 string: " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(String string, OutputStream outputStream) throws IOException {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        int n;
        int n2 = 0;
        for (n = string.length(); n > 0 && Base64.ignore(string.charAt(n - 1)); --n) {
        }
        for (int i = 0; i < n - 4; i += 4) {
            if (Base64.ignore(string.charAt(i))) continue;
            by4 = decodingTable[string.charAt(i)];
            by3 = decodingTable[string.charAt(i + 1)];
            by2 = decodingTable[string.charAt(i + 2)];
            by = decodingTable[string.charAt(i + 3)];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            outputStream.write(by2 << 6 | by);
            n2 += 3;
        }
        if (string.charAt(n - 2) == '=') {
            by4 = decodingTable[string.charAt(n - 4)];
            by3 = decodingTable[string.charAt(n - 3)];
            outputStream.write(by4 << 2 | by3 >> 4);
            ++n2;
        } else if (string.charAt(n - 1) == '=') {
            by4 = decodingTable[string.charAt(n - 4)];
            by3 = decodingTable[string.charAt(n - 3)];
            by2 = decodingTable[string.charAt(n - 2)];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            n2 += 2;
        } else {
            by4 = decodingTable[string.charAt(n - 4)];
            by3 = decodingTable[string.charAt(n - 3)];
            by2 = decodingTable[string.charAt(n - 2)];
            by = decodingTable[string.charAt(n - 1)];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            outputStream.write(by2 << 6 | by);
            n2 += 3;
        }
        return n2;
    }

    static {
        int n;
        encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        decodingTable = new byte[128];
        for (n = 65; n <= 90; ++n) {
            Base64.decodingTable[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            Base64.decodingTable[n] = (byte)(n - 97 + 26);
        }
        for (n = 48; n <= 57; ++n) {
            Base64.decodingTable[n] = (byte)(n - 48 + 52);
        }
        Base64.decodingTable[43] = 62;
        Base64.decodingTable[47] = 63;
    }
}

