/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;
    private EncryptedContentInfo data;

    public KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, EncryptedContentInfo encryptedContentInfo) {
        super(AlgorithmIdentifier.getInstance((Object)kEKRecipientInfo.getKeyEncryptionAlgorithm()));
        this.info = kEKRecipientInfo;
        this.rid = new RecipientId();
        this.data = encryptedContentInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid.setKeyIdentifier(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    public byte[] getContent(Key key, String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this.info.getEncryptedKey().getOctets();
            Cipher cipher = Cipher.getInstance(this.keyEncAlg.getObjectId().getId(), string);
            cipher.init(4, key);
            byte[] byArray2 = this.data.getEncryptedContent().getOctets();
            AlgorithmIdentifier algorithmIdentifier = this.data.getContentEncryptionAlgorithm();
            String string2 = algorithmIdentifier.getObjectId().getId();
            Key key2 = cipher.unwrap(byArray, string2, 3);
            Cipher cipher2 = Cipher.getInstance(string2, string);
            if (algorithmIdentifier.getParameters() != null) {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string2, string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)algorithmIdentifier.getParameters());
                algorithmParameters.init(byteArrayOutputStream.toByteArray(), "ASN.1");
                cipher2.init(2, key2, algorithmParameters);
            } else {
                cipher2.init(2, key2);
            }
            return cipher2.doFinal(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CMSException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CMSException("bad padding in message.", badPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("error decoding algorithm parameters.", iOException);
        }
    }
}

