/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public class PGPPublicKeyRing {
    ArrayList keys = new ArrayList();

    public PGPPublicKeyRing(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    PGPPublicKeyRing(ArrayList arrayList) {
        this.keys = arrayList;
    }

    public PGPPublicKeyRing(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        Packet packet;
        MessageDigest messageDigest;
        BCPGInputStream bCPGInputStream = inputStream instanceof BCPGInputStream ? (BCPGInputStream)inputStream : new BCPGInputStream(inputStream);
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Packet> arrayList3 = new ArrayList<Packet>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("can't find SHA1 digest");
        }
        PublicKeyPacket publicKeyPacket = (PublicKeyPacket)bCPGInputStream.readPacket();
        TrustPacket trustPacket = null;
        if (bCPGInputStream.nextPacketTag() == 12) {
            trustPacket = (TrustPacket)bCPGInputStream.readPacket();
        }
        while (bCPGInputStream.nextPacketTag() == 2) {
            try {
                arrayList.add(new PGPSignature(bCPGInputStream));
            }
            catch (PGPException pGPException) {
                throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
            }
        }
        while (bCPGInputStream.nextPacketTag() == 13 || bCPGInputStream.nextPacketTag() == 17) {
            packet = bCPGInputStream.readPacket();
            if (packet instanceof UserIDPacket) {
                object2 = (UserIDPacket)packet;
                arrayList2.add(((UserIDPacket)object2).getID());
            } else {
                object2 = (UserAttributePacket)packet;
                arrayList2.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)object2).getSubpackets()));
            }
            if (bCPGInputStream.nextPacketTag() == 12) {
                arrayList3.add(bCPGInputStream.readPacket());
            } else {
                arrayList3.add(null);
            }
            object2 = new ArrayList();
            arrayList4.add(object2);
            while (bCPGInputStream.nextPacketTag() == 2) {
                try {
                    object = (SignaturePacket)bCPGInputStream.readPacket();
                    if (bCPGInputStream.nextPacketTag() == 12) {
                        ((ArrayList)object2).add(new PGPSignature((SignaturePacket)object, (TrustPacket)bCPGInputStream.readPacket()));
                        continue;
                    }
                    ((ArrayList)object2).add(new PGPSignature((SignaturePacket)object));
                }
                catch (PGPException pGPException) {
                    throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
                }
            }
        }
        this.keys.add(new PGPPublicKey(publicKeyPacket, trustPacket, messageDigest, arrayList, arrayList2, arrayList3, arrayList4));
        while (bCPGInputStream.nextPacketTag() == 14) {
            packet = (PublicKeyPacket)bCPGInputStream.readPacket();
            object2 = null;
            if (bCPGInputStream.nextPacketTag() == 12) {
                object2 = (TrustPacket)bCPGInputStream.readPacket();
            }
            object = new ArrayList();
            try {
                while (bCPGInputStream.nextPacketTag() == 2) {
                    SignaturePacket signaturePacket = (SignaturePacket)bCPGInputStream.readPacket();
                    if (bCPGInputStream.nextPacketTag() == 12) {
                        ((ArrayList)object).add(new PGPSignature(signaturePacket, (TrustPacket)bCPGInputStream.readPacket()));
                        continue;
                    }
                    ((ArrayList)object).add(new PGPSignature(signaturePacket));
                }
            }
            catch (PGPException pGPException) {
                throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
            }
            this.keys.add(new PGPPublicKey((PublicKeyPacket)packet, (TrustPacket)object2, messageDigest, (ArrayList)object));
        }
    }

    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    public PGPPublicKey getPublicKey(long l) throws PGPException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public Iterator getPublicKeys() {
        return this.keys.iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            pGPPublicKey.encode(outputStream);
        }
    }
}

