/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PrivateKeyInfo
implements PKCSObjectIdentifiers,
DEREncodable {
    private DERObject privKey;
    private AlgorithmIdentifier algId;

    public PrivateKeyInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        BigInteger bigInteger = ((DERInteger)enumeration.nextElement()).getValue();
        if (bigInteger.intValue() != 0) {
            throw new IllegalArgumentException("wrong version for private key info");
        }
        this.algId = new AlgorithmIdentifier((ASN1Sequence)enumeration.nextElement());
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ASN1OctetString)enumeration.nextElement()).getOctets());
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            this.privKey = dERInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error recoverying private key from sequence");
        }
    }

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, DERObject dERObject) {
        this.privKey = dERObject;
        this.algId = algorithmIdentifier;
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(0));
        aSN1EncodableVector.add(this.algId);
        aSN1EncodableVector.add(new DEROctetString(this.privKey));
        return new DERSequence(aSN1EncodableVector);
    }

    public DERObject getPrivateKey() {
        return this.privKey;
    }
}

