/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.bouncycastle.asn1.x509.X509NameEntryConverter;
import org.bouncycastle.asn1.x509.X509NameTokenizer;

public class X509Name
implements DEREncodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
    public static final DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
    public static final DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
    public static final DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
    public static final DERObjectIdentifier UNIQUE_IDENTIFIER = new DERObjectIdentifier("2.5.4.45");
    public static final DERObjectIdentifier EmailAddress = PKCSObjectIdentifiers.pkcs_9_at_emailAddress;
    public static final DERObjectIdentifier UnstructuredName = PKCSObjectIdentifiers.pkcs_9_at_unstructuredName;
    public static final DERObjectIdentifier UnstructuredAddress = PKCSObjectIdentifiers.pkcs_9_at_unstructuredAddress;
    public static final DERObjectIdentifier E = EmailAddress;
    public static final DERObjectIdentifier DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
    public static final DERObjectIdentifier UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
    public static Hashtable OIDLookUp = new Hashtable();
    public static boolean DefaultReverse = false;
    public static Hashtable DefaultSymbols = OIDLookUp;
    public static Hashtable RFC2253Symbols = new Hashtable();
    public static Hashtable SymbolLookUp = new Hashtable();
    public static Hashtable DefaultLookUp = SymbolLookUp;
    private X509NameEntryConverter converter = null;
    private Vector ordering = new Vector();
    private Vector values = new Vector();
    private Vector added = new Vector();
    private ASN1Sequence seq;

    static {
        DefaultSymbols.put(C, "C");
        DefaultSymbols.put(O, "O");
        DefaultSymbols.put(T, "T");
        DefaultSymbols.put(OU, "OU");
        DefaultSymbols.put(CN, "CN");
        DefaultSymbols.put(L, "L");
        DefaultSymbols.put(ST, "ST");
        DefaultSymbols.put(SN, "SN");
        DefaultSymbols.put(EmailAddress, "E");
        DefaultSymbols.put(DC, "DC");
        DefaultSymbols.put(UID, "UID");
        DefaultSymbols.put(SURNAME, "SURNAME");
        DefaultSymbols.put(GIVENNAME, "GIVENNAME");
        DefaultSymbols.put(INITIALS, "INITIALS");
        DefaultSymbols.put(GENERATION, "GENERATION");
        DefaultSymbols.put(UnstructuredAddress, "unstructuredAddress");
        DefaultSymbols.put(UnstructuredName, "unstructuredName");
        RFC2253Symbols.put(C, "C");
        RFC2253Symbols.put(O, "O");
        RFC2253Symbols.put(T, "T");
        RFC2253Symbols.put(OU, "OU");
        RFC2253Symbols.put(CN, "CN");
        RFC2253Symbols.put(L, "L");
        RFC2253Symbols.put(ST, "ST");
        RFC2253Symbols.put(SN, "SN");
        RFC2253Symbols.put(EmailAddress, "EMAILADDRESS");
        RFC2253Symbols.put(DC, "DC");
        RFC2253Symbols.put(UID, "UID");
        RFC2253Symbols.put(SURNAME, "SURNAME");
        RFC2253Symbols.put(GIVENNAME, "GIVENNAME");
        RFC2253Symbols.put(INITIALS, "INITIALS");
        RFC2253Symbols.put(GENERATION, "GENERATION");
        DefaultLookUp.put("c", C);
        DefaultLookUp.put("o", O);
        DefaultLookUp.put("t", T);
        DefaultLookUp.put("ou", OU);
        DefaultLookUp.put("cn", CN);
        DefaultLookUp.put("l", L);
        DefaultLookUp.put("st", ST);
        DefaultLookUp.put("sn", SN);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("dc", DC);
        DefaultLookUp.put("e", E);
        DefaultLookUp.put("uid", UID);
        DefaultLookUp.put("surname", SURNAME);
        DefaultLookUp.put("givenname", GIVENNAME);
        DefaultLookUp.put("initials", INITIALS);
        DefaultLookUp.put("generation", GENERATION);
        DefaultLookUp.put("unstructuredaddress", UnstructuredAddress);
        DefaultLookUp.put("unstructuredname", UnstructuredName);
    }

    public X509Name(String string) {
        this(DefaultReverse, DefaultLookUp, string);
    }

    public X509Name(String string, X509NameEntryConverter x509NameEntryConverter) {
        this(DefaultReverse, DefaultLookUp, string, x509NameEntryConverter);
    }

    public X509Name(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Name(Vector vector, Hashtable hashtable) {
        this(vector, hashtable, new X509DefaultEntryConverter());
    }

    public X509Name(Vector vector, Hashtable hashtable, X509DefaultEntryConverter x509DefaultEntryConverter) {
        this.converter = x509DefaultEntryConverter;
        if (vector != null) {
            int n = 0;
            while (n != vector.size()) {
                this.ordering.addElement(vector.elementAt(n));
                this.added.addElement(new Boolean(false));
                ++n;
            }
        } else {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.ordering.addElement(enumeration.nextElement());
                this.added.addElement(new Boolean(false));
            }
        }
        int n = 0;
        while (n != this.ordering.size()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
            if (hashtable.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            this.values.addElement(hashtable.get(dERObjectIdentifier));
            ++n;
        }
    }

    public X509Name(Vector vector, Vector vector2) {
        this(vector, vector2, (X509NameEntryConverter)new X509DefaultEntryConverter());
    }

    public X509Name(Vector vector, Vector vector2, X509NameEntryConverter x509NameEntryConverter) {
        this.converter = x509NameEntryConverter;
        if (vector.size() != vector2.size()) {
            throw new IllegalArgumentException("oids vector must be same length as values.");
        }
        int n = 0;
        while (n < vector.size()) {
            this.ordering.addElement(vector.elementAt(n));
            this.values.addElement(vector2.elementAt(n));
            this.added.addElement(new Boolean(false));
            ++n;
        }
    }

    public X509Name(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Set aSN1Set = (ASN1Set)enumeration.nextElement();
            int n = 0;
            while (n < aSN1Set.size()) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set.getObjectAt(n);
                this.ordering.addElement(aSN1Sequence2.getObjectAt(0));
                this.values.addElement(((DERString)((Object)aSN1Sequence2.getObjectAt(1))).getString());
                this.added.addElement(n != 0 ? new Boolean(true) : new Boolean(false));
                ++n;
            }
        }
    }

    public X509Name(boolean bl, String string) {
        this(bl, DefaultLookUp, string);
    }

    public X509Name(boolean bl, String string, X509NameEntryConverter x509NameEntryConverter) {
        this(bl, DefaultLookUp, string, x509NameEntryConverter);
    }

    public X509Name(boolean bl, Hashtable hashtable, String string) {
        this(bl, hashtable, string, new X509DefaultEntryConverter());
    }

    public X509Name(boolean bl, Hashtable hashtable, String string, X509NameEntryConverter x509NameEntryConverter) {
        Object object;
        Object object2;
        this.converter = x509NameEntryConverter;
        X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
        while (x509NameTokenizer.hasMoreTokens()) {
            object2 = x509NameTokenizer.nextToken();
            int n = ((String)object2).indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            object = ((String)object2).substring(0, n);
            String string2 = ((String)object2).substring(n + 1);
            DERObjectIdentifier dERObjectIdentifier = this.decodeOID((String)object, hashtable);
            if (string2.indexOf(43) > 0) {
                X509NameTokenizer x509NameTokenizer2 = new X509NameTokenizer(string2, '+');
                this.ordering.addElement(dERObjectIdentifier);
                this.values.addElement(x509NameTokenizer2.nextToken());
                this.added.addElement(new Boolean(false));
                while (x509NameTokenizer2.hasMoreTokens()) {
                    String string3 = x509NameTokenizer2.nextToken();
                    int n2 = string3.indexOf(61);
                    String string4 = string3.substring(0, n2);
                    String string5 = string3.substring(n2 + 1);
                    this.ordering.addElement(this.decodeOID(string4, hashtable));
                    this.values.addElement(string5);
                    this.added.addElement(new Boolean(true));
                }
                continue;
            }
            this.ordering.addElement(dERObjectIdentifier);
            this.values.addElement(string2);
            this.added.addElement(new Boolean(false));
        }
        if (bl) {
            object2 = new Vector();
            Vector vector = new Vector();
            object = new Vector();
            int n = this.ordering.size() - 1;
            while (n >= 0) {
                ((Vector)object2).addElement(this.ordering.elementAt(n));
                vector.addElement(this.values.elementAt(n));
                ((Vector)object).addElement(this.added.elementAt(n));
                --n;
            }
            this.ordering = object2;
            this.values = vector;
            this.added = object;
        }
    }

    private void appendValue(StringBuffer stringBuffer, Hashtable hashtable, DERObjectIdentifier dERObjectIdentifier, String string) {
        String string2 = (String)hashtable.get(dERObjectIdentifier);
        if (string2 != null) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(dERObjectIdentifier.getId());
        }
        stringBuffer.append("=");
        int n = stringBuffer.length();
        stringBuffer.append(string);
        int n2 = stringBuffer.length();
        while (n != n2) {
            if (stringBuffer.charAt(n) == ',' || stringBuffer.charAt(n) == '\"' || stringBuffer.charAt(n) == '\\' || stringBuffer.charAt(n) == '+' || stringBuffer.charAt(n) == '<' || stringBuffer.charAt(n) == '>' || stringBuffer.charAt(n) == ';') {
                stringBuffer.insert(n, "\\");
                ++n;
                ++n2;
            }
            ++n;
        }
    }

    private DERObjectIdentifier decodeOID(String string, Hashtable hashtable) {
        if (string.toUpperCase().startsWith("OID.")) {
            return new DERObjectIdentifier(string.substring(4));
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            return new DERObjectIdentifier(string);
        }
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)hashtable.get(string.toLowerCase());
        if (dERObjectIdentifier == null) {
            throw new IllegalArgumentException("Unknown object id - " + string + " - passed to distinguished name");
        }
        return dERObjectIdentifier;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        if (this.getDERObject().equals(x509Name.getDERObject())) {
            return true;
        }
        int n = this.ordering.size();
        if (n != x509Name.ordering.size()) {
            return false;
        }
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            String string = ((DERObjectIdentifier)this.ordering.elementAt(n2)).getId();
            String string2 = (String)this.values.elementAt(n2);
            int n3 = 0;
            while (n3 < n) {
                if (!blArray[n3]) {
                    String string3 = ((DERObjectIdentifier)x509Name.ordering.elementAt(n3)).getId();
                    String string4 = (String)x509Name.values.elementAt(n3);
                    if (string.equals(string3)) {
                        char c;
                        int n4;
                        char c2;
                        if ((string2 = string2.trim().toLowerCase()).equals(string4 = string4.trim().toLowerCase())) {
                            blArray[n3] = true;
                            bl = true;
                            break;
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        if (string2.length() != 0) {
                            c2 = string2.charAt(0);
                            stringBuffer.append(c2);
                            n4 = 1;
                            while (n4 < string2.length()) {
                                c = string2.charAt(n4);
                                if (c2 != ' ' || c != ' ') {
                                    stringBuffer.append(c);
                                }
                                c2 = c;
                                ++n4;
                            }
                        }
                        if (string4.length() != 0) {
                            c2 = string4.charAt(0);
                            stringBuffer2.append(c2);
                            n4 = 1;
                            while (n4 < string4.length()) {
                                c = string4.charAt(n4);
                                if (c2 != ' ' || c != ' ') {
                                    stringBuffer2.append(c);
                                }
                                c2 = c;
                                ++n4;
                            }
                        }
                        if (stringBuffer.toString().equals(stringBuffer2.toString())) {
                            blArray[n3] = true;
                            bl = true;
                            break;
                        }
                    }
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object, boolean bl) {
        if (object == this) {
            return true;
        }
        if (!bl) {
            return this.equals(object);
        }
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        int n = this.ordering.size();
        if (n != x509Name.ordering.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = ((DERObjectIdentifier)this.ordering.elementAt(n2)).getId();
            String string2 = (String)this.values.elementAt(n2);
            String string3 = ((DERObjectIdentifier)x509Name.ordering.elementAt(n2)).getId();
            String string4 = (String)x509Name.values.elementAt(n2);
            if (string.equals(string3)) {
                if (!(string2 = string2.trim().toLowerCase()).equals(string4 = string4.trim().toLowerCase())) {
                    char c;
                    int n3;
                    char c2;
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (string2.length() != 0) {
                        c2 = string2.charAt(0);
                        stringBuffer.append(c2);
                        n3 = 1;
                        while (n3 < string2.length()) {
                            c = string2.charAt(n3);
                            if (c2 != ' ' || c != ' ') {
                                stringBuffer.append(c);
                            }
                            c2 = c;
                            ++n3;
                        }
                    }
                    if (string4.length() != 0) {
                        c2 = string4.charAt(0);
                        stringBuffer2.append(c2);
                        n3 = 1;
                        while (n3 < string4.length()) {
                            c = string4.charAt(n3);
                            if (c2 != ' ' || c != ' ') {
                                stringBuffer2.append(c);
                            }
                            c2 = c;
                            ++n3;
                        }
                    }
                    if (!stringBuffer.toString().equals(stringBuffer2.toString())) {
                        return false;
                    }
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public DERObject getDERObject() {
        if (this.seq == null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            DERObjectIdentifier dERObjectIdentifier = null;
            int n = 0;
            while (n != this.ordering.size()) {
                ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
                DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)this.ordering.elementAt(n);
                aSN1EncodableVector3.add(dERObjectIdentifier2);
                String string = (String)this.values.elementAt(n);
                aSN1EncodableVector3.add(this.converter.getConvertedValue(dERObjectIdentifier2, string));
                if (dERObjectIdentifier == null || ((Boolean)this.added.elementAt(n)).booleanValue()) {
                    aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector3));
                } else {
                    aSN1EncodableVector.add(new DERSet(aSN1EncodableVector2));
                    aSN1EncodableVector2 = new ASN1EncodableVector();
                    aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector3));
                }
                dERObjectIdentifier = dERObjectIdentifier2;
                ++n;
            }
            aSN1EncodableVector.add(new DERSet(aSN1EncodableVector2));
            this.seq = new DERSequence(aSN1EncodableVector);
        }
        return this.seq;
    }

    public static X509Name getInstance(Object object) {
        if (object == null || object instanceof X509Name) {
            return (X509Name)object;
        }
        if (object instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public static X509Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X509Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public Vector getOIDs() {
        Vector vector = new Vector();
        int n = 0;
        while (n != this.ordering.size()) {
            vector.addElement(this.ordering.elementAt(n));
            ++n;
        }
        return vector;
    }

    public Vector getValues() {
        Vector vector = new Vector();
        int n = 0;
        while (n != this.values.size()) {
            vector.addElement(this.values.elementAt(n));
            ++n;
        }
        return vector;
    }

    public int hashCode() {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.getDERObject();
        Enumeration enumeration = aSN1Sequence.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            n ^= enumeration.nextElement().hashCode();
        }
        return n;
    }

    public String toString() {
        return this.toString(DefaultReverse, DefaultSymbols);
    }

    public String toString(boolean bl, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        if (bl) {
            int n = this.ordering.size() - 1;
            while (n >= 0) {
                if (bl2) {
                    bl2 = false;
                } else if (((Boolean)this.added.elementAt(n + 1)).booleanValue()) {
                    stringBuffer.append("+");
                } else {
                    stringBuffer.append(",");
                }
                this.appendValue(stringBuffer, hashtable, (DERObjectIdentifier)this.ordering.elementAt(n), (String)this.values.elementAt(n));
                --n;
            }
        } else {
            int n = 0;
            while (n < this.ordering.size()) {
                if (bl2) {
                    bl2 = false;
                } else if (((Boolean)this.added.elementAt(n)).booleanValue()) {
                    stringBuffer.append("+");
                } else {
                    stringBuffer.append(",");
                }
                this.appendValue(stringBuffer, hashtable, (DERObjectIdentifier)this.ordering.elementAt(n), (String)this.values.elementAt(n));
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

