/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.jce.interfaces.ElGamalKey;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = publicKeyEncSessionPacket;
    }

    private static Cipher getKeyCipher(int n, String string) throws NoSuchProviderException, PGPException {
        try {
            switch (n) {
                case 1: 
                case 2: {
                    return Cipher.getInstance("RSA/ECB/PKCS1Padding", string);
                }
                case 16: 
                case 20: {
                    return Cipher.getInstance("ElGamal/ECB/PKCS1Padding", string);
                }
            }
            throw new PGPException("unknown asymmetric algorithm: " + n);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    private boolean confirmCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        return byArray[byArray.length - 2] == (byte)(n >> 8) && byArray[byArray.length - 1] == (byte)n;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, String string) throws PGPException, NoSuchProviderException {
        Cipher cipher;
        int n;
        byte[] byArray;
        Object object;
        Object object2;
        Cipher cipher2 = PGPPublicKeyEncryptedData.getKeyCipher(this.keyData.getAlgorithm(), string);
        try {
            cipher2.init(2, pGPPrivateKey.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        BigInteger[] bigIntegerArray = this.keyData.getEncSessionKey();
        if (this.keyData.getAlgorithm() == 2 || this.keyData.getAlgorithm() == 1) {
            object2 = bigIntegerArray[0].toByteArray();
            if (object2[0] == 0) {
                cipher2.update((byte[])object2, 1, ((byte[])object2).length - 1);
            } else {
                cipher2.update((byte[])object2);
            }
        } else {
            object2 = (ElGamalKey)pGPPrivateKey.getKey();
            int n2 = (object2.getParams().getP().bitLength() + 7) / 8;
            object = new byte[n2];
            byArray = bigIntegerArray[0].toByteArray();
            if (byArray.length > n2) {
                cipher2.update(byArray, 1, byArray.length - 1);
            } else {
                System.arraycopy(byArray, 0, object, ((byte[])object).length - byArray.length, byArray.length);
                cipher2.update((byte[])object);
            }
            byArray = bigIntegerArray[1].toByteArray();
            for (n = 0; n != ((byte[])object).length; ++n) {
                object[n] = 0;
            }
            if (byArray.length > n2) {
                cipher2.update(byArray, 1, byArray.length - 1);
            } else {
                System.arraycopy(byArray, 0, object, ((byte[])object).length - byArray.length, byArray.length);
                cipher2.update((byte[])object);
            }
        }
        try {
            object2 = cipher2.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting secret key", exception);
        }
        if (!this.confirmCheckSum((byte[])object2)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        try {
            cipher = this.encData instanceof SymmetricEncIntegrityPacket ? Cipher.getInstance(PGPUtil.getSymmetricCipherName(object2[0]) + "/CFB/NoPadding", string) : Cipher.getInstance(PGPUtil.getSymmetricCipherName(object2[0]) + "/OpenPGPCFB/NoPadding", string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception creating cipher", exception);
        }
        if (cipher != null) {
            try {
                int n3;
                object = new SecretKeySpec((byte[])object2, 1, ((byte[])object2).length - 3, PGPUtil.getSymmetricCipherName(object2[0]));
                byArray = new byte[cipher.getBlockSize()];
                cipher.init(2, (Key)object, new IvParameterSpec(byArray));
                this.encStream = new BCPGInputStream(new CipherInputStream(this.encData.getInputStream(), cipher));
                if (this.encData instanceof SymmetricEncIntegrityPacket) {
                    this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                    this.encStream = new DigestInputStream(this.truncStream, MessageDigest.getInstance(PGPUtil.getDigestName(2), string));
                }
                for (n = 0; n != byArray.length; ++n) {
                    n3 = this.encStream.read();
                    if (n3 < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                    byArray[n] = (byte)n3;
                }
                n = this.encStream.read();
                n3 = this.encStream.read();
                if (n < 0 || n3 < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                if (byArray[byArray.length - 2] != (byte)n && n != 0) {
                    throw new PGPDataValidationException("data check failed.");
                }
                if (byArray[byArray.length - 1] != (byte)n3 && n3 != 0) {
                    throw new PGPDataValidationException("data check failed.");
                }
                return this.encStream;
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception starting decryption", exception);
            }
        }
        return this.encData.getInputStream();
    }
}

