/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.encodings.ISO9796d1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ParametersWithSalt;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.ISO9796d2PSSSigner;
import org.bouncycastle.crypto.signers.ISO9796d2Signer;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class ISO9796Test
implements Test {
    static BigInteger mod1 = new BigInteger("0100000000000000000000000000000000bba2d15dbb303c8a21c5ebbcbae52b7125087920dd7cdf358ea119fd66fb064012ec8ce692f0a0b8e8321b041acd40b7", 16);
    static BigInteger pub1 = new BigInteger("03", 16);
    static BigInteger pri1 = new BigInteger("2aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaac9f0783a49dd5f6c5af651f4c9d0dc9281c96a3f16a85f9572d7cc3f2d0f25a9dbf1149e4cdc32273faadd3fda5dcda7", 16);
    static BigInteger mod2 = new BigInteger("ffffff7fa27087c35ebead78412d2bdffe0301edd494df13458974ea89b364708f7d0f5a00a50779ddf9f7d4cb80b8891324da251a860c4ec9ef288104b3858d", 16);
    static BigInteger pub2 = new BigInteger("03", 16);
    static BigInteger pri2 = new BigInteger("2aaaaa9545bd6bf5e51fc7940adcdca5550080524e18cfd88b96e8d1c19de6121b13fac0eb0495d47928e047724d91d1740f6968457ce53ec8e24c9362ce84b5", 16);
    static byte[] msg1 = Hex.decode((String)"0cbbaa99887766554433221100");
    static byte[] sig1 = mod1.subtract(new BigInteger("309f873d8ded8379490f6097eaafdabc137d3ebfd8f25ab5f138d56a719cdc526bdd022ea65dabab920a81013a85d092e04d3e421caab717c90d89ea45a8d23a", 16)).toByteArray();
    static byte[] msg2 = Hex.decode((String)"fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210");
    static byte[] sig2 = new BigInteger("319bb9becb49f3ed1bca26d0fcf09b0b0a508e4d0bd43b350f959b72cd25b3af47d608fdcd248eada74fbe19990dbeb9bf0da4b4e1200243a14e5cab3f7e610c", 16).toByteArray();
    static byte[] msg3 = Hex.decode((String)"0112233445566778899aabbccd");
    static byte[] sig3 = mod2.subtract(new BigInteger("58e59ffb4b1fb1bcdbf8d1fe9afa3730c78a318a1134f5791b7313d480ff07ac319b068edf8f212945cb09cf33df30ace54f4a063fcca0b732f4b662dc4e2454", 16)).toByteArray();
    static BigInteger mod3 = new BigInteger("ffffffff78f6c55506c59785e871211ee120b0b5dd644aa796d82413a47b24573f1be5745b5cd9950f6b389b52350d4e01e90009669a8720bf265a2865994190a661dea3c7828e2e7ca1b19651adc2d5", 16);
    static BigInteger pub3 = new BigInteger("03", 16);
    static BigInteger pri3 = new BigInteger("2aaaaaaa942920e38120ee965168302fd0301d73a4e60c7143ceb0adf0bf30b9352f50e8b9e4ceedd65343b2179005b2f099915e4b0c37e41314bb0821ad8330d23cba7f589e0f129b04c46b67dfce9d", 16);
    static BigInteger mod4 = new BigInteger("FFFFFFFF45f1903ebb83d4d363f70dc647b839f2a84e119b8830b2dec424a1ce0c9fd667966b81407e89278283f27ca8857d40979407fc6da4cc8a20ecb4b8913b5813332409bc1f391a94c9c328dfe46695daf922259174544e2bfbe45cc5cd", 16);
    static BigInteger pub4 = new BigInteger("02", 16);
    static BigInteger pri4 = new BigInteger("1fffffffe8be3207d7707a9a6c7ee1b8c8f7073e5509c2337106165bd8849439c193faccf2cd70280fd124f0507e4f94cb66447680c6b87b6599d1b61c8f3600854a618262e9c1cb1438e485e47437be036d94b906087a61ee74ab0d9a1accd8", 16);
    static byte[] msg4 = Hex.decode((String)"6162636462636465636465666465666765666768666768696768696a68696a6b696a6b6c6a6b6c6d6b6c6d6e6c6d6e6f6d6e6f706e6f7071");
    static byte[] sig4 = Hex.decode((String)"374695b7ee8b273925b4656cc2e008d41463996534aa5aa5afe72a52ffd84e118085f8558f36631471d043ad342de268b94b080bee18a068c10965f581e7f32899ad378835477064abed8ef3bd530fce");
    static byte[] msg5 = Hex.decode((String)"fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210");
    static byte[] sig5 = Hex.decode((String)"5cf9a01854dbacaec83aae8efc563d74538192e95466babacd361d7c86000fe42dcb4581e48e4feb862d04698da9203b1803b262105104d510b365ee9c660857ba1c001aa57abfd1c8de92e47c275cae");
    static BigInteger mod6 = new BigInteger("b259d2d6e627a768c94be36164c2d9fc79d97aab9253140e5bf17751197731d6f7540d2509e7b9ffee0a70a6e26d56e92d2edd7f85aba85600b69089f35f6bdbf3c298e05842535d9f064e6b0391cb7d306e0a2d20c4dfb4e7b49a9640bdea26c10ad69c3f05007ce2513cee44cfe01998e62b6c3637d3fc0391079b26ee36d5", 16);
    static BigInteger pub6 = new BigInteger("11", 16);
    static BigInteger pri6 = new BigInteger("92e08f83cc9920746989ca5034dcb384a094fb9c5a6288fcc4304424ab8f56388f72652d8fafc65a4b9020896f2cde297080f2a540e7b7ce5af0b3446e1258d1dd7f245cf54124b4c6e17da21b90a0ebd22605e6f45c9f136d7a13eaac1c0f7487de8bd6d924972408ebb58af71e76fd7b012a8d0e165f3ae2e5077a8648e619", 16);
    static byte[] sig6 = new BigInteger("0073FEAF13EB12914A43FE635022BB4AB8188A8F3ABD8D8A9E4AD6C355EE920359C7F237AE36B1212FE947F676C68FE362247D27D1F298CA9302EB21F4A64C26CE44471EF8C0DFE1A54606F0BA8E63E87CDACA993BFA62973B567473B4D38FAE73AB228600934A9CC1D3263E632E21FD52D2B95C5F7023DA63DE9509C01F6C7BBC", 16).modPow(pri6, mod6).toByteArray();
    static byte[] msg7 = Hex.decode((String)"6162636462636465636465666465666765666768666768696768696A68696A6B696A6B6C6A6B6C6D6B6C6D6E6C6D6E6F6D6E6F706E6F70716F70717270717273");
    static byte[] sig7 = new BigInteger("296B06224010E1EC230D4560A5F88F03550AAFCE31C805CE81E811E5E53E5F71AE64FC2A2A486B193E87972D90C54B807A862F21A21919A43ECF067240A8C8C641DE8DCDF1942CF790D136728FFC0D98FB906E7939C1EC0E64C0E067F0A7443D6170E411DF91F797D1FFD74009C4638462E69D5923E7433AEC028B9A90E633CC", 16).modPow(pri6, mod6).toByteArray();
    static byte[] msg8 = Hex.decode((String)"FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA9876543210FEDCBA98");
    static byte[] sig8 = new BigInteger("01402B29ABA104079677CE7FC3D5A84DB24494D6F9508B4596484F5B3CC7E8AFCC4DDE7081F21CAE9D4F94D6D2CCCB43FCEDA0988FFD4EF2EAE72CFDEB4A2638F0A34A0C49664CD9DB723315759D758836C8BA26AC4348B66958AC94AE0B5A75195B57ABFB9971E21337A4B517F2E820B81F26BCE7C66F48A2DB12A8F3D731CC", 16).modPow(pri6, mod6).toByteArray();
    static byte[] msg9 = Hex.decode((String)"6162636462636465636465666465666765666768666768696768696A68696A6B696A6B6C6A6B6C6D6B6C6D6E6C6D6E6F6D6E6F706E6F70716F707172707172737172737472737475737475767475767775767778767778797778797A78797A61797A61627A6162636162636462636465");
    static byte[] sig9 = new BigInteger("6F2BB97571FE2EF205B66000E9DD06656655C1977F374E8666D636556A5FEEEEAF645555B25F45567C4EE5341F96FED86508C90A9E3F11B26E8D496139ED3E55ECE42860A6FB3A0817DAFBF13019D93E1D382DA07264FE99D9797D2F0B7779357CA7E74EE440D8855B7DDF15F000AC58EE3FFF144845E771907C0C83324A6FBC", 16).modPow(pri6, mod6).toByteArray();

    public String getName() {
        return "ISO9796";
    }

    private boolean isSameAs(byte[] byArray, int n, byte[] byArray2) {
        if (byArray.length - n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 != byArray2.length) {
            if (byArray[n2 + n] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private TestResult doTest1() {
        byte[] byArray;
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod1, pub1);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod1, pri1);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d1Encoding iSO9796d1Encoding = new ISO9796d1Encoding((AsymmetricBlockCipher)rSAEngine);
        iSO9796d1Encoding.init(true, (CipherParameters)rSAKeyParameters2);
        iSO9796d1Encoding.setPadBits(4);
        try {
            byArray = iSO9796d1Encoding.processBlock(msg1, 0, msg1.length);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d1Encoding.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(sig1, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-1 generation Test 1");
        }
        try {
            byArray = iSO9796d1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        if (!this.isSameAs(msg1, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-1 retrieve Test 1");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    private TestResult doTest2() {
        byte[] byArray;
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod1, pub1);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod1, pri1);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d1Encoding iSO9796d1Encoding = new ISO9796d1Encoding((AsymmetricBlockCipher)rSAEngine);
        iSO9796d1Encoding.init(true, (CipherParameters)rSAKeyParameters2);
        try {
            byArray = iSO9796d1Encoding.processBlock(msg2, 0, msg2.length);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d1Encoding.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(byArray, 1, sig2)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-1 generation Test 2");
        }
        try {
            byArray = iSO9796d1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        if (!this.isSameAs(msg2, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-1 retrieve Test 2");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    public TestResult doTest3() {
        byte[] byArray;
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod2, pub2);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod2, pri2);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d1Encoding iSO9796d1Encoding = new ISO9796d1Encoding((AsymmetricBlockCipher)rSAEngine);
        iSO9796d1Encoding.init(true, (CipherParameters)rSAKeyParameters2);
        iSO9796d1Encoding.setPadBits(4);
        try {
            byArray = iSO9796d1Encoding.processBlock(msg3, 0, msg3.length);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d1Encoding.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(sig3, 1, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-1 generation Test 3");
        }
        try {
            byArray = iSO9796d1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        if (!this.isSameAs(msg3, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-1 retrieve Test 3");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    public TestResult doTest4() {
        byte[] byArray;
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod3, pub3);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod3, pri3);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d2Signer iSO9796d2Signer = new ISO9796d2Signer((AsymmetricBlockCipher)rSAEngine, (Digest)new RIPEMD128Digest());
        iSO9796d2Signer.init(true, (CipherParameters)rSAKeyParameters2);
        try {
            iSO9796d2Signer.update(msg4[0]);
            iSO9796d2Signer.update(msg4, 1, msg4.length - 1);
            byArray = iSO9796d2Signer.generateSignature();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d2Signer.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(sig4, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 generation Test 4");
        }
        iSO9796d2Signer.update(msg4[0]);
        iSO9796d2Signer.update(msg4, 1, msg4.length - 1);
        if (!iSO9796d2Signer.verifySignature(sig4)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 verify Test 4");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    public TestResult doTest5() {
        byte[] byArray;
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod3, pub3);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod3, pri3);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d2Signer iSO9796d2Signer = new ISO9796d2Signer((AsymmetricBlockCipher)rSAEngine, (Digest)new RIPEMD160Digest(), true);
        iSO9796d2Signer.init(true, (CipherParameters)rSAKeyParameters2);
        try {
            iSO9796d2Signer.update(msg5[0]);
            iSO9796d2Signer.update(msg5, 1, msg5.length - 1);
            byArray = iSO9796d2Signer.generateSignature();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d2Signer.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(sig5, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 generation Test 5");
        }
        iSO9796d2Signer.update(msg5[0]);
        iSO9796d2Signer.update(msg5, 1, msg5.length - 1);
        if (!iSO9796d2Signer.verifySignature(sig5)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 verify Test 5");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    public TestResult doTest6() {
        byte[] byArray;
        byte[] byArray2 = Hex.decode((String)"61DF870C4890FE85D6E3DD87C3DCE3723F91DB49");
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod6, pub6);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod6, pri6);
        ParametersWithSalt parametersWithSalt = new ParametersWithSalt((CipherParameters)rSAKeyParameters2, byArray2);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d2PSSSigner iSO9796d2PSSSigner = new ISO9796d2PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)new RIPEMD160Digest(), 20, true);
        iSO9796d2PSSSigner.init(true, (CipherParameters)parametersWithSalt);
        try {
            byArray = iSO9796d2PSSSigner.generateSignature();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d2PSSSigner.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(sig6, 1, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 generation Test 6");
        }
        if (!iSO9796d2PSSSigner.verifySignature(sig6)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 verify Test 6");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    public TestResult doTest7() {
        byte[] byArray;
        byte[] byArray2 = new byte[]{};
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod6, pub6);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod6, pri6);
        ParametersWithSalt parametersWithSalt = new ParametersWithSalt((CipherParameters)rSAKeyParameters2, byArray2);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d2PSSSigner iSO9796d2PSSSigner = new ISO9796d2PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)new SHA1Digest(), 0, false);
        iSO9796d2PSSSigner.init(true, (CipherParameters)parametersWithSalt);
        try {
            iSO9796d2PSSSigner.update(msg7[0]);
            iSO9796d2PSSSigner.update(msg7, 1, msg7.length - 1);
            byArray = iSO9796d2PSSSigner.generateSignature();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d2PSSSigner.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(sig7, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 generation Test 7");
        }
        iSO9796d2PSSSigner.update(msg7[0]);
        iSO9796d2PSSSigner.update(msg7, 1, msg7.length - 1);
        if (!iSO9796d2PSSSigner.verifySignature(sig7)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 verify Test 7");
        }
        if (!this.isSameAs(msg7, 0, iSO9796d2PSSSigner.getRecoveredMessage())) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 recovery Test 7");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    public TestResult doTest8() {
        byte[] byArray;
        byte[] byArray2 = Hex.decode((String)"78E293203CBA1B7F92F05F4D171FF8CA3E738FF8");
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod6, pub6);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod6, pri6);
        ParametersWithSalt parametersWithSalt = new ParametersWithSalt((CipherParameters)rSAKeyParameters2, byArray2);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d2PSSSigner iSO9796d2PSSSigner = new ISO9796d2PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)new RIPEMD160Digest(), 20, false);
        iSO9796d2PSSSigner.init(true, (CipherParameters)parametersWithSalt);
        try {
            iSO9796d2PSSSigner.update(msg8[0]);
            iSO9796d2PSSSigner.update(msg8, 1, msg8.length - 1);
            byArray = iSO9796d2PSSSigner.generateSignature();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d2PSSSigner.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(sig8, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 generation Test 8");
        }
        iSO9796d2PSSSigner.update(msg8[0]);
        iSO9796d2PSSSigner.update(msg8, 1, msg8.length - 1);
        if (!iSO9796d2PSSSigner.verifySignature(sig8)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 verify Test 8");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    public TestResult doTest9() {
        byte[] byArray;
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod6, pub6);
        RSAKeyParameters rSAKeyParameters2 = new RSAKeyParameters(true, mod6, pri6);
        RSAEngine rSAEngine = new RSAEngine();
        ISO9796d2PSSSigner iSO9796d2PSSSigner = new ISO9796d2PSSSigner((AsymmetricBlockCipher)rSAEngine, (Digest)new RIPEMD160Digest(), 0, true);
        iSO9796d2PSSSigner.init(true, (CipherParameters)rSAKeyParameters2);
        try {
            iSO9796d2PSSSigner.update(msg9[0]);
            iSO9796d2PSSSigner.update(msg9, 1, msg9.length - 1);
            byArray = iSO9796d2PSSSigner.generateSignature();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, "ISO9796: failed - exception " + exception.toString());
        }
        iSO9796d2PSSSigner.init(false, (CipherParameters)rSAKeyParameters);
        if (!this.isSameAs(sig9, 0, byArray)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 generation Test 9");
        }
        iSO9796d2PSSSigner.update(msg9[0]);
        iSO9796d2PSSSigner.update(msg9, 1, msg9.length - 1);
        if (!iSO9796d2PSSSigner.verifySignature(sig9)) {
            return new SimpleTestResult(false, "ISO9796: failed ISO9796-2 verify Test 9");
        }
        return new SimpleTestResult(true, "ISO9796: Okay");
    }

    public TestResult perform() {
        TestResult testResult = this.doTest1();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.doTest2();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.doTest3();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.doTest4();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.doTest5();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.doTest6();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.doTest7();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.doTest8();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return this.doTest9();
    }

    public static void main(String[] stringArray) {
        ISO9796Test iSO9796Test = new ISO9796Test();
        TestResult testResult = iSO9796Test.perform();
        System.out.println(testResult);
    }
}

