/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class ECIESTest
implements Test {
    ECIESTest() {
    }

    public String getName() {
        return "ECIES";
    }

    private boolean sameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult perform() {
        Object object;
        Object object2;
        SecureRandom secureRandom = new SecureRandom();
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
        eCKeyPairGenerator.init((KeyGenerationParameters)eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = eCKeyPairGenerator.generateKeyPair();
        IESEngine iESEngine = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
        IESEngine iESEngine2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()));
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters iESParameters = new IESParameters(byArray, byArray2, 64);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), (CipherParameters)iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), (CipherParameters)iESParameters);
        byte[] byArray3 = Hex.decode((String)"1234567890abcdef");
        try {
            object2 = iESEngine.processBlock(byArray3, 0, byArray3.length);
            object = iESEngine2.processBlock(object2, 0, ((byte[])object2).length);
            if (!this.sameAs((byte[])object, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": stream cipher test failed");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": stream cipher test exception " + exception.toString());
        }
        object2 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new TwofishEngine()));
        object = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new TwofishEngine()));
        iESEngine = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)object2);
        iESEngine2 = new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)object);
        byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        iESParameters = new IESWithCipherParameters(byArray, byArray2, 64, 128);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), (CipherParameters)iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), (CipherParameters)iESParameters);
        byArray3 = Hex.decode((String)"1234567890abcdef");
        try {
            byte[] byArray4 = iESEngine.processBlock(byArray3, 0, byArray3.length);
            byte[] byArray5 = iESEngine2.processBlock(byArray4, 0, byArray4.length);
            if (!this.sameAs(byArray5, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": twofish cipher test failed");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": twofish cipher test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        ECIESTest eCIESTest = new ECIESTest();
        TestResult testResult = eCIESTest.perform();
        System.out.println(testResult);
    }
}

