/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class DSATest
implements Test {
    SecureRandom random = new SecureRandom(){
        boolean first = true;

        public void nextBytes(byte[] byArray) {
            byte[] byArray2 = Hex.decode((String)"d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
            byte[] byArray3 = Hex.decode((String)"345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
            if (this.first) {
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                this.first = false;
            } else {
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            }
        }
    };
    Test[] tests = new Test[]{new CompatTest(), new ECDSA239bitPrime(), new GenerationTest(), new ParametersTest()};
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    protected BigInteger[] derDecode(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DERInputStream dERInputStream = new DERInputStream((InputStream)byteArrayInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
        BigInteger[] bigIntegerArray = new BigInteger[]{((DERInteger)aSN1Sequence.getObjectAt(0)).getValue(), ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue()};
        return bigIntegerArray;
    }

    public String getName() {
        return "DSA/ECDSA";
    }

    public TestResult perform() {
        for (int i = 0; i != this.tests.length; ++i) {
            TestResult testResult = this.tests[i].perform();
            if (testResult.isSuccessful()) continue;
            return testResult;
        }
        return new SimpleTestResult(true, "DSA/ECDSA: Okay");
    }

    private boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        DSATest dSATest = new DSATest();
        TestResult testResult = dSATest.perform();
        System.out.println(testResult.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ParametersTest
    implements Test {
        private ParametersTest() {
        }

        public String getName() {
            return "DSA Parameters";
        }

        public TestResult perform() {
            try {
                AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA", "BC");
                algorithmParameterGenerator.init(512, DSATest.this.random);
                AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
                byte[] byArray = algorithmParameters.getEncoded();
                AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance("DSA", "BC");
                algorithmParameters2.init(byArray);
                byte[] byArray2 = algorithmParameters2.getEncoded();
                if (!DSATest.this.arrayEquals(byArray, byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": encode/decode parameters failed");
                }
                DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSATest.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
                keyPairGenerator.initialize(dSAParameterSpec, new SecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                Signature signature = Signature.getInstance("DSA", "BC");
                byte[] byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
                signature.initSign(privateKey);
                signature.update(byArray3);
                byte[] byArray4 = signature.sign();
                signature = Signature.getInstance("DSA", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray3);
                if (!signature.verify(byArray4)) {
                    return new SimpleTestResult(false, this.getName() + ": DSA verification failed");
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }

    private class GenerationTest
    implements Test {
        private GenerationTest() {
        }

        public String getName() {
            return "EC/ECDSA Generation";
        }

        public TestResult perform() {
            try {
                Signature signature = Signature.getInstance("DSA", "BC");
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
                byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
                keyPairGenerator.initialize(512, new SecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                signature.initSign(privateKey);
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                signature = Signature.getInstance("DSA", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": DSA verification failed");
                }
                signature = Signature.getInstance("ECDSA", "BC");
                keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
                ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
                ECParameterSpec eCParameterSpec = new ECParameterSpec((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
                keyPairGenerator.initialize((AlgorithmParameterSpec)eCParameterSpec, new SecureRandom());
                keyPair = keyPairGenerator.generateKeyPair();
                privateKey = keyPair.getPrivate();
                publicKey = keyPair.getPublic();
                signature.initSign(privateKey);
                signature.update(byArray);
                byArray2 = signature.sign();
                signature = Signature.getInstance("ECDSA", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": ECDSA verification failed");
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }

    private class ECDSA239bitPrime
    implements Test {
        BigInteger r = new BigInteger("308636143175167811492622547300668018854959378758531778147462058306432176");
        BigInteger s = new BigInteger("323813553209797357708078776831250505931891051755007842781978505179448783");
        SecureRandom k = new SecureRandom(this){
            private final /* synthetic */ ECDSA239bitPrime this$1;
            {
                this.this$1 = eCDSA239bitPrime;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = new BigInteger("700000017569056646655505781757157107570501575775705779575555657156756655").toByteArray();
                System.arraycopy(byArray2, byArray2.length - byArray.length, byArray, 0, byArray.length);
            }
        };

        private ECDSA239bitPrime() {
        }

        public String getName() {
            return "ECDSA 239 bit prime";
        }

        public TestResult perform() {
            try {
                ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
                ECParameterSpec eCParameterSpec = new ECParameterSpec((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
                ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("876300101507107567501066130761671078357010671067781776716671676178726717"), eCParameterSpec);
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(fp.decodePoint(Hex.decode((String)"025b6dc53bc61a2548ffb0f671472de6c9521a9d2d2534e65abfcbd5fe0c70")), eCParameterSpec);
                Signature signature = Signature.getInstance("ECDSA", "BC");
                KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
                PrivateKey privateKey = keyFactory.generatePrivate((KeySpec)eCPrivateKeySpec);
                PublicKey publicKey = keyFactory.generatePublic((KeySpec)eCPublicKeySpec);
                signature.initSign(privateKey, this.k);
                byte[] byArray = new byte[]{97, 98, 99};
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": 239 Bit EC verification failed");
                }
                BigInteger[] bigIntegerArray = DSATest.this.derDecode(byArray2);
                if (!this.r.equals(bigIntegerArray[0])) {
                    return new SimpleTestResult(false, this.getName() + ": r component wrong." + System.getProperty("line.separator") + " expecting: " + this.r + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
                }
                if (!this.s.equals(bigIntegerArray[1])) {
                    return new SimpleTestResult(false, this.getName() + ": s component wrong." + System.getProperty("line.separator") + " expecting: " + this.s + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }

    private class CompatTest
    implements Test {
        private CompatTest() {
        }

        public TestResult perform() {
            try {
                X509EncodedKeySpec x509EncodedKeySpec;
                Signature signature = Signature.getInstance("DSA", "SUN");
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "SUN");
                byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
                keyPairGenerator.initialize(512, new SecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                signature.initSign(privateKey);
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                signature = Signature.getInstance("DSA", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": SUN -> BC verification failed");
                }
                signature.initSign(privateKey);
                signature.update(byArray);
                byArray2 = signature.sign();
                signature = Signature.getInstance("DSA", "SUN");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": BC -> SUN verification failed");
                }
                KeyFactory keyFactory = KeyFactory.getInstance("DSA", "BC");
                DSAPublicKey dSAPublicKey = (DSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded()));
                if (!dSAPublicKey.getY().equals(((DSAPublicKey)publicKey).getY())) {
                    return new SimpleTestResult(false, this.getName() + ": public number not decoded properly");
                }
                if (!dSAPublicKey.getParams().getG().equals(((DSAPublicKey)publicKey).getParams().getG())) {
                    return new SimpleTestResult(false, this.getName() + ": public generator not decoded properly");
                }
                if (!dSAPublicKey.getParams().getP().equals(((DSAPublicKey)publicKey).getParams().getP())) {
                    return new SimpleTestResult(false, this.getName() + ": public p value not decoded properly");
                }
                if (!dSAPublicKey.getParams().getQ().equals(((DSAPublicKey)publicKey).getParams().getQ())) {
                    return new SimpleTestResult(false, this.getName() + ": public q value not decoded properly");
                }
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                if (!dSAPrivateKey.getX().equals(((DSAPrivateKey)privateKey).getX())) {
                    return new SimpleTestResult(false, this.getName() + ": private number not decoded properly");
                }
                if (!dSAPrivateKey.getParams().getG().equals(((DSAPrivateKey)privateKey).getParams().getG())) {
                    return new SimpleTestResult(false, this.getName() + ": private generator not decoded properly");
                }
                if (!dSAPrivateKey.getParams().getP().equals(((DSAPrivateKey)privateKey).getParams().getP())) {
                    return new SimpleTestResult(false, this.getName() + ": private p value not decoded properly");
                }
                if (!dSAPrivateKey.getParams().getQ().equals(((DSAPrivateKey)privateKey).getParams().getQ())) {
                    return new SimpleTestResult(false, this.getName() + ": private q value not decoded properly");
                }
                keyFactory = KeyFactory.getInstance("DSA", "SUN");
                x509EncodedKeySpec = new X509EncodedKeySpec(dSAPublicKey.getEncoded());
                publicKey = (DSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
                if (!dSAPublicKey.getY().equals(((DSAPublicKey)publicKey).getY())) {
                    return new SimpleTestResult(false, this.getName() + ": public number not decoded properly");
                }
                if (!dSAPublicKey.getParams().getG().equals(((DSAPublicKey)publicKey).getParams().getG())) {
                    return new SimpleTestResult(false, this.getName() + ": public generator not decoded properly");
                }
                if (!dSAPublicKey.getParams().getP().equals(((DSAPublicKey)publicKey).getParams().getP())) {
                    return new SimpleTestResult(false, this.getName() + ": public p value not decoded properly");
                }
                if (!dSAPublicKey.getParams().getQ().equals(((DSAPublicKey)publicKey).getParams().getQ())) {
                    return new SimpleTestResult(false, this.getName() + ": public q value not decoded properly");
                }
                pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(dSAPrivateKey.getEncoded());
                privateKey = (DSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                if (!dSAPrivateKey.getX().equals(((DSAPrivateKey)privateKey).getX())) {
                    return new SimpleTestResult(false, this.getName() + ": private number not decoded properly");
                }
                if (!dSAPrivateKey.getParams().getG().equals(((DSAPrivateKey)privateKey).getParams().getG())) {
                    return new SimpleTestResult(false, this.getName() + ": private generator not decoded properly");
                }
                if (!dSAPrivateKey.getParams().getP().equals(((DSAPrivateKey)privateKey).getParams().getP())) {
                    return new SimpleTestResult(false, this.getName() + ": private p value not decoded properly");
                }
                if (!dSAPrivateKey.getParams().getQ().equals(((DSAPrivateKey)privateKey).getParams().getQ())) {
                    return new SimpleTestResult(false, this.getName() + ": private q value not decoded properly");
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }

        public String getName() {
            return "DSA Compatability Test";
        }
    }
}

