/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;

public class PublicKeyEncSessionPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int version;
    private long keyID;
    private int algorithm;
    private BigInteger[] data;

    public PublicKeyEncSessionPacket(long l, int n, BigInteger[] bigIntegerArray) {
        this.version = 3;
        this.keyID = l;
        this.algorithm = n;
        this.data = bigIntegerArray;
    }

    PublicKeyEncSessionPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.version = bCPGInputStream.read();
        this.keyID |= (long)bCPGInputStream.read() << 56;
        this.keyID |= (long)bCPGInputStream.read() << 48;
        this.keyID |= (long)bCPGInputStream.read() << 40;
        this.keyID |= (long)bCPGInputStream.read() << 32;
        this.keyID |= (long)bCPGInputStream.read() << 24;
        this.keyID |= (long)bCPGInputStream.read() << 16;
        this.keyID |= (long)bCPGInputStream.read() << 8;
        this.keyID |= (long)bCPGInputStream.read();
        this.algorithm = bCPGInputStream.read();
        switch (this.algorithm) {
            case 1: 
            case 2: {
                this.data = new BigInteger[1];
                this.data[0] = new MPInteger(bCPGInputStream).getValue();
                break;
            }
            case 16: 
            case 20: {
                this.data = new BigInteger[2];
                this.data[0] = new MPInteger(bCPGInputStream).getValue();
                this.data[1] = new MPInteger(bCPGInputStream).getValue();
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered");
            }
        }
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream2.write(this.version);
        bCPGOutputStream2.write((byte)(this.keyID >> 56));
        bCPGOutputStream2.write((byte)(this.keyID >> 48));
        bCPGOutputStream2.write((byte)(this.keyID >> 40));
        bCPGOutputStream2.write((byte)(this.keyID >> 32));
        bCPGOutputStream2.write((byte)(this.keyID >> 24));
        bCPGOutputStream2.write((byte)(this.keyID >> 16));
        bCPGOutputStream2.write((byte)(this.keyID >> 8));
        bCPGOutputStream2.write((byte)this.keyID);
        bCPGOutputStream2.write(this.algorithm);
        int n = 0;
        while (n != this.data.length) {
            bCPGOutputStream2.writeObject(new MPInteger(this.data[n]));
            ++n;
        }
        bCPGOutputStream.writePacket(1, byteArrayOutputStream.toByteArray(), true);
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public BigInteger[] getEncSessionKey() {
        return this.data;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public int getVersion() {
        return this.version;
    }
}

