/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPPBEEncryptedData
extends PGPEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = symmetricKeyEncSessionPacket;
    }

    public InputStream getDataStream(char[] cArray, String string) throws PGPException, NoSuchProviderException {
        Cipher cipher;
        try {
            cipher = this.encData instanceof SymmetricEncIntegrityPacket ? Cipher.getInstance(String.valueOf(PGPUtil.getSymmetricCipherName(this.keyData.getEncAlgorithm())) + "/CFB/NoPadding", string) : Cipher.getInstance(String.valueOf(PGPUtil.getSymmetricCipherName(this.keyData.getEncAlgorithm())) + "/OpenPGPCFB/NoPadding", string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception creating cipher", exception);
        }
        if (cipher != null) {
            try {
                int n;
                SecretKey secretKey = PGPUtil.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K(), cArray, string);
                byte[] byArray = new byte[cipher.getBlockSize()];
                cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray));
                this.encStream = new BCPGInputStream(new CipherInputStream(this.encData.getInputStream(), cipher));
                if (this.encData instanceof SymmetricEncIntegrityPacket) {
                    PGPPBEEncryptedData pGPPBEEncryptedData = this;
                    pGPPBEEncryptedData.getClass();
                    this.truncStream = pGPPBEEncryptedData.new PGPEncryptedData.TruncatedStream(this.encStream);
                    this.encStream = new DigestInputStream(this.truncStream, MessageDigest.getInstance(PGPUtil.getDigestName(2), string));
                }
                int n2 = 0;
                while (n2 != byArray.length) {
                    n = this.encStream.read();
                    if (n < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                    byArray[n2] = (byte)n;
                    ++n2;
                }
                n = this.encStream.read();
                int n3 = this.encStream.read();
                if (n < 0 || n3 < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                if (byArray[byArray.length - 2] != (byte)n && n != 0) {
                    throw new PGPDataValidationException("data check failed.");
                }
                if (byArray[byArray.length - 1] != (byte)n3 && n3 != 0) {
                    throw new PGPDataValidationException("data check failed.");
                }
                return this.encStream;
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception creating cipher", exception);
            }
        }
        return this.encData.getInputStream();
    }

    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }
}

