/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKCS5Test
implements PKCSObjectIdentifiers,
Test {
    static byte[] sample1 = Base64.decode((String)"MIIBozA9BgkqhkiG9w0BBQ0wMDAbBgkqhkiG9w0BBQwwDgQIfWBDXwLp4K4CAggAMBEGBSsOAwIHBAiaCF/AvOgQ6QSCAWDWX4BdAzCRNSQSANSuNsT5X8mWYO27mr3Y9c9LoBVXGNmYWKA77MI4967f7SmjNcgXj3xNE/jmnVz6hhsjS8E5VPT3kfyVkpdZ0lr5e9Yk2m3JWpPU7++v5zBkZmC4V/MwV/XuIs6U+vykgzMgpxQg0oZKS9zgmiZof/4dOCL0UtCDnyOSvqT7mCVIcMDIEKu8QbVlgZYBop08l60EuEU3gARUo8WsYQmODz/ldx0Z+znIT0SXVuOwc+RVItC5T/Qx+aijmmpt+9l14nmaGBrEkmuhmtdvU/4vaptewGRgmjOfD6cqK+zs0O5NrrJ3P/6ZSxXj91CQgrThGfOv72bUncXEMNtc8pks2jpHFjGMdKufnadAD7XuMgzkkaklEXZ4f5tU6heIIwr51g0GBEGF96gYPFnjnSQM75JE02Clo+DfcfXpcybPTwwFg2jd6JTTOfkdf6OdSlA/1XNK43FA");
    static byte[] sample2 = Base64.decode((String)"MIIBpjBABgkqhkiG9w0BBQ0wMzAbBgkqhkiG9w0BBQwwDgQIeFeOWl1jywYCAggAMBQGCCqGSIb3DQMHBAjUJ5eGBhQGtQSCAWBrHrRgqO8UUMLcWzZEtpk1l3mjxiF/koCMkHsFwowgyWhEbgIkTgbSViK54LVK8PskekcGNLph+rB6bGZ7pPbL5pbXASJ8+MkQcG3FZdlS4Ek9tTJDApj3O1UubZGFG4uvTlJJFbF1BOJ3MkY3XQ9Gl1qwv7j56e103Da7Cq9+oIDKmznza78XXQYrUsPo8mJGjUxPskEYlzwvHjKubRnYm/K6RKhi5f4zX4BQ/Dt3H812ZjRXrsjAJP0KrD/jyD/jCT7zNBVPH1izBds+RwizyQAHwfNJBFR78TH4cgzB619X47FDVOnT0LqQNVd0O3cSwnPrXE9XR3tPayE+iOB15llFSmi8z0ByOXldEpkezCn92Umk++suzIVj1qfsK+bv2phZWJPbLEIWPDRHUbYf76q5ArAru4xtxT/hoK3krEs/IN3d70qjlUJ36SEw1UaZ82PWhakQbdtu39ZraMJB");
    static byte[] sample3 = Base64.decode((String)"MIIBrjBIBgkqhkiG9w0BBQ0wOzAeBgkqhkiG9w0BBQwwEQQIrHyQPBZqWLUCAggAAgEQMBkGCCqGSIb3DQMCMA0CAToECEhbh7YZKiPSBIIBYCT1zp6o5jpFlIkgwPop7bW1+8ACr4exqzkeb3WflQ8cWJ4cURxzVdvxUnXeW1VJdaQZtjS/QHs5GhPTG/0fwtvnaPfwrIJ3FeGaZfcg2CrYhalOFmEb4xrE4KyoEQmUN8tb/Cg94uzd16BOPw21RDnE8bnPdIGY7TyL95kbkqH23mK53pi7h+xWIgduW+atIqDyyt55f7WMZcvDvlj6VpN/V0h+qxBHL274WA4dj6GYgeyUFpi60HdGCK7By2TBy8h1ZvKGjmB9h8jZvkx1MkbRumXxyFsowTZawyYvO8Um6lbfEDP9zIEUq0IV8RqH2MRyblsPNSikyYhxX/cztdDxRKhilySbSBg5Kr8OfcwKp9bpinN96nmG4xr3Tch1bnVvqJzOQ5+Vva2WwVvH2JkWvYm5WaANg4Q6bRxu9vz7DuhbJjQdZbxFezIAgrJdSe92B00jO/0Kny1WjiVO6DA=");
    static byte[] result = Hex.decode((String)"30820155020100300d06092a864886f70d01010105000482013f3082013b020100024100debbfc2c09d61bada2a9462f24224e54cc6b3cc0755f15ce318ef57e79df17026b6a85cca12428027245045df2052a329a2f9ad3d17b78a10572ad9b22bf343b020301000102402d90a96adcec472743527bc023153d8f0d6e96b40c8ed228276d467d843306429f8670559bf376dd41857f6397c2fc8d95e0e53ed62de420b855430ee4a1b8a1022100ffcaf083823931e073ff534f06a5d415b3d414bc614a4544a3dff7ed271817eb022100deea30242117db2d3b8837f58f1da530ff83cf9283680da33683ec4e583610f1022100e6026381adb0a683f16a8f4c096b462979b9e4277cc89f3ed8a905b46fa9ff9f02210097c146d4d1d2b3dbaf53a504ff51674c5c271800de84d003f4f10ac6ab36e38102202bfa141f10bda874e1017d845e82767c1c38e82745daf421f0c8cd09d7652387");

    public String getName() {
        return "PKCS5S2";
    }

    public TestResult perform() {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESEngine()));
        PBETest pBETest = new PBETest(0, (BufferedBlockCipher)paddedBufferedBlockCipher, sample1, 64);
        TestResult testResult = pBETest.perform();
        if (!testResult.isSuccessful()) {
            return new SimpleTestResult(false, this.getName() + ": " + testResult.toString());
        }
        paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()));
        pBETest = new PBETest(1, (BufferedBlockCipher)paddedBufferedBlockCipher, sample2, 192);
        testResult = pBETest.perform();
        if (!testResult.isSuccessful()) {
            return new SimpleTestResult(false, this.getName() + ": " + testResult.toString());
        }
        paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new RC2Engine()));
        pBETest = new PBETest(2, (BufferedBlockCipher)paddedBufferedBlockCipher, sample3, 0);
        testResult = pBETest.perform();
        if (!testResult.isSuccessful()) {
            return new SimpleTestResult(false, this.getName() + ": " + testResult.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        PKCS5Test pKCS5Test = new PKCS5Test();
        TestResult testResult = pKCS5Test.perform();
        System.out.println(testResult.toString());
    }

    private class PBETest
    implements Test {
        int id;
        BufferedBlockCipher cipher;
        byte[] sample;
        int keySize;

        PBETest(int n, BufferedBlockCipher bufferedBlockCipher, byte[] byArray, int n2) {
            this.id = n;
            this.cipher = bufferedBlockCipher;
            this.sample = byArray;
            this.keySize = n2;
        }

        public String getName() {
            return this.cipher.getUnderlyingCipher().getAlgorithmName() + " PKCS5S2 Test " + this.id;
        }

        public TestResult perform() {
            ParametersWithIV parametersWithIV;
            byte[] byArray;
            Object object;
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
            char[] cArray = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.sample);
            DERInputStream dERInputStream = new DERInputStream((InputStream)byteArrayInputStream);
            try {
                encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo((ASN1Sequence)dERInputStream.readObject());
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": failed construction - exception " + exception.toString());
            }
            PBES2Parameters pBES2Parameters = new PBES2Parameters((ASN1Sequence)encryptedPrivateKeyInfo.getEncryptionAlgorithm().getParameters());
            PBKDF2Params pBKDF2Params = (PBKDF2Params)pBES2Parameters.getKeyDerivationFunc();
            EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
            if (pBKDF2Params.getKeyLength() != null) {
                this.keySize = pBKDF2Params.getKeyLength().intValue() * 8;
            }
            int n = pBKDF2Params.getIterationCount().intValue();
            byte[] byArray2 = pBKDF2Params.getSalt();
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])cArray), byArray2, n);
            if (encryptionScheme.getObjectId().equals((Object)PKCSObjectIdentifiers.RC2_CBC)) {
                object = new RC2CBCParameter((ASN1Sequence)encryptionScheme.getObject());
                byArray = object.getIV();
                parametersWithIV = new ParametersWithIV(pKCS5S2ParametersGenerator.generateDerivedParameters(this.keySize), byArray);
            } else {
                object = ((ASN1OctetString)encryptionScheme.getObject()).getOctets();
                parametersWithIV = new ParametersWithIV(pKCS5S2ParametersGenerator.generateDerivedParameters(this.keySize), object);
            }
            this.cipher.init(false, (CipherParameters)parametersWithIV);
            object = encryptedPrivateKeyInfo.getEncryptedData();
            byArray = new byte[this.cipher.getOutputSize(((byte[])object).length)];
            int n2 = this.cipher.processBytes(object, 0, ((byte[])object).length, byArray, 0);
            try {
                n2 += this.cipher.doFinal(byArray, n2);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": failed doFinal - exception " + exception.toString());
            }
            if (result.length != n2) {
                return new SimpleTestResult(false, this.getName() + ": failed");
            }
            for (int i = 0; i != n2; ++i) {
                if (byArray[i] == result[i]) continue;
                return new SimpleTestResult(false, this.getName() + ": failed");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }
}

