/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.NoticeReference;

public class UserNotice
extends ASN1Encodable {
    NoticeReference noticeRef;
    DisplayText explicitText;

    public UserNotice(ASN1Sequence aSN1Sequence) {
        NoticeReference noticeReference = new NoticeReference(ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0)));
        if (aSN1Sequence.size() > 1) {
            this.explicitText = DisplayText.getInstance(ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1)));
        }
    }

    public UserNotice(NoticeReference noticeReference, String string) {
        this.noticeRef = noticeReference;
        this.explicitText = new DisplayText(string);
    }

    public UserNotice(NoticeReference noticeReference, DisplayText displayText) {
        this.noticeRef = noticeReference;
        this.explicitText = displayText;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.noticeRef);
        aSN1EncodableVector.add(this.explicitText);
        return new DERSequence(aSN1EncodableVector);
    }
}

