/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.SignerWithRecovery;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.ParametersWithSalt;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class ISO9796d2PSSSigner
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private SecureRandom random;
    private byte[] standardSalt;
    private int hLen;
    private int trailer;
    private int keyBits;
    private byte[] block;
    private byte[] mBuf;
    private int messageLength;
    private int saltLength;
    private boolean fullMessage;
    private byte[] recoveredMessage;

    public ISO9796d2PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n) {
        this(asymmetricBlockCipher, digest, n, false);
    }

    public ISO9796d2PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n, boolean bl) {
        this.cipher = asymmetricBlockCipher;
        this.digest = digest;
        this.hLen = digest.getDigestSize();
        this.saltLength = n;
        if (bl) {
            this.trailer = 188;
        } else if (digest instanceof SHA1Digest) {
            this.trailer = 13260;
        } else if (digest instanceof RIPEMD160Digest) {
            this.trailer = 12748;
        } else if (digest instanceof RIPEMD128Digest) {
            this.trailer = 13004;
        } else {
            throw new IllegalArgumentException("no valid trailer for digest");
        }
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)n;
    }

    private void LtoOSP(long l, byte[] byArray) {
        byArray[0] = (byte)(l >>> 56);
        byArray[1] = (byte)(l >>> 48);
        byArray[2] = (byte)(l >>> 40);
        byArray[3] = (byte)(l >>> 32);
        byArray[4] = (byte)(l >>> 24);
        byArray[5] = (byte)(l >>> 16);
        byArray[6] = (byte)(l >>> 8);
        byArray[7] = (byte)l;
    }

    private void clearBlock(byte[] byArray) {
        int n = 0;
        while (n != byArray.length) {
            byArray[n] = 0;
            ++n;
        }
    }

    public byte[] generateSignature() throws CryptoException {
        byte[] byArray;
        int n = this.digest.getDigestSize();
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray2 = new byte[n];
        this.digest.doFinal(byArray2, 0);
        byte[] byArray3 = new byte[8];
        this.LtoOSP(this.messageLength * 8, byArray3);
        this.digest.update(byArray3, 0, byArray3.length);
        this.digest.update(this.mBuf, 0, this.messageLength);
        this.digest.update(byArray2, 0, byArray2.length);
        if (this.standardSalt != null) {
            byArray = this.standardSalt;
        } else {
            byArray = new byte[this.saltLength];
            this.random.nextBytes(byArray);
        }
        this.digest.update(byArray, 0, byArray.length);
        byte[] byArray4 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray4, 0);
        int n2 = 2;
        if (this.trailer == 188) {
            n2 = 1;
        }
        int n3 = this.block.length - this.messageLength - byArray.length - this.hLen - n2 - 1;
        this.block[n3] = 1;
        System.arraycopy(this.mBuf, 0, this.block, n3 + 1, this.messageLength);
        System.arraycopy(byArray, 0, this.block, n3 + 1 + this.messageLength, byArray.length);
        byte[] byArray5 = this.maskGeneratorFunction1(byArray4, 0, byArray4.length, this.block.length - this.hLen - n2);
        int n4 = 0;
        while (n4 != byArray5.length) {
            int n5 = n4;
            this.block[n5] = (byte)(this.block[n5] ^ byArray5[n4]);
            ++n4;
        }
        System.arraycopy(byArray4, 0, this.block, this.block.length - this.hLen - n2, this.hLen);
        if (this.trailer == 188) {
            this.block[this.block.length - 1] = -68;
        } else {
            this.block[this.block.length - 2] = (byte)(this.trailer >>> 8);
            this.block[this.block.length - 1] = (byte)this.trailer;
        }
        this.block[0] = (byte)(this.block[0] & 0x7F);
        byte[] byArray6 = this.cipher.processBlock(this.block, 0, this.block.length);
        this.clearBlock(this.mBuf);
        this.clearBlock(this.block);
        this.messageLength = 0;
        return byArray6;
    }

    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }

    public boolean hasFullMessage() {
        return this.fullMessage;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = null;
        int n = this.saltLength;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else if (cipherParameters instanceof ParametersWithSalt) {
            ParametersWithSalt parametersWithSalt = (ParametersWithSalt)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)parametersWithSalt.getParameters();
            this.standardSalt = parametersWithSalt.getSalt();
            n = this.standardSalt.length;
        } else {
            rSAKeyParameters = (RSAKeyParameters)cipherParameters;
            if (bl) {
                this.random = new SecureRandom();
            }
        }
        this.cipher.init(bl, rSAKeyParameters);
        this.keyBits = rSAKeyParameters.getModulus().bitLength();
        this.block = new byte[(this.keyBits + 7) / 8];
        this.mBuf = this.trailer == 188 ? new byte[this.block.length - this.digest.getDigestSize() - n - 1 - 1] : new byte[this.block.length - this.digest.getDigestSize() - n - 1 - 2];
        this.reset();
    }

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (this.messageLength < byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray2.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[this.hLen];
        byte[] byArray4 = new byte[4];
        int n4 = 0;
        this.digest.reset();
        do {
            this.ItoOSP(n4, byArray4);
            this.digest.update(byArray, n, n2);
            this.digest.update(byArray4, 0, byArray4.length);
            this.digest.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n4 * this.hLen, this.hLen);
        } while (++n4 < n3 / this.hLen);
        if (n4 * this.hLen < n3) {
            this.ItoOSP(n4, byArray4);
            this.digest.update(byArray, n, n2);
            this.digest.update(byArray4, 0, byArray4.length);
            this.digest.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n4 * this.hLen, byArray2.length - n4 * this.hLen);
        }
        return byArray2;
    }

    public void reset() {
        this.digest.reset();
        this.messageLength = 0;
        if (this.recoveredMessage != null) {
            this.clearBlock(this.recoveredMessage);
        }
        this.recoveredMessage = null;
        this.fullMessage = false;
    }

    public void update(byte by) {
        if (this.messageLength < this.mBuf.length) {
            this.mBuf[this.messageLength++] = by;
        } else {
            this.digest.update(by);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        while (n2 > 0 && this.messageLength < this.mBuf.length) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        if (n2 > 0) {
            this.digest.update(byArray, n, n2);
        }
    }

    public boolean verifySignature(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            byArray2 = this.cipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        int n = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n = 1;
        } else {
            int n2 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            switch (n2) {
                case 12748: {
                    if (this.digest instanceof RIPEMD160Digest) break;
                    throw new IllegalStateException("signer should be initialised with RIPEMD160");
                }
                case 13260: {
                    if (this.digest instanceof SHA1Digest) break;
                    throw new IllegalStateException("signer should be initialised with SHA1");
                }
                case 13004: {
                    if (this.digest instanceof RIPEMD128Digest) break;
                    throw new IllegalStateException("signer should be initialised with RIPEMD128");
                }
                default: {
                    throw new IllegalArgumentException("unrecognised hash in signature");
                }
            }
            n = 2;
        }
        byte[] byArray3 = new byte[this.hLen];
        this.digest.doFinal(byArray3, 0);
        byte[] byArray4 = this.maskGeneratorFunction1(byArray2, byArray2.length - this.hLen - n, this.hLen, byArray2.length - this.hLen - n);
        int n3 = 0;
        while (n3 != byArray4.length) {
            int n4 = n3;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray4[n3]);
            ++n3;
        }
        int n5 = 0;
        n5 = 0;
        while (n5 != byArray2.length) {
            if (byArray2[n5] == 1) break;
            ++n5;
        }
        if (++n5 == byArray2.length) {
            this.clearBlock(byArray2);
            return false;
        }
        this.fullMessage = n5 > 1;
        this.recoveredMessage = new byte[byArray4.length - n5 - this.saltLength];
        System.arraycopy(byArray2, n5, this.recoveredMessage, 0, this.recoveredMessage.length);
        byte[] byArray5 = new byte[8];
        this.LtoOSP(this.recoveredMessage.length * 8, byArray5);
        this.digest.update(byArray5, 0, byArray5.length);
        if (this.recoveredMessage.length != 0) {
            this.digest.update(this.recoveredMessage, 0, this.recoveredMessage.length);
        }
        this.digest.update(byArray3, 0, byArray3.length);
        byte[] byArray6 = new byte[this.digest.getDigestSize()];
        this.digest.update(byArray2, n5 + this.recoveredMessage.length, byArray4.length - n5 - this.recoveredMessage.length);
        this.digest.doFinal(byArray6, 0);
        int n6 = byArray2.length - n - byArray6.length;
        int n7 = 0;
        while (n7 != byArray6.length) {
            if (byArray6[n7] != byArray2[n6 + n7]) {
                this.clearBlock(byArray2);
                this.clearBlock(byArray6);
                this.clearBlock(this.recoveredMessage);
                return false;
            }
            ++n7;
        }
        if (this.messageLength != 0 && !this.isSameAs(this.mBuf, this.recoveredMessage)) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            this.clearBlock(this.recoveredMessage);
            return false;
        }
        this.clearBlock(this.mBuf);
        this.clearBlock(byArray2);
        this.messageLength = 0;
        return true;
    }
}

