/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERInputStream;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertificateFactorySpi;
import org.bouncycastle.jce.provider.PKIXCertPath;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.util.encoders.Base64;

public class JDKX509CertificateFactory
extends CertificateFactorySpi {
    private SignedData sData = null;
    private int sDataObjectCount = 0;

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            inputStream.mark(10);
            if (inputStream.read() != 48) {
                inputStream.reset();
                return this.readPEMCRL(inputStream);
            }
            inputStream.reset();
            return this.readDERCRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        return null;
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        return this.engineGenerateCertPath(inputStream, "PkiPath");
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        return new PKIXCertPath(inputStream, string);
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || e instanceof X509Certificate) continue;
            throw new CertificateException("list contains none X509Certificate object while creating CertPath\n" + e.toString());
        }
        return new PKIXCertPath(list);
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (this.sData != null) {
            if (this.sDataObjectCount != this.sData.getCertificates().size()) {
                return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
            }
            this.sData = null;
            this.sDataObjectCount = 0;
            return null;
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            inputStream.mark(10);
            int n = inputStream.read();
            if (n == -1) {
                return null;
            }
            if (n != 48) {
                inputStream.reset();
                return this.readPEMCertificate(inputStream);
            }
            if (inputStream.read() == 128) {
                inputStream.reset();
                return this.readPKCS7Certificate(inputStream);
            }
            inputStream.reset();
            return this.readDERCertificate(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.toString());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        Certificate certificate;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        while ((certificate = this.engineGenerateCertificate(inputStream)) != null) {
            arrayList.add(certificate);
        }
        return arrayList;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    private CRL readDERCRL(InputStream inputStream) throws IOException {
        DERInputStream dERInputStream = new DERInputStream(inputStream);
        return new X509CRLObject(new CertificateList((ASN1Sequence)dERInputStream.readObject()));
    }

    private Certificate readDERCertificate(InputStream inputStream) throws IOException {
        DERInputStream dERInputStream = new DERInputStream(inputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof DERObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true));
            return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
        }
        return new X509CertificateObject(X509CertificateStructure.getInstance(aSN1Sequence));
    }

    private String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != 10 && n >= 0) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        if (n < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private CRL readPEMCRL(InputStream inputStream) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(inputStream)) != null) {
            if (string.equals("-----BEGIN CRL-----") || string.equals("-----BEGIN X509 CRL-----")) break;
        }
        while ((string = this.readLine(inputStream)) != null) {
            if (string.equals("-----END CRL-----") || string.equals("-----END X509 CRL-----")) break;
            stringBuffer.append(string);
        }
        if (stringBuffer.length() != 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(stringBuffer.toString()));
            return this.readDERCRL(byteArrayInputStream);
        }
        return null;
    }

    private Certificate readPEMCertificate(InputStream inputStream) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(inputStream)) != null) {
            if (string.equals("-----BEGIN CERTIFICATE-----") || string.equals("-----BEGIN X509 CERTIFICATE-----")) break;
        }
        while ((string = this.readLine(inputStream)) != null) {
            if (string.equals("-----END CERTIFICATE-----") || string.equals("-----END X509 CERTIFICATE-----")) break;
            stringBuffer.append(string);
        }
        if (stringBuffer.length() != 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(stringBuffer.toString()));
            return this.readDERCertificate(byteArrayInputStream);
        }
        return null;
    }

    private Certificate readPKCS7Certificate(InputStream inputStream) throws IOException {
        BERInputStream bERInputStream = new BERInputStream(inputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)bERInputStream.readObject();
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof DERObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true));
            return new X509CertificateObject(X509CertificateStructure.getInstance(this.sData.getCertificates().getObjectAt(this.sDataObjectCount++)));
        }
        return new X509CertificateObject(X509CertificateStructure.getInstance(aSN1Sequence));
    }
}

