/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.provider.BCECPrivateKey;
import org.bouncycastle.jce.provider.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class ECUtil {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey bCECPublicKey = (BCECPublicKey)publicKey;
            ECParameterSpec eCParameterSpec = bCECPublicKey.getParameters();
            return new ECPublicKeyParameters(bCECPublicKey.getQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()));
        }
        throw new InvalidKeyException("can't identify EC public key.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCECPrivateKey) {
            BCECPrivateKey bCECPrivateKey = (BCECPrivateKey)privateKey;
            ECParameterSpec eCParameterSpec = bCECPrivateKey.getParameters();
            return new ECPrivateKeyParameters(bCECPrivateKey.getD(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()));
        }
        throw new InvalidKeyException("can't identify EC private key.");
    }
}

