/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.jce.provider.RSAUtil;
import org.bouncycastle.jce.spec.PSSParameterSpec;

public class JDKPSSSigner
extends Signature {
    private AsymmetricBlockCipher signer;
    private Digest digest;
    private int saltLength;
    private PSSSigner pss;

    protected JDKPSSSigner(String string, AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        super(string);
        this.signer = asymmetricBlockCipher;
        this.digest = digest;
        this.saltLength = digest.getDigestSize();
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(true, RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey));
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(true, new ParametersWithRandom(RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey), secureRandom));
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(false, RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey));
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterException {
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new InvalidParameterException("Only PSSParameterSpec supported");
        }
        this.saltLength = ((PSSParameterSpec)algorithmParameterSpec).getSaltLength();
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.pss.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException(cryptoException.getMessage());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.pss.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.pss.update(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.pss.verifySignature(byArray);
    }

    public static class SHA1withRSA
    extends JDKPSSSigner {
        public SHA1withRSA() {
            super("SHA1withRSA/PSS", new RSAEngine(), new SHA1Digest());
        }
    }

    public static class SHA256withRSA
    extends JDKPSSSigner {
        public SHA256withRSA() {
            super("SHA256withRSA/PSS", new RSAEngine(), new SHA256Digest());
        }
    }

    public static class SHA384withRSA
    extends JDKPSSSigner {
        public SHA384withRSA() {
            super("SHA384withRSA/PSS", new RSAEngine(), new SHA384Digest());
        }
    }

    public static class SHA512withRSA
    extends JDKPSSSigner {
        public SHA512withRSA() {
            super("SHA512withRSA/PSS", new RSAEngine(), new SHA512Digest());
        }
    }
}

