/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509.extension;

import java.io.IOException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class AuthorityKeyIdentifierExtension
extends AuthorityKeyIdentifier {
    private AuthorityKeyIdentifier authKeyID;

    public AuthorityKeyIdentifierExtension(X509Certificate x509Certificate) throws CertificateParsingException {
        super(AuthorityKeyIdentifierExtension.fromCertificate(x509Certificate));
    }

    public AuthorityKeyIdentifierExtension(byte[] byArray) throws IOException {
        super((ASN1Sequence)X509ExtensionUtil.fromExtensionValue(byArray));
    }

    private static ASN1Sequence fromCertificate(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(x509Certificate.getPublicKey().getEncoded()).readObject());
            GeneralName generalName = new GeneralName(PrincipalUtil.getSubjectX509Principal(x509Certificate));
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(generalName);
            return (ASN1Sequence)new AuthorityKeyIdentifier(subjectPublicKeyInfo, new GeneralNames(new DERSequence(aSN1EncodableVector)), x509Certificate.getSerialNumber()).toASN1Object();
        }
        catch (Exception exception) {
            throw new CertificateParsingException("Exception extracting certificate details: " + exception.toString());
        }
    }
}

