/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.tsp.TimeStampReq;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;

public class TimeStampRequest
implements java.security.cert.X509Extension {
    TimeStampReq req;

    public TimeStampRequest(TimeStampReq timeStampReq) {
        this.req = timeStampReq;
    }

    public TimeStampRequest(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public TimeStampRequest(InputStream inputStream) throws IOException {
        this.req = TimeStampReq.getInstance((Object)new ASN1InputStream(inputStream).readObject());
    }

    public int getVersion() {
        return this.req.getVersion().getValue().intValue();
    }

    public String getMessageImprintAlgOID() {
        return this.req.getMessageImprint().getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getMessageImprintDigest() {
        return this.req.getMessageImprint().getHashedMessage();
    }

    public String getReqPolicy() {
        if (this.req.getReqPolicy() != null) {
            return this.req.getReqPolicy().getId();
        }
        return null;
    }

    public BigInteger getNonce() {
        if (this.req.getNonce() != null) {
            return this.req.getNonce().getValue();
        }
        return null;
    }

    public boolean getCertReq() {
        if (this.req.getCertReq() != null) {
            return this.req.getCertReq().isTrue();
        }
        return false;
    }

    public void validate(Set set, Set set2, Set set3, String string) throws TSPException, NoSuchProviderException {
        Object object;
        if (!set.contains(this.getMessageImprintAlgOID())) {
            throw new TSPValidationException("request contains unknown algorithm.", 128);
        }
        if (set2 != null && this.getReqPolicy() != null && !set2.contains(this.getReqPolicy())) {
            throw new TSPValidationException("request contains unknown policy.", 256);
        }
        if (this.getExtensions() != null && set3 != null) {
            object = this.getExtensions().oids();
            while (object.hasMoreElements()) {
                String string2 = ((DERObjectIdentifier)object.nextElement()).getId();
                if (set3.contains(string2)) continue;
                throw new TSPValidationException("request contains unknown extension.", 0x800000);
            }
        }
        try {
            object = MessageDigest.getInstance(this.getMessageImprintAlgOID(), string);
            if (((MessageDigest)object).getDigestLength() != this.getMessageImprintDigest().length) {
                throw new TSPValidationException("imprint digest the wrong length.", 8);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TSPException("digest algorithm cannot be found in provider.", noSuchAlgorithmException);
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.req.getEncoded();
    }

    X509Extensions getExtensions() {
        return this.req.getExtensions();
    }

    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.req.getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            try {
                return x509Extension.getValue().getEncoded();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    private Set getExtensionOIDS(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        X509Extensions x509Extensions = this.req.getExtensions();
        if (x509Extensions != null) {
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (x509Extension.isCritical() != bl) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDS(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDS(true);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }
}

