/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.provider.BCECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class JCEEC5PublicKey
implements ECPublicKey,
BCECPublicKey {
    private String algorithm = "EC";
    private org.bouncycastle.math.ec.ECPoint q;
    private ECParameterSpec ecSpec;

    JCEEC5PublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.ecSpec = eCPublicKeySpec.getParams();
        this.q = new ECPoint.Fp(new ECCurve.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB()), new ECFieldElement.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), eCPublicKeySpec.getW().getAffineX()), new ECFieldElement.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), eCPublicKeySpec.getW().getAffineY()));
    }

    JCEEC5PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        if (eCParameterSpec == null) {
            ECCurve.Fp fp = (ECCurve.Fp)eCDomainParameters.getCurve();
            this.ecSpec = new ECParameterSpec(new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), eCDomainParameters.getSeed()), new ECPoint(eCDomainParameters.getG().getX().toBigInteger(), eCDomainParameters.getG().getY().toBigInteger()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            this.ecSpec = eCParameterSpec;
        }
    }

    JCEEC5PublicKey(String string, ECPublicKey eCPublicKey) {
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParams();
        this.q = new ECPoint.Fp(new ECCurve.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB()), new ECFieldElement.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), eCPublicKey.getW().getAffineX()), new ECFieldElement.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), eCPublicKey.getW().getAffineY()));
    }

    JCEEC5PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object;
        ECCurve.Fp fp;
        Object object2;
        ASN1Encodable aSN1Encodable;
        X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
            object2 = X962NamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
            fp = (ECCurve.Fp)((X9ECParameters)object2).getCurve();
            this.ecSpec = new ECNamedCurveParameterSpec(X962NamedCurves.getName((DERObjectIdentifier)aSN1Encodable), new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), ((X9ECParameters)object2).getSeed()), new ECPoint(((X9ECParameters)object2).getG().getX().toBigInteger(), ((X9ECParameters)object2).getG().getY().toBigInteger()), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH());
        } else {
            aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
            fp = (ECCurve.Fp)((X9ECParameters)aSN1Encodable).getCurve();
            this.ecSpec = new ECParameterSpec(new EllipticCurve(new ECFieldFp(fp.getQ()), fp.getA().toBigInteger(), fp.getB().toBigInteger(), ((X9ECParameters)aSN1Encodable).getSeed()), new ECPoint(((X9ECParameters)aSN1Encodable).getG().getX().toBigInteger(), ((X9ECParameters)aSN1Encodable).getG().getY().toBigInteger()), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH().intValue());
        }
        aSN1Encodable = subjectPublicKeyInfo.getPublicKeyData();
        object2 = ((DERBitString)aSN1Encodable).getBytes();
        ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object2);
        if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3)) {
            try {
                object = new ByteArrayInputStream((byte[])object2);
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
                aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        object = new X9ECPoint(fp, aSN1OctetString);
        this.q = ((X9ECPoint)object).getPoint();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        ASN1Encodable aSN1Encodable;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            x962Parameters = new X962Parameters(X962NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()));
        } else {
            object = new ECCurve.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB());
            aSN1Encodable = new X9ECParameters((ECCurve)object, new ECPoint.Fp((ECCurve)object, ((ECCurve.Fp)object).fromBigInteger(this.ecSpec.getGenerator().getAffineX()), ((ECCurve.Fp)object).fromBigInteger(this.ecSpec.getGenerator().getAffineY())), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)aSN1Encodable);
        }
        object = (ASN1OctetString)new X9ECPoint(this.getQ()).getDERObject();
        aSN1Encodable = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), ((ASN1OctetString)object).getOctets());
        try {
            dEROutputStream.writeObject(aSN1Encodable);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding EC public key");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public org.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        ECCurve.Fp fp = new ECCurve.Fp(((ECFieldFp)this.ecSpec.getCurve().getField()).getP(), this.ecSpec.getCurve().getA(), this.ecSpec.getCurve().getB());
        return new org.bouncycastle.jce.spec.ECParameterSpec(fp, new ECPoint.Fp(fp, fp.fromBigInteger(this.ecSpec.getGenerator().getAffineX()), fp.fromBigInteger(this.ecSpec.getGenerator().getAffineY())), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
    }

    public ECPoint getW() {
        return new ECPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger());
    }

    public org.bouncycastle.math.ec.ECPoint getQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key" + string);
        stringBuffer.append("            X: " + this.q.getX().toBigInteger().toString(16) + string);
        stringBuffer.append("            Y: " + this.q.getY().toBigInteger().toString(16) + string);
        return stringBuffer.toString();
    }
}

