/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;

    private DERObject getExtensionValue(X509Extension x509Extension, String string) throws CertPathValidatorException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(aSN1OctetString.getOctets()));
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing extension " + string);
        }
    }

    private boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        for (int i = aSN1Sequence2.size() - 1; i >= 0; --i) {
            if (aSN1Sequence2.getObjectAt(i).equals(aSN1Sequence.getObjectAt(i))) continue;
            return false;
        }
        return true;
    }

    private List sortCerts(List list, X509Certificate x509Certificate) throws CertPathValidatorException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        for (int i = list.size(); i > 0; --i) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                if (!x509Certificate2.getIssuerX500Principal().equals(x500Principal)) continue;
                x500Principal = x509Certificate2.getSubjectX500Principal();
                arrayList.add(0, x509Certificate2);
                iterator.remove();
            }
        }
        for (int i = 0; i != list.size(); ++i) {
            arrayList.add((X509Certificate)list.get(i));
        }
        return arrayList;
    }

    private void checkPermittedDN(HashSet hashSet, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : hashSet) {
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(HashSet hashSet, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : hashSet) {
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private HashSet intersectDN(HashSet hashSet, ASN1Sequence aSN1Sequence) {
        if (hashSet.isEmpty()) {
            hashSet.add(aSN1Sequence);
            return hashSet;
        }
        HashSet<ASN1Sequence> hashSet2 = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : hashSet) {
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet2.add(aSN1Sequence);
                continue;
            }
            if (!this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet2.add(aSN1Sequence2);
        }
        return hashSet2;
    }

    private HashSet unionDN(HashSet hashSet, ASN1Sequence aSN1Sequence) {
        if (hashSet.isEmpty()) {
            hashSet.add(aSN1Sequence);
            return hashSet;
        }
        HashSet<ASN1Sequence> hashSet2 = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : hashSet) {
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet2.add(aSN1Sequence2);
                continue;
            }
            if (this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet2.add(aSN1Sequence);
                continue;
            }
            hashSet2.add(aSN1Sequence2);
            hashSet2.add(aSN1Sequence);
        }
        return hashSet2;
    }

    private HashSet intersectEmail(HashSet hashSet, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (hashSet.isEmpty()) {
            hashSet.add(string2);
            return hashSet;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string3 : hashSet) {
            if (string2.endsWith(string3)) {
                hashSet2.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet2.add(string3);
        }
        return hashSet2;
    }

    private HashSet unionEmail(HashSet hashSet, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (hashSet.isEmpty()) {
            hashSet.add(string2);
            return hashSet;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string3 : hashSet) {
            if (string2.endsWith(string3)) {
                hashSet2.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet2.add(string2);
                continue;
            }
            hashSet2.add(string3);
            hashSet2.add(string2);
        }
        return hashSet2;
    }

    private HashSet intersectIP(HashSet hashSet, byte[] byArray) {
        return hashSet;
    }

    private HashSet unionIP(HashSet hashSet, byte[] byArray) {
        return hashSet;
    }

    private void checkPermittedEmail(HashSet hashSet, String string) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : hashSet) {
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    private void checkExcludedEmail(HashSet hashSet, String string) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : hashSet) {
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    private void checkPermittedIP(HashSet hashSet, byte[] byArray) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
    }

    private void checkExcludedIP(HashSet hashSet, byte[] byArray) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
    }

    private PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, ArrayList[] arrayListArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            for (int i = 0; i < arrayListArray.length; ++i) {
                arrayListArray[i] = new ArrayList();
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        this.removePolicyNodeRecurse(arrayListArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private void removePolicyNodeRecurse(ArrayList[] arrayListArray, PKIXPolicyNode pKIXPolicyNode) {
        arrayListArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                this.removePolicyNodeRecurse(arrayListArray, pKIXPolicyNode2);
            }
        }
    }

    private boolean isSelfIssued(X509Certificate x509Certificate) {
        return ((Object)x509Certificate.getSubjectDN()).equals(x509Certificate.getIssuerDN());
    }

    private boolean isAnyPolicy(Set set) {
        return set.contains(ANY_POLICY) || set.size() == 0;
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    private final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    private boolean processCertD1i(int n, ArrayList[] arrayListArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        ArrayList arrayList = arrayListArray[n - 1];
        for (int i = 0; i < arrayList.size(); ++i) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(i);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!set2.contains(dERObjectIdentifier.getId())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            arrayListArray[n].add(pKIXPolicyNode2);
            return true;
        }
        return false;
    }

    private void processCertD1ii(int n, ArrayList[] arrayListArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        ArrayList arrayList = arrayListArray[n - 1];
        for (int i = 0; i < arrayList.size(); ++i) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(i);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (!ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(dERObjectIdentifier.getId());
            PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
            pKIXPolicyNode.addChild(pKIXPolicyNode2);
            arrayListArray[n].add(pKIXPolicyNode2);
            return;
        }
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator<PKIXCertPathChecker> iterator;
        int n;
        Object object;
        Object object2;
        Iterator iterator2;
        PublicKey publicKey;
        X500Principal x500Principal;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        Set<String> set = pKIXParameters.getInitialPolicies();
        TrustAnchor trustAnchor = null;
        for (int i = 0; i < list.size() && (trustAnchor = this.findTrustAnchor((X509Certificate)list.get(list.size() - 1), pKIXParameters.getTrustAnchors())) == null; ++i) {
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found", null, certPath, 0);
        }
        list = this.sortCerts(list, trustAnchor.getTrustedCert());
        int n3 = 0;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ArrayList[] arrayListArray = new ArrayList[n2 + 1];
        for (int i = 0; i < arrayListArray.length; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add(ANY_POLICY);
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet3, null, new HashSet(), ANY_POLICY, false);
        arrayListArray[0].add(pKIXPolicyNode);
        HashSet hashSet4 = new HashSet();
        HashSet hashSet5 = new HashSet();
        HashSet hashSet6 = new HashSet();
        HashSet hashSet7 = new HashSet();
        HashSet hashSet8 = new HashSet();
        HashSet hashSet9 = new HashSet();
        HashSet hashSet10 = null;
        int n4 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n5 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n6 = pKIXParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = x509Certificate.getSubjectX500Principal();
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
        DERObjectIdentifier dERObjectIdentifier = algorithmIdentifier.getObjectId();
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        int n7 = n2;
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        Iterator<PKIXCertPathChecker> iterator3 = pKIXParameters.getCertPathCheckers().iterator();
        while (iterator3.hasNext()) {
            iterator3.next().init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n3 = list.size() - 1; n3 >= 0; --n3) {
            Object object3;
            Object object4;
            Object object52;
            Object object6;
            Set<String> set2;
            int n8 = n2 - n3;
            x509Certificate2 = (X509Certificate)list.get(n3);
            try {
                x509Certificate2.verify(publicKey, "BC");
                x509Certificate2.checkValidity(date);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CertPathValidatorException("couldn't validate certificate: " + generalSecurityException);
            }
            if (pKIXParameters.isRevocationEnabled()) {
                boolean bl = false;
                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                try {
                    x509CRLSelector.addIssuerName(x509Certificate2.getIssuerX500Principal().getEncoded());
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("can't extract issuer from certificate: " + iOException);
                }
                x509CRLSelector.setCertificateChecking(x509Certificate2);
                iterator2 = this.findCRLs(x509CRLSelector, pKIXParameters.getCertStores()).iterator();
                while (iterator2.hasNext()) {
                    object2 = (X509CRL)iterator2.next();
                    if (!date.after(((X509CRL)object2).getThisUpdate())) continue;
                    if (((X509CRL)object2).getNextUpdate() == null || date.before(((X509CRL)object2).getNextUpdate())) {
                        bl = true;
                    }
                    if (x509Certificate != null && (set2 = (Set<String>)x509Certificate.getKeyUsage()) != null && (((Object)set2).length < 7 || set2[6] == false)) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension does not permit crl signing.\n" + x509Certificate, null, certPath, n3);
                    }
                    try {
                        ((X509CRL)object2).verify(publicKey, "BC");
                    }
                    catch (Exception exception) {
                        throw new CertPathValidatorException("can't verify CRL: " + exception);
                    }
                    object = ((X509CRL)object2).getRevokedCertificate(x509Certificate2.getSerialNumber());
                    if (object != null && !date.before(((X509CRLEntry)object).getRevocationDate())) {
                        throw new CertPathValidatorException("Certificate revocation after " + ((X509CRLEntry)object).getRevocationDate(), null, certPath, n3);
                    }
                    set2 = this.getExtensionValue((X509Extension)object2, ISSUING_DISTRIBUTION_POINT);
                    DERObject dERObject = this.getExtensionValue((X509Extension)object2, DELTA_CRL_INDICATOR);
                    if (dERObject != null) {
                        object6 = new X509CRLSelector();
                        try {
                            ((X509CRLSelector)object6).addIssuerName(((X509CRL)object2).getIssuerX500Principal().getEncoded());
                        }
                        catch (IOException iOException) {
                            throw new CertPathValidatorException("can't extract issuer from certificate: " + iOException);
                        }
                        ((X509CRLSelector)object6).setMinCRLNumber(((DERInteger)dERObject).getPositiveValue());
                        ((X509CRLSelector)object6).setMaxCRLNumber(((DERInteger)this.getExtensionValue((X509Extension)object2, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                        boolean bl2 = false;
                        for (Object object52 : this.findCRLs((X509CRLSelector)object6, pKIXParameters.getCertStores())) {
                            object4 = this.getExtensionValue((X509Extension)object52, ISSUING_DISTRIBUTION_POINT);
                            if (set2 == null) {
                                if (object4 != null) continue;
                                bl2 = true;
                                break;
                            }
                            if (!((DERObject)((Object)set2)).equals(object4)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            throw new CertPathValidatorException("No base CRL for delta CRL");
                        }
                    }
                    if (set2 == null) continue;
                    object6 = IssuingDistributionPoint.getInstance(set2);
                    BasicConstraints basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS));
                    if (((IssuingDistributionPoint)object6).onlyContainsUserCerts() && (basicConstraints == null || basicConstraints.isCA())) {
                        throw new CertPathValidatorException("CA Cert CRL only contains user certificates");
                    }
                    if (((IssuingDistributionPoint)object6).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                        throw new CertPathValidatorException("End CRL only contains CA certificates");
                    }
                    if (!((IssuingDistributionPoint)object6).onlyContainsAttributeCerts()) continue;
                    throw new CertPathValidatorException("onlyContainsAttributeCerts boolean is asserted");
                }
                if (!bl) {
                    throw new CertPathValidatorException("no valid CRL found", null, certPath, n3);
                }
            }
            if (!x509Certificate2.getIssuerX500Principal().equals(x500Principal)) {
                throw new CertPathValidatorException("IssuerName(" + x509Certificate2.getIssuerX500Principal() + ") does not match SubjectName(" + x500Principal + ") of signing certificate", null, certPath, n3);
            }
            if (!this.isSelfIssued(x509Certificate2) || n8 >= n2) {
                iterator2 = x509Certificate2.getSubjectX500Principal();
                object = new ASN1InputStream(new ByteArrayInputStream(((X500Principal)((Object)iterator2)).getEncoded()));
                try {
                    object2 = (ASN1Sequence)((ASN1InputStream)object).readObject();
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                }
                this.checkPermittedDN(hashSet4, (ASN1Sequence)object2);
                this.checkExcludedDN(hashSet7, (ASN1Sequence)object2);
                set2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, SUBJECT_ALTERNATIVE_NAME);
                if (set2 != null) {
                    block42: for (int i = 0; i < ((ASN1Sequence)((Object)set2)).size(); ++i) {
                        object6 = (ASN1TaggedObject)((ASN1Sequence)((Object)set2)).getObjectAt(i);
                        switch (((ASN1TaggedObject)object6).getTagNo()) {
                            case 1: {
                                String string = DERIA5String.getInstance((ASN1TaggedObject)object6, true).getString();
                                this.checkPermittedEmail(hashSet5, string);
                                this.checkExcludedEmail(hashSet8, string);
                                continue block42;
                            }
                            case 4: {
                                object3 = ASN1Sequence.getInstance((ASN1TaggedObject)object6, true);
                                this.checkPermittedDN(hashSet4, (ASN1Sequence)object3);
                                this.checkExcludedDN(hashSet7, (ASN1Sequence)object3);
                                continue block42;
                            }
                            case 7: {
                                object52 = ASN1OctetString.getInstance((ASN1TaggedObject)object6, true).getOctets();
                                this.checkPermittedIP(hashSet6, (byte[])object52);
                                this.checkExcludedIP(hashSet9, (byte[])object52);
                            }
                        }
                    }
                }
            }
            if ((iterator2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES)) != null && pKIXPolicyNode != null) {
                object = ((ASN1Sequence)((Object)iterator2)).getObjects();
                object2 = new HashSet();
                while (object.hasMoreElements()) {
                    boolean bl;
                    set2 = PolicyInformation.getInstance(object.nextElement());
                    DERObjectIdentifier dERObjectIdentifier2 = ((PolicyInformation)((Object)set2)).getPolicyIdentifier();
                    ((HashSet)object2).add(dERObjectIdentifier2.getId());
                    if (ANY_POLICY.equals(dERObjectIdentifier2.getId()) || (bl = this.processCertD1i(n8, arrayListArray, dERObjectIdentifier2, (Set)(object6 = this.getQualifierSet(((PolicyInformation)((Object)set2)).getPolicyQualifiers()))))) continue;
                    this.processCertD1ii(n8, arrayListArray, dERObjectIdentifier2, (Set)object6);
                }
                if (hashSet10 == null) {
                    hashSet10 = object2;
                } else {
                    set2 = hashSet10.iterator();
                    HashSet hashSet11 = new HashSet();
                    while (set2.hasNext()) {
                        object6 = set2.next();
                        if (!((HashSet)object2).contains(object6)) continue;
                        hashSet11.add(object6);
                    }
                    hashSet10 = hashSet11;
                }
                if (n5 > 0 || n8 < n2 && this.isSelfIssued(x509Certificate2)) {
                    object = ((ASN1Sequence)((Object)iterator2)).getObjects();
                    while (object.hasMoreElements()) {
                        set2 = PolicyInformation.getInstance(object.nextElement());
                        if (ANY_POLICY.equals(((PolicyInformation)((Object)set2)).getPolicyIdentifier().getId())) continue;
                        Set set3 = this.getQualifierSet(((PolicyInformation)((Object)set2)).getPolicyQualifiers());
                        object6 = arrayListArray[n8 - 1];
                        for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
                            object3 = (PKIXPolicyNode)((ArrayList)object6).get(i);
                            object52 = ((PKIXPolicyNode)object3).getExpectedPolicies().iterator();
                            while (object52.hasNext()) {
                                Object object7;
                                String string;
                                object4 = object52.next();
                                if (object4 instanceof String) {
                                    string = (String)object4;
                                } else {
                                    if (!(object4 instanceof DERObjectIdentifier)) continue;
                                    string = ((DERObjectIdentifier)object4).getId();
                                }
                                boolean bl = false;
                                Iterator iterator4 = ((PKIXPolicyNode)object3).getChildren();
                                while (iterator4.hasNext()) {
                                    object7 = (PKIXPolicyNode)iterator4.next();
                                    if (!string.equals(((PKIXPolicyNode)object7).getValidPolicy())) continue;
                                    bl = true;
                                }
                                if (bl) continue;
                                object7 = new HashSet();
                                object7.add(string);
                                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n8, (Set)object7, (PolicyNode)object3, set3, string, false);
                                ((PKIXPolicyNode)object3).addChild(pKIXPolicyNode2);
                                arrayListArray[n8].add(pKIXPolicyNode2);
                            }
                        }
                    }
                }
                for (int i = n8 - 1; i >= 0; --i) {
                    PKIXPolicyNode pKIXPolicyNode3;
                    ArrayList arrayList = arrayListArray[i];
                    for (int j = 0; j < arrayList.size() && ((pKIXPolicyNode3 = (PKIXPolicyNode)arrayList.get(j)).hasChildren() || (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode3)) != null); ++j) {
                    }
                }
                set2 = x509Certificate2.getCriticalExtensionOIDs();
                if (set2 != null) {
                    boolean bl = set2.contains(CERTIFICATE_POLICIES);
                    ArrayList arrayList = arrayListArray[n8];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object3 = (PKIXPolicyNode)arrayList.get(i);
                        ((PKIXPolicyNode)object3).setCritical(bl);
                    }
                }
                for (int i = n8 - 1; i >= 0; --i) {
                    ArrayList arrayList = arrayListArray[i];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        object3 = (PKIXPolicyNode)arrayList.get(j);
                        if (((PKIXPolicyNode)object3).hasChildren()) continue;
                        pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, (PKIXPolicyNode)object3);
                    }
                }
            }
            if (iterator2 == null) {
                pKIXPolicyNode = null;
            }
            if (n4 <= 0 && pKIXPolicyNode == null && !this.isAnyPolicy(hashSet10)) {
                throw new CertPathValidatorException("Failure in process (f)");
            }
            if (n8 != n2) {
                boolean[] blArray;
                int n9;
                BigInteger bigInteger;
                BasicConstraints basicConstraints;
                int n10;
                DERInteger dERInteger;
                if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                    throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                }
                object = this.getExtensionValue(x509Certificate2, POLICY_MAPPINGS);
                if (object != null) {
                    object2 = (ASN1Sequence)object;
                    for (int i = 0; i < ((ASN1Sequence)object2).size(); ++i) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object2).getObjectAt(i);
                        DERObjectIdentifier dERObjectIdentifier3 = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
                        DERObjectIdentifier dERObjectIdentifier4 = (DERObjectIdentifier)aSN1Sequence.getObjectAt(1);
                        if (ANY_POLICY.equals(dERObjectIdentifier3.getId())) {
                            throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                        }
                        if (!ANY_POLICY.equals(dERObjectIdentifier4.getId())) continue;
                        throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                    }
                }
                if ((object2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, NAME_CONSTRAINTS)) != null) {
                    ASN1Sequence aSN1Sequence;
                    NameConstraints nameConstraints = new NameConstraints((ASN1Sequence)object2);
                    ASN1Sequence aSN1Sequence2 = nameConstraints.getPermittedSubtrees();
                    if (aSN1Sequence2 != null) {
                        Enumeration enumeration = aSN1Sequence2.getObjects();
                        while (enumeration.hasMoreElements()) {
                            GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                            object3 = generalSubtree.getBase();
                            switch (((GeneralName)object3).getTagNo()) {
                                case 1: {
                                    hashSet5 = this.intersectEmail(hashSet5, DERIA5String.getInstance(((GeneralName)object3).getName()).getString());
                                    break;
                                }
                                case 4: {
                                    hashSet4 = this.intersectDN(hashSet4, (ASN1Sequence)((GeneralName)object3).getName());
                                    break;
                                }
                                case 7: {
                                    hashSet6 = this.intersectIP(hashSet6, ASN1OctetString.getInstance(((GeneralName)object3).getName()).getOctets());
                                }
                            }
                        }
                    }
                    if ((aSN1Sequence = nameConstraints.getExcludedSubtrees()) != null) {
                        Enumeration enumeration = aSN1Sequence.getObjects();
                        while (enumeration.hasMoreElements()) {
                            object3 = GeneralSubtree.getInstance(enumeration.nextElement());
                            object52 = ((GeneralSubtree)object3).getBase();
                            switch (((GeneralName)object52).getTagNo()) {
                                case 1: {
                                    hashSet8 = this.unionEmail(hashSet8, DERIA5String.getInstance(((GeneralName)object52).getName()).getString());
                                    break;
                                }
                                case 4: {
                                    hashSet7 = this.unionDN(hashSet7, (ASN1Sequence)((GeneralName)object52).getName());
                                    break;
                                }
                                case 7: {
                                    hashSet9 = this.unionIP(hashSet9, ASN1OctetString.getInstance(((GeneralName)object52).getName()).getOctets());
                                }
                            }
                        }
                    }
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n4 != 0) {
                        --n4;
                    }
                    if (n6 != 0) {
                        --n6;
                    }
                    if (n5 != 0) {
                        --n5;
                    }
                }
                if ((set2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
                    Enumeration enumeration = ((ASN1Sequence)((Object)set2)).getObjects();
                    while (enumeration.hasMoreElements()) {
                        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                        switch (aSN1TaggedObject.getTagNo()) {
                            case 0: {
                                n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n >= n4) break;
                                n4 = n;
                                break;
                            }
                            case 1: {
                                n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n >= n5) break;
                                n5 = n;
                            }
                        }
                    }
                }
                if ((dERInteger = (DERInteger)this.getExtensionValue(x509Certificate2, INHIBIT_ANY_POLICY)) != null && (n10 = dERInteger.getValue().intValue()) < n5) {
                    n5 = n10;
                }
                if ((basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS))) != null) {
                    if (!basicConstraints.isCA()) {
                        throw new CertPathValidatorException("Not a CA certificate");
                    }
                } else {
                    throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n7 <= 0) {
                        throw new CertPathValidatorException("Max path length not greater than zero");
                    }
                    --n7;
                }
                if (basicConstraints != null && (bigInteger = basicConstraints.getPathLenConstraint()) != null && (n9 = bigInteger.intValue()) < n7) {
                    n7 = n9;
                }
                if ((blArray = x509Certificate2.getKeyUsage()) != null && !blArray[5]) {
                    throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, n3);
                }
                if (x509Certificate2.hasUnsupportedCriticalExtension()) {
                    HashSet<String> hashSet12 = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
                    hashSet12.remove(KEY_USAGE);
                    hashSet12.remove(CERTIFICATE_POLICIES);
                    hashSet12.remove(POLICY_MAPPINGS);
                    hashSet12.remove(INHIBIT_ANY_POLICY);
                    hashSet12.remove(ISSUING_DISTRIBUTION_POINT);
                    hashSet12.remove(DELTA_CRL_INDICATOR);
                    hashSet12.remove(POLICY_CONSTRAINTS);
                    hashSet12.remove(BASIC_CONSTRAINTS);
                    hashSet12.remove(SUBJECT_ALTERNATIVE_NAME);
                    hashSet12.remove(NAME_CONSTRAINTS);
                    iterator = pKIXParameters.getCertPathCheckers().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().check(x509Certificate2, hashSet12);
                    }
                    if (!hashSet12.isEmpty()) {
                        throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
                    }
                }
            }
            x509Certificate = x509Certificate2;
            publicKey = x509Certificate.getPublicKey();
            try {
                x500Principal = x509Certificate.getSubjectX500Principal();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertPathValidatorException(x509Certificate.getSubjectDN().getName() + " :" + illegalArgumentException.toString());
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
            dERObjectIdentifier = algorithmIdentifier.getObjectId();
            dEREncodable = algorithmIdentifier.getParameters();
        }
        if (!this.isSelfIssued(x509Certificate2) && n4 != 0) {
            --n4;
        }
        if ((iterator2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
            object = ((ASN1Sequence)((Object)iterator2)).getObjects();
            while (object.hasMoreElements()) {
                object2 = (ASN1TaggedObject)object.nextElement();
                switch (((ASN1TaggedObject)object2).getTagNo()) {
                    case 0: {
                        n = DERInteger.getInstance(object2).getValue().intValue();
                        if (n != 0) break;
                        n4 = 0;
                    }
                }
            }
        }
        if (x509Certificate2.hasUnsupportedCriticalExtension()) {
            object = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
            object.remove(KEY_USAGE);
            object.remove(CERTIFICATE_POLICIES);
            object.remove(POLICY_MAPPINGS);
            object.remove(INHIBIT_ANY_POLICY);
            object.remove(ISSUING_DISTRIBUTION_POINT);
            object.remove(DELTA_CRL_INDICATOR);
            object.remove(POLICY_CONSTRAINTS);
            object.remove(BASIC_CONSTRAINTS);
            object.remove(SUBJECT_ALTERNATIVE_NAME);
            object.remove(NAME_CONSTRAINTS);
            iterator = pKIXParameters.getCertPathCheckers().iterator();
            while (iterator.hasNext()) {
                iterator.next().check(x509Certificate2, (Collection<String>)object);
            }
            if (!object.isEmpty()) {
                throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
            }
        }
        if (pKIXPolicyNode == null) {
            object = null;
        } else if (this.isAnyPolicy(set)) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                if (hashSet10.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none avaliable");
                }
                object2 = new HashSet();
                for (int i = 0; i < arrayListArray.length; ++i) {
                    ArrayList arrayList = arrayListArray[i];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)arrayList.get(j);
                        if (!ANY_POLICY.equals(pKIXPolicyNode4.getValidPolicy())) continue;
                        Iterator iterator5 = pKIXPolicyNode4.getChildren();
                        while (iterator5.hasNext()) {
                            object2.add(iterator5.next());
                        }
                    }
                }
                Iterator iterator6 = object2.iterator();
                while (iterator6.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)iterator6.next();
                    String string = pKIXPolicyNode5.getValidPolicy();
                    if (hashSet10.contains(string)) continue;
                    pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode5);
                }
                if (pKIXPolicyNode != null) {
                    for (int i = n2 - 1; i >= 0; --i) {
                        ArrayList arrayList = arrayListArray[i];
                        for (int j = 0; j < arrayList.size(); ++j) {
                            PKIXPolicyNode pKIXPolicyNode6 = (PKIXPolicyNode)arrayList.get(j);
                            if (pKIXPolicyNode6.hasChildren()) continue;
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode6);
                        }
                    }
                }
            }
            object = pKIXPolicyNode;
        } else {
            object2 = new HashSet();
            for (int i = 0; i < arrayListArray.length; ++i) {
                ArrayList arrayList = arrayListArray[i];
                for (int j = 0; j < arrayList.size(); ++j) {
                    PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)arrayList.get(j);
                    if (!ANY_POLICY.equals(pKIXPolicyNode7.getValidPolicy())) continue;
                    Iterator iterator7 = pKIXPolicyNode7.getChildren();
                    while (iterator7.hasNext()) {
                        object2.add(iterator7.next());
                    }
                }
            }
            Iterator iterator8 = object2.iterator();
            while (iterator8.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)iterator8.next();
                String string = pKIXPolicyNode8.getValidPolicy();
                if (set.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode8);
            }
            iterator8 = object2.iterator();
            while (iterator8.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode9 = (PKIXPolicyNode)iterator8.next();
                String string = pKIXPolicyNode9.getValidPolicy();
                if (hashSet10.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode9);
            }
            if (pKIXPolicyNode != null) {
                for (int i = n2 - 1; i >= 0; --i) {
                    ArrayList arrayList = arrayListArray[i];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        PKIXPolicyNode pKIXPolicyNode10 = (PKIXPolicyNode)arrayList.get(j);
                        if (pKIXPolicyNode10.hasChildren()) continue;
                        pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode10);
                    }
                }
            }
            object = pKIXPolicyNode;
        }
        if (n4 > 0 || object != null || this.isAnyPolicy(hashSet10)) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)object, publicKey);
        }
        throw new CertPathValidatorException("Path processing failed");
    }

    private final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) {
        HashSet<? extends CRL> hashSet = new HashSet<CRL>();
        for (CertStore certStore : list) {
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                certStoreException.printStackTrace();
            }
        }
        return hashSet;
    }

    final TrustAnchor findTrustAnchor(X509Certificate x509Certificate, Set set) throws CertPathValidatorException {
        Iterator iterator = set.iterator();
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
                        X500Principal x500Principal2 = new X500Principal(trustAnchor.getCAName());
                        if (x500Principal.equals(x500Principal2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new CertPathValidatorException("TrustAnchor found put certificate validation failed", exception);
        }
        return trustAnchor;
    }
}

