/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.IOException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.Holder;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class AttributeCertificateHolder
implements CertSelector {
    Holder holder;

    AttributeCertificateHolder(ASN1Sequence aSN1Sequence) {
        this.holder = Holder.getInstance(aSN1Sequence);
    }

    public AttributeCertificateHolder(X509Certificate x509Certificate) throws CertificateParsingException {
        X509Principal x509Principal;
        try {
            x509Principal = PrincipalUtil.getIssuerX509Principal(x509Certificate);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
        this.holder = new Holder(new IssuerSerial(new GeneralNames(new DERSequence(new GeneralName(new X509Principal(x509Principal)))), new DERInteger(x509Certificate.getSerialNumber())));
    }

    public AttributeCertificateHolder(X500Principal x500Principal) throws IOException {
        this(new X509Principal(x500Principal.getEncoded()));
    }

    public AttributeCertificateHolder(X509Principal x509Principal) {
        this.holder = new Holder(new GeneralNames(new DERSequence(new GeneralName(x509Principal))));
    }

    private boolean matchesDN(X500Principal x500Principal, GeneralNames generalNames) {
        GeneralName[] generalNameArray = generalNames.getNames();
        for (int i = 0; i != generalNameArray.length; ++i) {
            GeneralName generalName = generalNameArray[i];
            if (generalName.getTagNo() != 4) continue;
            try {
                if (!new X500Principal(((ASN1Encodable)generalName.getName()).getEncoded()).equals(x500Principal)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public Object clone() {
        return new AttributeCertificateHolder((ASN1Sequence)this.holder.toASN1Object());
    }

    public boolean match(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (this.holder.getBaseCertificateID() != null) {
            return this.holder.getBaseCertificateID().getSerial().getValue().equals(x509Certificate.getSerialNumber()) && this.matchesDN(x509Certificate.getIssuerX500Principal(), this.holder.getBaseCertificateID().getIssuer());
        }
        return this.holder.getEntityName() != null && this.matchesDN(x509Certificate.getSubjectX500Principal(), this.holder.getEntityName());
    }
}

