/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PGPCompressionTest
implements Test {
    private boolean notEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return true;
        }
        for (int i = 0; i != byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return true;
        }
        return false;
    }

    public TestResult perform() {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
            OutputStream outputStream = pGPCompressedDataGenerator.open(byteArrayOutputStream);
            outputStream.write("hello world!".getBytes());
            pGPCompressedDataGenerator.close();
            PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(byteArrayOutputStream.toByteArray());
            PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory.nextObject();
            InputStream inputStream = pGPCompressedData.getDataStream();
            byteArrayOutputStream.reset();
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            if (this.notEqual(byteArrayOutputStream.toByteArray(), "hello world!".getBytes())) {
                return new SimpleTestResult(false, this.getName() + ": compression test failed");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "PGPCompressionTest";
    }

    public static void main(String[] stringArray) {
        PGPCompressionTest pGPCompressionTest = new PGPCompressionTest();
        TestResult testResult = pGPCompressionTest.perform();
        System.out.println(testResult.toString());
    }
}

