/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertPathValidatorException;
import org.bouncycastle.jce.cert.CertPathValidatorResult;
import org.bouncycastle.jce.cert.CertPathValidatorSpi;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.PKIXCertPathChecker;
import org.bouncycastle.jce.cert.PKIXCertPathValidatorResult;
import org.bouncycastle.jce.cert.PKIXParameters;
import org.bouncycastle.jce.cert.PolicyNode;
import org.bouncycastle.jce.cert.PolicyQualifierInfo;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.cert.X509CRLSelector;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;

    private DERObject getExtensionValue(X509Extension x509Extension, String string) throws CertPathValidatorException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(aSN1OctetString.getOctets()));
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing extension " + string);
        }
    }

    private boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        int n = aSN1Sequence2.size() - 1;
        while (n >= 0) {
            if (!aSN1Sequence2.getObjectAt(n).equals(aSN1Sequence.getObjectAt(n))) {
                return false;
            }
            --n;
        }
        return true;
    }

    private List sortCerts(List list, X509Certificate x509Certificate) throws CertPathValidatorException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        try {
            X509Principal x509Principal = PrincipalUtil.getIssuerX509Principal(x509Certificate);
            int n = list.size();
            while (n > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                    if (!PrincipalUtil.getIssuerX509Principal(x509Certificate2).equals(x509Principal)) continue;
                    x509Principal = PrincipalUtil.getSubjectX509Principal(x509Certificate2);
                    arrayList.add(0, x509Certificate2);
                    iterator.remove();
                }
                --n;
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CertPathValidatorException(certificateEncodingException.getMessage());
        }
        int n = 0;
        while (n != list.size()) {
            arrayList.add((X509Certificate)list.get(n));
            ++n;
        }
        return arrayList;
    }

    private void checkPermittedDN(HashSet hashSet, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(HashSet hashSet, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private HashSet intersectDN(HashSet hashSet, ASN1Sequence aSN1Sequence) {
        if (hashSet.isEmpty()) {
            hashSet.add(aSN1Sequence);
            return hashSet;
        }
        HashSet<ASN1Sequence> hashSet2 = new HashSet<ASN1Sequence>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet2.add(aSN1Sequence);
                continue;
            }
            if (!this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet2.add(aSN1Sequence2);
        }
        return hashSet2;
    }

    private HashSet unionDN(HashSet hashSet, ASN1Sequence aSN1Sequence) {
        if (hashSet.isEmpty()) {
            hashSet.add(aSN1Sequence);
            return hashSet;
        }
        HashSet<ASN1Sequence> hashSet2 = new HashSet<ASN1Sequence>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet2.add(aSN1Sequence2);
                continue;
            }
            if (this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet2.add(aSN1Sequence);
                continue;
            }
            hashSet2.add(aSN1Sequence2);
            hashSet2.add(aSN1Sequence);
        }
        return hashSet2;
    }

    private HashSet intersectEmail(HashSet hashSet, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (hashSet.isEmpty()) {
            hashSet.add(string2);
            return hashSet;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.endsWith(string3)) {
                hashSet2.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet2.add(string3);
        }
        return hashSet2;
    }

    private HashSet unionEmail(HashSet hashSet, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (hashSet.isEmpty()) {
            hashSet.add(string2);
            return hashSet;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.endsWith(string3)) {
                hashSet2.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet2.add(string2);
                continue;
            }
            hashSet2.add(string3);
            hashSet2.add(string2);
        }
        return hashSet2;
    }

    private HashSet intersectIP(HashSet hashSet, byte[] byArray) {
        return hashSet;
    }

    private HashSet unionIP(HashSet hashSet, byte[] byArray) {
        return hashSet;
    }

    private void checkPermittedEmail(HashSet hashSet, String string) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    private void checkExcludedEmail(HashSet hashSet, String string) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    private void checkPermittedIP(HashSet hashSet, byte[] byArray) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
    }

    private void checkExcludedIP(HashSet hashSet, byte[] byArray) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
    }

    private PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, ArrayList[] arrayListArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            int n = 0;
            while (n < arrayListArray.length) {
                arrayListArray[n] = new ArrayList();
                ++n;
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        this.removePolicyNodeRecurse(arrayListArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private void removePolicyNodeRecurse(ArrayList[] arrayListArray, PKIXPolicyNode pKIXPolicyNode) {
        ((AbstractCollection)arrayListArray[pKIXPolicyNode.getDepth()]).remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                this.removePolicyNodeRecurse(arrayListArray, pKIXPolicyNode2);
            }
        }
    }

    private boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    private boolean isAnyPolicy(Set set) {
        return set.contains(ANY_POLICY) || set.size() == 0;
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    private final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    private boolean processCertD1i(int n, ArrayList[] arrayListArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        ArrayList arrayList = arrayListArray[n - 1];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(n2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (set2.contains(dERObjectIdentifier.getId())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(dERObjectIdentifier.getId());
                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
                pKIXPolicyNode.addChild(pKIXPolicyNode2);
                arrayListArray[n].add(pKIXPolicyNode2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void processCertD1ii(int n, ArrayList[] arrayListArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        ArrayList arrayList = arrayListArray[n - 1];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(n2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(dERObjectIdentifier.getId());
                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
                pKIXPolicyNode.addChild(pKIXPolicyNode2);
                arrayListArray[n].add(pKIXPolicyNode2);
                return;
            }
            ++n2;
        }
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator iterator;
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PublicKey publicKey;
        X509Principal x509Principal;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        Set set = pKIXParameters.getInitialPolicies();
        TrustAnchor trustAnchor = null;
        int n3 = 0;
        while (n3 < list.size()) {
            trustAnchor = this.findTrustAnchor((X509Certificate)list.get(list.size() - 1), pKIXParameters.getTrustAnchors());
            if (trustAnchor != null) break;
            ++n3;
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found", null, certPath, 0);
        }
        list = this.sortCerts(list, trustAnchor.getTrustedCert());
        int n4 = 0;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ArrayList[] arrayListArray = new ArrayList[n2 + 1];
        int n5 = 0;
        while (n5 < arrayListArray.length) {
            arrayListArray[n5] = new ArrayList();
            ++n5;
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add(ANY_POLICY);
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet3, null, new HashSet(), ANY_POLICY, false);
        arrayListArray[0].add(pKIXPolicyNode);
        HashSet hashSet4 = new HashSet();
        HashSet hashSet5 = new HashSet();
        HashSet hashSet6 = new HashSet();
        HashSet hashSet7 = new HashSet();
        HashSet hashSet8 = new HashSet();
        HashSet hashSet9 = new HashSet();
        HashSet<String> hashSet10 = null;
        int n6 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n7 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n8 = pKIXParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x509Principal = PrincipalUtil.getSubjectX509Principal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x509Principal = new X509Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + certificateEncodingException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
        DERObjectIdentifier dERObjectIdentifier = algorithmIdentifier.getObjectId();
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        int n9 = n2;
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        Iterator iterator2 = pKIXParameters.getCertPathCheckers().iterator();
        while (iterator2.hasNext()) {
            ((PKIXCertPathChecker)iterator2.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        n4 = list.size() - 1;
        while (n4 >= 0) {
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            int n10 = n2 - n4;
            x509Certificate2 = (X509Certificate)list.get(n4);
            try {
                x509Certificate2.verify(publicKey, "BC");
                x509Certificate2.checkValidity(date);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CertPathValidatorException("couldn't validate certificate: " + generalSecurityException);
            }
            if (pKIXParameters.isRevocationEnabled()) {
                boolean bl = false;
                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                try {
                    x509CRLSelector.addIssuerName(PrincipalUtil.getIssuerX509Principal(x509Certificate2).getEncoded());
                }
                catch (Exception exception) {
                    throw new CertPathValidatorException("can't extract issuer from certificate: " + exception);
                }
                x509CRLSelector.setCertificateChecking(x509Certificate2);
                object4 = this.findCRLs(x509CRLSelector, pKIXParameters.getCertStores()).iterator();
                while (object4.hasNext()) {
                    Object object9;
                    object8 = (X509CRL)object4.next();
                    if (!date.after(((X509CRL)object8).getThisUpdate())) continue;
                    if (((X509CRL)object8).getNextUpdate() == null || date.before(((X509CRL)object8).getNextUpdate())) {
                        bl = true;
                    }
                    if (x509Certificate != null && (object7 = (Object)x509Certificate.getKeyUsage()) != null && (((Object)object7).length < 7 || object7[6] == false)) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension does not permit crl signing.\n" + x509Certificate, null, certPath, n4);
                    }
                    try {
                        ((X509CRL)object8).verify(publicKey, "BC");
                    }
                    catch (Exception exception) {
                        throw new CertPathValidatorException("can't verify CRL: " + exception);
                    }
                    object3 = ((X509CRL)object8).getRevokedCertificate(x509Certificate2.getSerialNumber());
                    if (object3 != null && !date.before(((X509CRLEntry)object3).getRevocationDate())) {
                        throw new CertPathValidatorException("Certificate revocation after " + ((X509CRLEntry)object3).getRevocationDate(), null, certPath, n4);
                    }
                    object7 = this.getExtensionValue((X509Extension)object8, ISSUING_DISTRIBUTION_POINT);
                    object2 = this.getExtensionValue((X509Extension)object8, DELTA_CRL_INDICATOR);
                    if (object2 != null) {
                        object9 = new X509CRLSelector();
                        try {
                            ((X509CRLSelector)object9).addIssuerName(((X509Principal)((X509CRL)object8).getIssuerDN()).getEncoded());
                        }
                        catch (IOException iOException) {
                            throw new CertPathValidatorException("can't extract issuer from certificate: " + iOException);
                        }
                        ((X509CRLSelector)object9).setMinCRLNumber(((DERInteger)object2).getPositiveValue());
                        ((X509CRLSelector)object9).setMaxCRLNumber(((DERInteger)this.getExtensionValue((X509Extension)object8, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                        boolean bl2 = false;
                        object6 = this.findCRLs((X509CRLSelector)object9, pKIXParameters.getCertStores()).iterator();
                        while (object6.hasNext()) {
                            object = (X509CRL)object6.next();
                            object5 = this.getExtensionValue((X509Extension)object, ISSUING_DISTRIBUTION_POINT);
                            if (object7 == null) {
                                if (object5 != null) continue;
                                bl2 = true;
                                break;
                            }
                            if (!((DERObject)object7).equals(object5)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            throw new CertPathValidatorException("No base CRL for delta CRL");
                        }
                    }
                    if (object7 == null) continue;
                    object9 = IssuingDistributionPoint.getInstance(object7);
                    BasicConstraints basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS));
                    if (((IssuingDistributionPoint)object9).onlyContainsUserCerts() && (basicConstraints == null || basicConstraints.isCA())) {
                        throw new CertPathValidatorException("CA Cert CRL only contains user certificates");
                    }
                    if (((IssuingDistributionPoint)object9).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                        throw new CertPathValidatorException("End CRL only contains CA certificates");
                    }
                    if (!((IssuingDistributionPoint)object9).onlyContainsAttributeCerts()) continue;
                    throw new CertPathValidatorException("onlyContainsAttributeCerts boolean is asserted");
                }
                if (!bl) {
                    throw new CertPathValidatorException("no valid CRL found", null, certPath, n4);
                }
            }
            try {
                if (!PrincipalUtil.getIssuerX509Principal(x509Certificate2).equals(x509Principal)) {
                    throw new CertPathValidatorException("IssuerName(" + PrincipalUtil.getIssuerX509Principal(x509Certificate2) + ") does not match SubjectName(" + x509Principal + ") of signing certificate", null, certPath, n4);
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new CertPathValidatorException("Encoding error on issuer.");
            }
            if (!this.isSelfIssued(x509Certificate2) || n10 >= n2) {
                try {
                    object3 = PrincipalUtil.getSubjectX509Principal(x509Certificate2);
                    object8 = new ASN1InputStream(new ByteArrayInputStream(((X509Principal)object3).getEncoded()));
                    object4 = (ASN1Sequence)((ASN1InputStream)object8).readObject();
                }
                catch (Exception exception) {
                    throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                }
                this.checkPermittedDN(hashSet4, (ASN1Sequence)object4);
                this.checkExcludedDN(hashSet7, (ASN1Sequence)object4);
                object3 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, SUBJECT_ALTERNATIVE_NAME);
                if (object3 != null) {
                    int n11 = 0;
                    while (n11 < ((ASN1Sequence)object3).size()) {
                        object7 = (ASN1TaggedObject)((ASN1Sequence)object3).getObjectAt(n11);
                        switch (((ASN1TaggedObject)object7).getTagNo()) {
                            case 1: {
                                object2 = DERIA5String.getInstance((ASN1TaggedObject)object7, true).getString();
                                this.checkPermittedEmail(hashSet5, (String)object2);
                                this.checkExcludedEmail(hashSet8, (String)object2);
                                break;
                            }
                            case 4: {
                                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((ASN1TaggedObject)object7, true);
                                this.checkPermittedDN(hashSet4, aSN1Sequence);
                                this.checkExcludedDN(hashSet7, aSN1Sequence);
                                break;
                            }
                            case 7: {
                                byte[] byArray = ASN1OctetString.getInstance((ASN1TaggedObject)object7, true).getOctets();
                                this.checkPermittedIP(hashSet6, byArray);
                                this.checkExcludedIP(hashSet9, byArray);
                            }
                        }
                        ++n11;
                    }
                }
            }
            if ((object4 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES)) != null && pKIXPolicyNode != null) {
                object3 = ((ASN1Sequence)object4).getObjects();
                HashSet<String> hashSet11 = new HashSet<String>();
                while (object3.hasMoreElements()) {
                    Set set2;
                    boolean bl;
                    object7 = PolicyInformation.getInstance(object3.nextElement());
                    object2 = ((PolicyInformation)object7).getPolicyIdentifier();
                    hashSet11.add(((DERObjectIdentifier)object2).getId());
                    if (ANY_POLICY.equals(((DERObjectIdentifier)object2).getId()) || (bl = this.processCertD1i(n10, arrayListArray, (DERObjectIdentifier)object2, set2 = this.getQualifierSet(((PolicyInformation)object7).getPolicyQualifiers())))) continue;
                    this.processCertD1ii(n10, arrayListArray, (DERObjectIdentifier)object2, set2);
                }
                if (hashSet10 == null) {
                    hashSet10 = hashSet11;
                } else {
                    object7 = hashSet10.iterator();
                    object2 = new HashSet();
                    while (object7.hasNext()) {
                        Object e = object7.next();
                        if (!hashSet11.contains(e)) continue;
                        ((HashSet)object2).add(e);
                    }
                    hashSet10 = object2;
                }
                if (n7 > 0 || n10 < n2 && this.isSelfIssued(x509Certificate2)) {
                    object3 = ((ASN1Sequence)object4).getObjects();
                    while (object3.hasMoreElements()) {
                        object7 = PolicyInformation.getInstance(object3.nextElement());
                        if (ANY_POLICY.equals(((PolicyInformation)object7).getPolicyIdentifier().getId())) continue;
                        object2 = this.getQualifierSet(((PolicyInformation)object7).getPolicyQualifiers());
                        ArrayList arrayList = arrayListArray[n10 - 1];
                        int n12 = 0;
                        while (n12 < arrayList.size()) {
                            object6 = (PKIXPolicyNode)arrayList.get(n12);
                            object = ((PKIXPolicyNode)object6).getExpectedPolicies().iterator();
                            while (object.hasNext()) {
                                Object object10;
                                String string;
                                object5 = object.next();
                                if (object5 instanceof String) {
                                    string = (String)object5;
                                } else {
                                    if (!(object5 instanceof DERObjectIdentifier)) continue;
                                    string = ((DERObjectIdentifier)object5).getId();
                                }
                                boolean bl = false;
                                Iterator iterator3 = ((PKIXPolicyNode)object6).getChildren();
                                while (iterator3.hasNext()) {
                                    object10 = (PKIXPolicyNode)iterator3.next();
                                    if (!string.equals(((PKIXPolicyNode)object10).getValidPolicy())) continue;
                                    bl = true;
                                }
                                if (bl) continue;
                                object10 = new HashSet();
                                object10.add(string);
                                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n10, (Set)object10, (PolicyNode)object6, (Set)object2, string, false);
                                ((PKIXPolicyNode)object6).addChild(pKIXPolicyNode2);
                                arrayListArray[n10].add(pKIXPolicyNode2);
                            }
                            ++n12;
                        }
                        break block48;
                    }
                }
                int n13 = n10 - 1;
                while (n13 >= 0) {
                    object2 = arrayListArray[n13];
                    int n14 = 0;
                    while (n14 < ((ArrayList)object2).size()) {
                        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)((ArrayList)object2).get(n14);
                        if (!pKIXPolicyNode3.hasChildren() && (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode3)) == null) break;
                        ++n14;
                    }
                    --n13;
                }
                object2 = x509Certificate2.getCriticalExtensionOIDs();
                if (object2 != null) {
                    boolean bl = object2.contains(CERTIFICATE_POLICIES);
                    ArrayList arrayList = arrayListArray[n10];
                    int n15 = 0;
                    while (n15 < arrayList.size()) {
                        object = (PKIXPolicyNode)arrayList.get(n15);
                        ((PKIXPolicyNode)object).setCritical(bl);
                        ++n15;
                    }
                }
                int n16 = n10 - 1;
                while (n16 >= 0) {
                    ArrayList arrayList = arrayListArray[n16];
                    int n17 = 0;
                    while (n17 < arrayList.size()) {
                        object = (PKIXPolicyNode)arrayList.get(n17);
                        if (!((PKIXPolicyNode)object).hasChildren()) {
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, (PKIXPolicyNode)object);
                        }
                        ++n17;
                    }
                    --n16;
                }
            }
            if (object4 == null) {
                pKIXPolicyNode = null;
            }
            if (n6 <= 0 && pKIXPolicyNode == null && !this.isAnyPolicy(hashSet10)) {
                throw new CertPathValidatorException("Failure in process (f)");
            }
            if (n10 != n2) {
                boolean[] blArray;
                int n18;
                BigInteger bigInteger;
                BasicConstraints basicConstraints;
                int n19;
                ASN1Sequence aSN1Sequence;
                ASN1Sequence aSN1Sequence2;
                if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                    throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                }
                object3 = this.getExtensionValue(x509Certificate2, POLICY_MAPPINGS);
                if (object3 != null) {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)object3;
                    int n20 = 0;
                    while (n20 < aSN1Sequence3.size()) {
                        object2 = (ASN1Sequence)aSN1Sequence3.getObjectAt(n20);
                        DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)((ASN1Sequence)object2).getObjectAt(0);
                        DERObjectIdentifier dERObjectIdentifier3 = (DERObjectIdentifier)((ASN1Sequence)object2).getObjectAt(1);
                        if (ANY_POLICY.equals(dERObjectIdentifier2.getId())) {
                            throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                        }
                        if (ANY_POLICY.equals(dERObjectIdentifier3.getId())) {
                            throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                        }
                        ++n20;
                    }
                }
                if ((aSN1Sequence2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, NAME_CONSTRAINTS)) != null) {
                    ASN1Sequence aSN1Sequence4;
                    NameConstraints nameConstraints = new NameConstraints(aSN1Sequence2);
                    object2 = nameConstraints.getPermittedSubtrees();
                    if (object2 != null) {
                        Enumeration enumeration = ((ASN1Sequence)object2).getObjects();
                        while (enumeration.hasMoreElements()) {
                            GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                            GeneralName generalName = generalSubtree.getBase();
                            switch (generalName.getTagNo()) {
                                case 1: {
                                    hashSet5 = this.intersectEmail(hashSet5, DERIA5String.getInstance(generalName.getName()).getString());
                                    break;
                                }
                                case 4: {
                                    hashSet4 = this.intersectDN(hashSet4, (ASN1Sequence)generalName.getName());
                                    break;
                                }
                                case 7: {
                                    hashSet6 = this.intersectIP(hashSet6, ASN1OctetString.getInstance(generalName.getName()).getOctets());
                                }
                            }
                        }
                    }
                    if ((aSN1Sequence4 = nameConstraints.getExcludedSubtrees()) != null) {
                        Enumeration enumeration = aSN1Sequence4.getObjects();
                        while (enumeration.hasMoreElements()) {
                            GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                            object = generalSubtree.getBase();
                            switch (((GeneralName)object).getTagNo()) {
                                case 1: {
                                    hashSet8 = this.unionEmail(hashSet8, DERIA5String.getInstance(((GeneralName)object).getName()).getString());
                                    break;
                                }
                                case 4: {
                                    hashSet7 = this.unionDN(hashSet7, (ASN1Sequence)((GeneralName)object).getName());
                                    break;
                                }
                                case 7: {
                                    hashSet9 = this.unionIP(hashSet9, ASN1OctetString.getInstance(((GeneralName)object).getName()).getOctets());
                                }
                            }
                        }
                    }
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n6 != 0) {
                        --n6;
                    }
                    if (n8 != 0) {
                        --n8;
                    }
                    if (n7 != 0) {
                        --n7;
                    }
                }
                if ((aSN1Sequence = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
                    object2 = aSN1Sequence.getObjects();
                    while (object2.hasMoreElements()) {
                        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object2.nextElement();
                        switch (aSN1TaggedObject.getTagNo()) {
                            case 0: {
                                n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n >= n6) break;
                                n6 = n;
                                break;
                            }
                            case 1: {
                                n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n >= n7) break;
                                n7 = n;
                            }
                        }
                    }
                }
                if ((object2 = (DERInteger)this.getExtensionValue(x509Certificate2, INHIBIT_ANY_POLICY)) != null && (n19 = ((DERInteger)object2).getValue().intValue()) < n7) {
                    n7 = n19;
                }
                if ((basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS))) != null) {
                    if (!basicConstraints.isCA()) {
                        throw new CertPathValidatorException("Not a CA certificate");
                    }
                } else {
                    throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n9 <= 0) {
                        throw new CertPathValidatorException("Max path length not greater than zero");
                    }
                    --n9;
                }
                if (basicConstraints != null && (bigInteger = basicConstraints.getPathLenConstraint()) != null && (n18 = bigInteger.intValue()) < n9) {
                    n9 = n18;
                }
                if ((blArray = x509Certificate2.getKeyUsage()) != null && !blArray[5]) {
                    throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, n4);
                }
                if (x509Certificate2.hasUnsupportedCriticalExtension()) {
                    HashSet<String> hashSet12 = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
                    hashSet12.remove(KEY_USAGE);
                    hashSet12.remove(CERTIFICATE_POLICIES);
                    hashSet12.remove(POLICY_MAPPINGS);
                    hashSet12.remove(INHIBIT_ANY_POLICY);
                    hashSet12.remove(ISSUING_DISTRIBUTION_POINT);
                    hashSet12.remove(DELTA_CRL_INDICATOR);
                    hashSet12.remove(POLICY_CONSTRAINTS);
                    hashSet12.remove(BASIC_CONSTRAINTS);
                    hashSet12.remove(SUBJECT_ALTERNATIVE_NAME);
                    hashSet12.remove(NAME_CONSTRAINTS);
                    iterator = pKIXParameters.getCertPathCheckers().iterator();
                    while (iterator.hasNext()) {
                        ((PKIXCertPathChecker)iterator.next()).check(x509Certificate2, hashSet12);
                    }
                    if (!hashSet12.isEmpty()) {
                        throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n4);
                    }
                }
            }
            x509Certificate = x509Certificate2;
            publicKey = x509Certificate.getPublicKey();
            try {
                x509Principal = PrincipalUtil.getSubjectX509Principal(x509Certificate);
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(x509Certificate.getSubjectDN().getName() + " :" + exception.toString());
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
            dERObjectIdentifier = algorithmIdentifier.getObjectId();
            dEREncodable = algorithmIdentifier.getParameters();
            --n4;
        }
        if (!this.isSelfIssued(x509Certificate2) && n6 != 0) {
            --n6;
        }
        if ((object4 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
            object3 = ((ASN1Sequence)object4).getObjects();
            while (object3.hasMoreElements()) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object3.nextElement();
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                        if (n != 0) break;
                        n6 = 0;
                    }
                }
            }
        }
        if (x509Certificate2.hasUnsupportedCriticalExtension()) {
            object3 = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
            object3.remove(KEY_USAGE);
            object3.remove(CERTIFICATE_POLICIES);
            object3.remove(POLICY_MAPPINGS);
            object3.remove(INHIBIT_ANY_POLICY);
            object3.remove(ISSUING_DISTRIBUTION_POINT);
            object3.remove(DELTA_CRL_INDICATOR);
            object3.remove(POLICY_CONSTRAINTS);
            object3.remove(BASIC_CONSTRAINTS);
            object3.remove(SUBJECT_ALTERNATIVE_NAME);
            object3.remove(NAME_CONSTRAINTS);
            iterator = pKIXParameters.getCertPathCheckers().iterator();
            while (iterator.hasNext()) {
                ((PKIXCertPathChecker)iterator.next()).check(x509Certificate2, (Collection)object3);
            }
            if (!object3.isEmpty()) {
                throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n4);
            }
        }
        if (pKIXPolicyNode == null) {
            object3 = null;
        } else if (this.isAnyPolicy(set)) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                if (hashSet10.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none avaliable");
                }
                HashSet hashSet13 = new HashSet();
                int n21 = 0;
                while (n21 < arrayListArray.length) {
                    object2 = arrayListArray[n21];
                    int n22 = 0;
                    while (n22 < ((ArrayList)object2).size()) {
                        PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)((ArrayList)object2).get(n22);
                        if (ANY_POLICY.equals(pKIXPolicyNode4.getValidPolicy())) {
                            Iterator iterator4 = pKIXPolicyNode4.getChildren();
                            while (iterator4.hasNext()) {
                                hashSet13.add(iterator4.next());
                            }
                        }
                        ++n22;
                    }
                    ++n21;
                }
                object2 = hashSet13.iterator();
                while (object2.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)object2.next();
                    String string = pKIXPolicyNode5.getValidPolicy();
                    if (hashSet10.contains(string)) continue;
                    pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode5);
                }
                if (pKIXPolicyNode != null) {
                    int n23 = n2 - 1;
                    while (n23 >= 0) {
                        ArrayList arrayList = arrayListArray[n23];
                        int n24 = 0;
                        while (n24 < arrayList.size()) {
                            object = (PKIXPolicyNode)arrayList.get(n24);
                            if (!((PKIXPolicyNode)object).hasChildren()) {
                                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, (PKIXPolicyNode)object);
                            }
                            ++n24;
                        }
                        --n23;
                    }
                }
            }
            object3 = pKIXPolicyNode;
        } else {
            HashSet hashSet14 = new HashSet();
            int n25 = 0;
            while (n25 < arrayListArray.length) {
                object2 = arrayListArray[n25];
                int n26 = 0;
                while (n26 < ((ArrayList)object2).size()) {
                    PKIXPolicyNode pKIXPolicyNode6 = (PKIXPolicyNode)((ArrayList)object2).get(n26);
                    if (ANY_POLICY.equals(pKIXPolicyNode6.getValidPolicy())) {
                        Iterator iterator5 = pKIXPolicyNode6.getChildren();
                        while (iterator5.hasNext()) {
                            hashSet14.add(iterator5.next());
                        }
                    }
                    ++n26;
                }
                ++n25;
            }
            object2 = hashSet14.iterator();
            while (object2.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)object2.next();
                String string = pKIXPolicyNode7.getValidPolicy();
                if (set.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode7);
            }
            object2 = hashSet14.iterator();
            while (object2.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)object2.next();
                String string = pKIXPolicyNode8.getValidPolicy();
                if (hashSet10.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode8);
            }
            if (pKIXPolicyNode != null) {
                int n27 = n2 - 1;
                while (n27 >= 0) {
                    ArrayList arrayList = arrayListArray[n27];
                    int n28 = 0;
                    while (n28 < arrayList.size()) {
                        object = (PKIXPolicyNode)arrayList.get(n28);
                        if (!((PKIXPolicyNode)object).hasChildren()) {
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, (PKIXPolicyNode)object);
                        }
                        ++n28;
                    }
                    --n27;
                }
            }
            object3 = pKIXPolicyNode;
        }
        if (n6 > 0 || object3 != null || this.isAnyPolicy(hashSet10)) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)object3, publicKey);
        }
        throw new CertPathValidatorException("Path processing failed");
    }

    private final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                certStoreException.printStackTrace();
            }
        }
        return hashSet;
    }

    /*
     * Unable to fully structure code
     */
    final TrustAnchor findTrustAnchor(X509Certificate var1_1, Set var2_2) throws CertPathValidatorException {
        var3_3 = var2_2.iterator();
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = new X509CertSelector();
        try {
            var7_7.setSubject(PrincipalUtil.getIssuerX509Principal(var1_1).getEncoded());
            if (true) ** GOTO lbl39
        }
        catch (Exception var8_8) {
            return null;
        }
        do {
            block15: {
                if ((var4_4 = (TrustAnchor)var3_3.next()).getTrustedCert() != null) {
                    if (var7_7.match(var4_4.getTrustedCert())) {
                        var5_5 = var4_4.getTrustedCert().getPublicKey();
                    } else {
                        var4_4 = null;
                    }
                } else if (var4_4.getCAName() != null && var4_4.getCAPublicKey() != null) {
                    try {
                        var8_9 = PrincipalUtil.getIssuerX509Principal(var1_1);
                        var9_12 = new X509Principal(var4_4.getCAName());
                        if (var8_9.equals(var9_12)) {
                            var5_5 = var4_4.getCAPublicKey();
                            break block15;
                        }
                        var4_4 = null;
                    }
                    catch (Exception var8_10) {
                        var4_4 = null;
                    }
                } else {
                    var4_4 = null;
                }
            }
            if (var5_5 == null) continue;
            try {
                var1_1.verify(var5_5);
            }
            catch (Exception var8_11) {
                var6_6 = var8_11;
                var4_4 = null;
            }
lbl39:
            // 4 sources

        } while (var3_3.hasNext() && var4_4 == null);
        if (var4_4 == null && var6_6 != null) {
            throw new CertPathValidatorException("TrustAnchor found put certificate validation failed", var6_6);
        }
        return var4_4;
    }
}

