/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

public class pkcs7_mime
implements DataContentHandler {
    private static final ActivationDataFlavor ADF1 = new ActivationDataFlavor(MimeBodyPart.class, "application/pkcs7-mime", "Encrypted Data");
    private static final DataFlavor[] ADFs = new DataFlavor[]{ADF1};
    private static final String PRIMARY_TYPE = "application";
    private static final String SUB_TYPE = "pkcs7-mime";
    private static final String SMIME_TYPE_PARAM = "smime-type";
    private static final String SIGNED_SMIME_TYPE_VALUE = "signed-data";
    private static final String ENCRYPTED_SMIME_TYPE_VALUE = "enveloped-data";

    public Object getContent(DataSource dataSource) throws IOException {
        try {
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(dataSource.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            int n = bufferedInputStream.read(byArray, 0, 1024);
            while (n > -1) {
                bufferedOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray, 0, 1024);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        if (ADF1.equals(dataFlavor)) {
            return this.getContent(dataSource);
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return ADFs;
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (object instanceof MimeBodyPart) {
            try {
                ((MimeBodyPart)object).writeTo(outputStream);
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.getMessage());
            }
        } else if (object instanceof byte[]) {
            outputStream.write((byte[])object);
        } else if (object instanceof InputStream) {
            int n;
            InputStream inputStream = (InputStream)object;
            while ((n = inputStream.read()) >= 0) {
                outputStream.write(n);
            }
        } else {
            throw new IOException("unknown object in writeTo " + object);
        }
    }

    private boolean testMimeTypeIsEither(MimeType mimeType) {
        if (!PRIMARY_TYPE.equals(mimeType.getPrimaryType())) {
            return false;
        }
        return SUB_TYPE.equals(mimeType.getSubType());
    }

    private boolean testMimeTypeIsSigned(MimeType mimeType) {
        return this.testMimeTypeIsEither(mimeType);
    }

    private boolean testMimeTypeIsEncrypted(MimeType mimeType) {
        return this.testMimeTypeIsEither(mimeType);
    }
}

