/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    public KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, EncryptedContentInfo encryptedContentInfo) {
        super(AlgorithmIdentifier.getInstance((Object)keyTransRecipientInfo.getKeyEncryptionAlgorithm()), encryptedContentInfo);
        this.info = keyTransRecipientInfo;
        this.rid = new RecipientId();
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        try {
            if (recipientIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)recipientIdentifier.getId());
                this.rid.setSubjectKeyIdentifier(aSN1OctetString.getOctets());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)recipientIdentifier.getId());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)issuerAndSerialNumber.getName());
                this.rid.setIssuer(byteArrayOutputStream.toByteArray());
                this.rid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid rid in KeyTransRecipientInformation");
        }
    }

    public byte[] getContent(Key key, String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this.info.getEncryptedKey().getOctets();
            Cipher cipher = Cipher.getInstance(this.keyEncAlg.getObjectId().getId(), string);
            cipher.init(2, key);
            AlgorithmIdentifier algorithmIdentifier = this.data.getContentEncryptionAlgorithm();
            String string2 = algorithmIdentifier.getObjectId().getId();
            SecretKeySpec secretKeySpec = new SecretKeySpec(cipher.doFinal(byArray), string2);
            return this.getContentFromSessionKey(secretKeySpec, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CMSException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CMSException("bad padding in message.", badPaddingException);
        }
    }
}

