/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartInbound;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEUtil;

public class SMIMESigned
extends CMSSignedData {
    Object message;
    MimeBodyPart content;

    private static InputStream getInputStream(Part part) throws MessagingException {
        try {
            return part.getInputStream();
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    public SMIMESigned(MimeMultipart mimeMultipart) throws MessagingException, CMSException {
        super((CMSProcessable)new CMSProcessableBodyPartInbound(mimeMultipart.getBodyPart(0)), SMIMESigned.getInputStream((Part)mimeMultipart.getBodyPart(1)));
        this.message = mimeMultipart;
        this.content = (MimeBodyPart)mimeMultipart.getBodyPart(0);
    }

    public SMIMESigned(Part part) throws MessagingException, CMSException, SMIMEException {
        super(SMIMESigned.getInputStream(part));
        this.message = part;
        CMSProcessable cMSProcessable = this.getSignedContent();
        byte[] byArray = (byte[])cMSProcessable.getContent();
        this.content = SMIMEUtil.toMimeBodyPart(byArray);
    }

    public MimeBodyPart getContent() {
        return this.content;
    }

    public MimeMessage getContentAsMimeMessage(Session session) throws MessagingException, IOException {
        Object object;
        Object object2 = this.getSignedContent().getContent();
        byte[] byArray = null;
        if (object2 instanceof byte[]) {
            byArray = (byte[])object2;
        } else if (object2 instanceof MimePart) {
            object = (MimePart)object2;
            ByteArrayOutputStream byteArrayOutputStream = object.getSize() > 0 ? new ByteArrayOutputStream(object.getSize()) : new ByteArrayOutputStream();
            object.writeTo((OutputStream)byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            String string = "<null>";
            if (object2 != null) {
                string = object2.getClass().getName();
            }
            throw new MessagingException("Could not transfrom content of type " + string + " into MimeMessage.");
        }
        if (byArray != null) {
            object = new ByteArrayInputStream(byArray);
            return new MimeMessage(session, (InputStream)object);
        }
        return null;
    }

    public Object getContentWithSignature() {
        return this.message;
    }
}

