/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKCS12Test
implements Test {
    byte[] pkcs12 = Base64.decode((String)"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");

    public String getName() {
        return "PKCS12";
    }

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        PKCS12Test pKCS12Test = new PKCS12Test();
        TestResult testResult = pKCS12Test.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.pkcs12));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            Pfx pfx = new Pfx(aSN1Sequence);
            ContentInfo contentInfo = pfx.getAuthSafe();
            MacData macData = pfx.getMacData();
            DigestInfo digestInfo = macData.getMac();
            AlgorithmIdentifier algorithmIdentifier = digestInfo.getAlgorithmId();
            byte[] byArray = macData.getSalt();
            int n = macData.getIterationCount().intValue();
            aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((ASN1OctetString)contentInfo.getContent()).getOctets()));
            AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe((ASN1Sequence)aSN1InputStream.readObject());
            ContentInfo[] contentInfoArray = authenticatedSafe.getContentInfo();
            if (!contentInfoArray[0].getContentType().equals((Object)PKCSObjectIdentifiers.data)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed comparison data test");
            }
            aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((ASN1OctetString)contentInfoArray[0].getContent()).getOctets()));
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1InputStream.readObject();
            SafeBag safeBag = new SafeBag((ASN1Sequence)aSN1Sequence2.getObjectAt(0));
            if (!safeBag.getBagId().equals((Object)PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed comparison shroudedKeyBag test");
            }
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance((Object)((ASN1Sequence)safeBag.getBagValue()));
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKeyInfo.getEncryptionAlgorithm(), encryptedPrivateKeyInfo.getEncryptedData());
            safeBag = new SafeBag(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag, encryptedPrivateKeyInfo.toASN1Object(), safeBag.getBagAttributes());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)new DERSequence((DEREncodable)safeBag));
            contentInfoArray[0] = new ContentInfo(PKCSObjectIdentifiers.data, (DEREncodable)new BERConstructedOctetString(byteArrayOutputStream.toByteArray()));
            if (!contentInfoArray[1].getContentType().equals((Object)PKCSObjectIdentifiers.encryptedData)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed comparison encryptedData test");
            }
            EncryptedData encryptedData = EncryptedData.getInstance((Object)contentInfoArray[1].getContent());
            contentInfoArray[1] = new ContentInfo(PKCSObjectIdentifiers.encryptedData, (DEREncodable)encryptedData);
            authenticatedSafe = new AuthenticatedSafe(contentInfoArray);
            byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)authenticatedSafe);
            contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, (DEREncodable)new BERConstructedOctetString(byteArrayOutputStream.toByteArray()));
            macData = new MacData(new DigestInfo(algorithmIdentifier, digestInfo.getDigest()), byArray, n);
            pfx = new Pfx(contentInfo, macData);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream2 = new ASN1OutputStream((OutputStream)byteArrayOutputStream2);
            aSN1OutputStream2.writeObject((Object)pfx);
            if (!this.isSameAs(byteArrayOutputStream2.toByteArray(), this.pkcs12)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed comparison test");
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString(), exception);
        }
    }
}

