/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import org.bouncycastle.jce.cert.CertPathBuilder;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CertificateFactory;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.jce.cert.PKIXBuilderParameters;
import org.bouncycastle.jce.cert.PKIXCertPathBuilderResult;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CertPathBuilderTest
implements Test {
    public String getName() {
        return "CertPathBuilder";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertPathBuilderTest certPathBuilderTest = new CertPathBuilderTest();
        TestResult testResult = certPathBuilderTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance((String)"X.509", (String)"BC");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.rootCertBin));
            X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.interCertBin));
            X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.finalCertBin));
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL((InputStream)new ByteArrayInputStream(CertPathTest.rootCrlBin));
            X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL((InputStream)new ByteArrayInputStream(CertPathTest.interCrlBin));
            ArrayList<X509Extension> arrayList = new ArrayList<X509Extension>();
            arrayList.add(x509Certificate);
            arrayList.add(x509Certificate2);
            arrayList.add(x509Certificate3);
            arrayList.add(x509CRL);
            arrayList.add(x509CRL2);
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
            CertStore certStore = CertStore.getInstance((String)"Collection", (CertStoreParameters)collectionCertStoreParameters);
            Calendar calendar = Calendar.getInstance();
            calendar.set(2002, 2, 21, 2, 21, 10);
            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
            hashSet.add(new TrustAnchor(x509Certificate, null));
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance((String)"PKIX", (String)"BC");
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x509Certificate3.getSubjectDN().getName());
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(hashSet, (CertSelector)x509CertSelector);
            pKIXBuilderParameters.addCertStore(certStore);
            pKIXBuilderParameters.setDate(calendar.getTime());
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build((CertPathParameters)pKIXBuilderParameters);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

