/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.attr;

import org.bouncycastle.bcpg.UserAttributeSubpacket;

public class ImageAttribute
extends UserAttributeSubpacket {
    private int hdrLength;
    private int version;
    private int encoding;
    private byte[] imageData;

    public ImageAttribute(byte[] byArray) {
        super(1, byArray);
        this.hdrLength = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        this.version = byArray[2] & 0xFF;
        this.encoding = byArray[3] & 0xFF;
        this.imageData = new byte[byArray.length - this.hdrLength];
        System.arraycopy(byArray, this.hdrLength, this.imageData, 0, this.imageData.length);
    }

    public int getEncoding() {
        return this.encoding;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public int version() {
        return this.version;
    }
}

