/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERVisibleString;

public class DisplayText
extends ASN1Encodable {
    public static final int CONTENT_TYPE_IA5STRING = 0;
    public static final int CONTENT_TYPE_BMPSTRING = 1;
    public static final int CONTENT_TYPE_UTF8STRING = 2;
    public static final int CONTENT_TYPE_VISIBLESTRING = 3;
    public static final int DISPLAY_TEXT_MAXIMUM_SIZE = 200;
    int contentType;
    DERString contents;

    public DisplayText(int n, String string) {
        if (string.length() > 200) {
            string = string.substring(0, 200);
        }
        this.contentType = n;
        switch (n) {
            case 0: {
                this.contents = new DERIA5String(string);
                break;
            }
            case 2: {
                this.contents = new DERUTF8String(string);
                break;
            }
            case 3: {
                this.contents = new DERVisibleString(string);
                break;
            }
            case 1: {
                this.contents = new DERBMPString(string);
                break;
            }
            default: {
                this.contents = new DERUTF8String(string);
            }
        }
    }

    private boolean canBePrintable(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private boolean canBeUTF8(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public DisplayText(String string) {
        if (string.length() > 200) {
            string = string.substring(0, 200);
        }
        if (this.canBeUTF8(string)) {
            this.contentType = 2;
            this.contents = new DERUTF8String(string);
        } else {
            this.contentType = 1;
            this.contents = new DERBMPString(string);
        }
    }

    public DisplayText(DERString dERString) {
        this.contents = dERString;
    }

    public static DisplayText getInstance(Object object) {
        if (object instanceof DERString) {
            return new DisplayText((DERString)object);
        }
        if (object instanceof DisplayText) {
            return (DisplayText)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance");
    }

    public DERObject toASN1Object() {
        return (DERObject)((Object)this.contents);
    }

    public String getString() {
        return this.contents.getString();
    }
}

