/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class EqualsAndHashCodeTest
implements Test {
    public TestResult perform() {
        byte[] byArray = new byte[]{0, 1, 0, 1, 0, 0, 1};
        DERObject[] dERObjectArray = new DERObject[]{new BERConstructedOctetString(byArray), new BERSequence((DEREncodable)new DERPrintableString("hello world")), new BERSet((DEREncodable)new DERPrintableString("hello world")), new BERTaggedObject(0, (DEREncodable)new DERPrintableString("hello world")), new DERApplicationSpecific(64, byArray), new DERBitString(byArray), new DERBMPString("hello world"), new DERBoolean(true), new DERBoolean(false), new DEREnumerated(100), new DERGeneralizedTime(new Date()), new DERGeneralString("hello world"), new DERIA5String("hello"), new DERInteger(1000), new DERNull(), new DERNumericString("123456"), new DERObjectIdentifier("1.1.1.10000.1"), new DEROctetString(byArray), new DERPrintableString("hello world"), new DERSequence((DEREncodable)new DERPrintableString("hello world")), new DERSet((DEREncodable)new DERPrintableString("hello world")), new DERT61String("hello world"), new DERTaggedObject(0, (DEREncodable)new DERPrintableString("hello world")), new DERUniversalString(byArray), new DERUnknownTag(63, byArray), new DERUTCTime(new Date()), new DERUTF8String("hello world"), new DERVisibleString("hello world")};
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            int n = 0;
            while (n != dERObjectArray.length) {
                aSN1OutputStream.writeObject((Object)dERObjectArray[n]);
                ++n;
            }
            DERObject[] dERObjectArray2 = new DERObject[dERObjectArray.length];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            int n2 = 0;
            while (n2 != dERObjectArray.length) {
                DERObject dERObject = aSN1InputStream.readObject();
                if (!dERObject.equals((Object)dERObjectArray[n2])) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + dERObject);
                }
                if (dERObject.hashCode() != dERObjectArray[n2].hashCode()) {
                    return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + dERObject);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "EqualsAndHashCode";
    }

    public static void main(String[] stringArray) {
        EqualsAndHashCodeTest equalsAndHashCodeTest = new EqualsAndHashCodeTest();
        TestResult testResult = equalsAndHashCodeTest.perform();
        System.out.println(testResult);
    }
}

