/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.tsp.test.TSPTestUtil;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class TSPTest
implements Test {
    public String getName() {
        return "TSPTest";
    }

    public TestResult perform() {
        try {
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = TSPTestUtil.makeKeyPair();
            X509Certificate x509Certificate = TSPTestUtil.makeCACertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = TSPTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = TSPTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(x509Certificate2);
            arrayList.add(x509Certificate);
            CertStore certStore = CertStore.getInstance((String)"Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), (String)"BC");
            TestResult testResult = this.basicTest(keyPair2.getPrivate(), x509Certificate2, certStore);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.responseValidationTest(keyPair2.getPrivate(), x509Certificate2, certStore);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.incorrectHashTest(keyPair2.getPrivate(), x509Certificate2, certStore);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.badAlgorithmTest(keyPair2.getPrivate(), x509Certificate2, certStore);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.badPolicyTest(keyPair2.getPrivate(), x509Certificate2, certStore);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Exception - " + exception.toString(), exception);
        }
    }

    public TestResult basicTest(PrivateKey privateKey, X509Certificate x509Certificate, CertStore certStore) throws Exception {
        TimeStampTokenGenerator timeStampTokenGenerator = new TimeStampTokenGenerator(privateKey, x509Certificate, TSPAlgorithms.SHA1, "1.2");
        timeStampTokenGenerator.setCertificatesAndCRLs(certStore);
        TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
        TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator timeStampResponseGenerator = new TimeStampResponseGenerator(timeStampTokenGenerator, TSPAlgorithms.ALLOWED);
        TimeStampResponse timeStampResponse = timeStampResponseGenerator.generate(timeStampRequest, new BigInteger("23"), new Date(), "BC");
        timeStampResponse = new TimeStampResponse(timeStampResponse.getEncoded());
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        try {
            timeStampToken.validate(x509Certificate, "BC");
        }
        catch (TSPValidationException tSPValidationException) {
            return new SimpleTestResult(false, this.getName() + ": validation of token failed.");
        }
        AttributeTable attributeTable = timeStampToken.getSignedAttributes();
        if (attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate) == null) {
            return new SimpleTestResult(false, this.getName() + ": no signingCertificate attribute found.");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult responseValidationTest(PrivateKey privateKey, X509Certificate x509Certificate, CertStore certStore) throws Exception {
        TimeStampTokenGenerator timeStampTokenGenerator = new TimeStampTokenGenerator(privateKey, x509Certificate, TSPAlgorithms.MD5, "1.2");
        timeStampTokenGenerator.setCertificatesAndCRLs(certStore);
        TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
        TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator timeStampResponseGenerator = new TimeStampResponseGenerator(timeStampTokenGenerator, TSPAlgorithms.ALLOWED);
        TimeStampResponse timeStampResponse = timeStampResponseGenerator.generate(timeStampRequest, new BigInteger("23"), new Date(), "BC");
        timeStampResponse = new TimeStampResponse(timeStampResponse.getEncoded());
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        try {
            timeStampToken.validate(x509Certificate, "BC");
        }
        catch (TSPValidationException tSPValidationException) {
            return new SimpleTestResult(false, this.getName() + ": verification of token failed in response validation.");
        }
        try {
            timeStampResponse.validate(timeStampRequest);
        }
        catch (TSPValidationException tSPValidationException) {
            return new SimpleTestResult(false, this.getName() + ": response validation failed - " + tSPValidationException.getMessage());
        }
        try {
            timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(101L));
            timeStampResponse.validate(timeStampRequest);
            return new SimpleTestResult(false, this.getName() + ": response validation failed on invalid nonce.");
        }
        catch (TSPValidationException tSPValidationException) {
            try {
                timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.SHA1, new byte[22], BigInteger.valueOf(100L));
                timeStampResponse.validate(timeStampRequest);
                return new SimpleTestResult(false, this.getName() + ": response validation failed on wrong digest.");
            }
            catch (TSPValidationException tSPValidationException2) {
                try {
                    timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.MD5, new byte[20], BigInteger.valueOf(100L));
                    timeStampResponse.validate(timeStampRequest);
                    return new SimpleTestResult(false, this.getName() + ": response validation failed on wrong digest.");
                }
                catch (TSPValidationException tSPValidationException3) {
                    return new SimpleTestResult(true, this.getName() + ": Okay");
                }
            }
        }
    }

    public TestResult incorrectHashTest(PrivateKey privateKey, X509Certificate x509Certificate, CertStore certStore) throws Exception {
        TimeStampTokenGenerator timeStampTokenGenerator = new TimeStampTokenGenerator(privateKey, x509Certificate, TSPAlgorithms.SHA1, "1.2");
        timeStampTokenGenerator.setCertificatesAndCRLs(certStore);
        TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
        TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.SHA1, new byte[16]);
        TimeStampResponseGenerator timeStampResponseGenerator = new TimeStampResponseGenerator(timeStampTokenGenerator, TSPAlgorithms.ALLOWED);
        TimeStampResponse timeStampResponse = timeStampResponseGenerator.generate(timeStampRequest, new BigInteger("23"), new Date(), "BC");
        timeStampResponse = new TimeStampResponse(timeStampResponse.getEncoded());
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        if (timeStampToken != null) {
            return new SimpleTestResult(false, this.getName() + ": incorrectHash - token not null.");
        }
        PKIFailureInfo pKIFailureInfo = timeStampResponse.getFailInfo();
        if (pKIFailureInfo == null) {
            return new SimpleTestResult(false, this.getName() + ": incorrectHash - failInfo set to null.");
        }
        if (pKIFailureInfo.intValue() != 8) {
            return new SimpleTestResult(false, this.getName() + ": incorrectHash - wrong failure info returned.");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult badAlgorithmTest(PrivateKey privateKey, X509Certificate x509Certificate, CertStore certStore) throws Exception {
        TimeStampTokenGenerator timeStampTokenGenerator = new TimeStampTokenGenerator(privateKey, x509Certificate, TSPAlgorithms.SHA1, "1.2");
        timeStampTokenGenerator.setCertificatesAndCRLs(certStore);
        TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
        TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate("1.2.3.4.5", new byte[20]);
        TimeStampResponseGenerator timeStampResponseGenerator = new TimeStampResponseGenerator(timeStampTokenGenerator, TSPAlgorithms.ALLOWED);
        TimeStampResponse timeStampResponse = timeStampResponseGenerator.generate(timeStampRequest, new BigInteger("23"), new Date(), "BC");
        timeStampResponse = new TimeStampResponse(timeStampResponse.getEncoded());
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        if (timeStampToken != null) {
            return new SimpleTestResult(false, this.getName() + ": badAlgorithm - token not null.");
        }
        PKIFailureInfo pKIFailureInfo = timeStampResponse.getFailInfo();
        if (pKIFailureInfo == null) {
            return new SimpleTestResult(false, this.getName() + ": badAlgorithm - failInfo set to null.");
        }
        if (pKIFailureInfo.intValue() != 128) {
            return new SimpleTestResult(false, this.getName() + ": badAlgorithm - wrong failure info returned.");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult badPolicyTest(PrivateKey privateKey, X509Certificate x509Certificate, CertStore certStore) throws Exception {
        TimeStampTokenGenerator timeStampTokenGenerator = new TimeStampTokenGenerator(privateKey, x509Certificate, TSPAlgorithms.SHA1, "1.2");
        timeStampTokenGenerator.setCertificatesAndCRLs(certStore);
        TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
        timeStampRequestGenerator.setReqPolicy("4.4");
        TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.SHA1, new byte[20]);
        TimeStampResponseGenerator timeStampResponseGenerator = new TimeStampResponseGenerator(timeStampTokenGenerator, TSPAlgorithms.ALLOWED, new HashSet());
        TimeStampResponse timeStampResponse = timeStampResponseGenerator.generate(timeStampRequest, new BigInteger("23"), new Date(), "BC");
        timeStampResponse = new TimeStampResponse(timeStampResponse.getEncoded());
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        if (timeStampToken != null) {
            return new SimpleTestResult(false, this.getName() + ": badPolicy - token not null.");
        }
        PKIFailureInfo pKIFailureInfo = timeStampResponse.getFailInfo();
        if (pKIFailureInfo == null) {
            return new SimpleTestResult(false, this.getName() + ": badPolicy - failInfo set to null.");
        }
        if (pKIFailureInfo.intValue() != 256) {
            return new SimpleTestResult(false, this.getName() + ": badPolicy - wrong failure info returned.");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult certReqTest(PrivateKey privateKey, X509Certificate x509Certificate, CertStore certStore) throws Exception {
        TimeStampTokenGenerator timeStampTokenGenerator = new TimeStampTokenGenerator(privateKey, x509Certificate, TSPAlgorithms.SHA1, "1.2");
        timeStampTokenGenerator.setCertificatesAndCRLs(certStore);
        TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
        timeStampRequestGenerator.setCertReq(false);
        TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate("1.2.3.4.5", new byte[20]);
        TimeStampResponseGenerator timeStampResponseGenerator = new TimeStampResponseGenerator(timeStampTokenGenerator, TSPAlgorithms.ALLOWED);
        TimeStampResponse timeStampResponse = timeStampResponseGenerator.generate(timeStampRequest, new BigInteger("23"), new Date(), "BC");
        timeStampResponse = new TimeStampResponse(timeStampResponse.getEncoded());
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        try {
            timeStampToken.validate(x509Certificate, "BC");
        }
        catch (TSPValidationException tSPValidationException) {
            return new SimpleTestResult(false, this.getName() + ": certReq(false) verification of token failed.");
        }
        CertStore certStore2 = timeStampToken.getCertificatesAndCRLs("Collection", "BC");
        Collection collection = certStore2.getCertificates(null);
        if (!collection.isEmpty()) {
            return new SimpleTestResult(false, this.getName() + ": certReq(false) found certificates in response.");
        }
        timeStampRequestGenerator.setCertReq(true);
        timeStampRequest = timeStampRequestGenerator.generate("1.2.3.4.5", new byte[20]);
        timeStampResponseGenerator = new TimeStampResponseGenerator(timeStampTokenGenerator, TSPAlgorithms.ALLOWED);
        timeStampResponse = timeStampResponseGenerator.generate(timeStampRequest, new BigInteger("23"), new Date(), "BC");
        timeStampResponse = new TimeStampResponse(timeStampResponse.getEncoded());
        timeStampToken = timeStampResponse.getTimeStampToken();
        try {
            timeStampToken.validate(x509Certificate, "BC");
        }
        catch (TSPValidationException tSPValidationException) {
            return new SimpleTestResult(false, this.getName() + ": certReq(true) verification of token failed.");
        }
        if (collection.isEmpty()) {
            return new SimpleTestResult(false, this.getName() + ": certReq(false) no certificates found.");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        TSPTest tSPTest = new TSPTest();
        TestResult testResult = tSPTest.perform();
        System.out.println(testResult.toString());
    }
}

