/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class RSAPrivateKeyStructure
extends ASN1Encodable {
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger prime1;
    private BigInteger prime2;
    private BigInteger exponent1;
    private BigInteger exponent2;
    private BigInteger coefficient;

    public RSAPrivateKeyStructure(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.privateExponent = bigInteger3;
        this.prime1 = bigInteger4;
        this.prime2 = bigInteger5;
        this.exponent1 = bigInteger6;
        this.exponent2 = bigInteger7;
        this.coefficient = bigInteger8;
    }

    public RSAPrivateKeyStructure(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        BigInteger bigInteger = ((DERInteger)enumeration.nextElement()).getValue();
        if (bigInteger.intValue() != 0) {
            throw new IllegalArgumentException("wrong version for RSA private key");
        }
        this.modulus = ((DERInteger)enumeration.nextElement()).getValue();
        this.publicExponent = ((DERInteger)enumeration.nextElement()).getValue();
        this.privateExponent = ((DERInteger)enumeration.nextElement()).getValue();
        this.prime1 = ((DERInteger)enumeration.nextElement()).getValue();
        this.prime2 = ((DERInteger)enumeration.nextElement()).getValue();
        this.exponent1 = ((DERInteger)enumeration.nextElement()).getValue();
        this.exponent2 = ((DERInteger)enumeration.nextElement()).getValue();
        this.coefficient = ((DERInteger)enumeration.nextElement()).getValue();
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    public BigInteger getExponent1() {
        return this.exponent1;
    }

    public BigInteger getExponent2() {
        return this.exponent2;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrime1() {
        return this.prime1;
    }

    public BigInteger getPrime2() {
        return this.prime2;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(0));
        aSN1EncodableVector.add(new DERInteger(this.getModulus()));
        aSN1EncodableVector.add(new DERInteger(this.getPublicExponent()));
        aSN1EncodableVector.add(new DERInteger(this.getPrivateExponent()));
        aSN1EncodableVector.add(new DERInteger(this.getPrime1()));
        aSN1EncodableVector.add(new DERInteger(this.getPrime2()));
        aSN1EncodableVector.add(new DERInteger(this.getExponent1()));
        aSN1EncodableVector.add(new DERInteger(this.getExponent2()));
        aSN1EncodableVector.add(new DERInteger(this.getCoefficient()));
        return new DERSequence(aSN1EncodableVector);
    }
}

