/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp.test;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPReqGenerator;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.Req;
import org.bouncycastle.ocsp.RespData;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.ocsp.test.OCSPTestUtil;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class OCSPTest
implements Test {
    byte[] testResp1 = Base64.decode("MIIFnAoBAKCCBZUwggWRBgkrBgEFBQcwAQEEggWCMIIFfjCCARehgZ8wgZwxCzAJBgNVBAYTAklOMRcwFQYDVQQIEw5BbmRocmEgcHJhZGVzaDESMBAGA1UEBxMJSHlkZXJhYmFkMQwwCgYDVQQKEwNUQ1MxDDAKBgNVBAsTA0FUQzEeMBwGA1UEAxMVVENTLUNBIE9DU1AgUmVzcG9uZGVyMSQwIgYJKoZIhvcNAQkBFhVvY3NwQHRjcy1jYS50Y3MuY28uaW4YDzIwMDMwNDAyMTIzNDU4WjBiMGAwOjAJBgUrDgMCGgUABBRs07IuoCWNmcEl1oHwIak1BPnX8QQUtGyl/iL9WJ1VxjxFj0hAwJ/s1AcCAQKhERgPMjAwMjA4MjkwNzA5MjZaGA8yMDAzMDQwMjEyMzQ1OFowDQYJKoZIhvcNAQEFBQADgYEAfbN0TCRFKdhsmvOdUoiJ+qvygGBzDxD/VWhXYA+16AphHLIWNABR3CgHB3zWtdy2j7DJmQ/R7qKj7dUhWLSqclAiPgFtQQ1YvSJAYfEIdyHkxv4NP0LSogxrumANcDyC9yt/W9yHjD2ICPBIqCsZLuLkOHYi5DlwWe9Zm9VFwCGgggPMMIIDyDCCA8QwggKsoAMCAQICAQYwDQYJKoZIhvcNAQEFBQAwgZQxFDASBgNVBAMTC1RDUy1DQSBPQ1NQMSYwJAYJKoZIhvcNAQkBFhd0Y3MtY2FAdGNzLWNhLnRjcy5jby5pbjEMMAoGA1UEChMDVENTMQwwCgYDVQQLEwNBVEMxEjAQBgNVBAcTCUh5ZGVyYWJhZDEXMBUGA1UECBMOQW5kaHJhIHByYWRlc2gxCzAJBgNVBAYTAklOMB4XDTAyMDgyOTA3MTE0M1oXDTAzMDgyOTA3MTE0M1owgZwxCzAJBgNVBAYTAklOMRcwFQYDVQQIEw5BbmRocmEgcHJhZGVzaDESMBAGA1UEBxMJSHlkZXJhYmFkMQwwCgYDVQQKEwNUQ1MxDDAKBgNVBAsTA0FUQzEeMBwGA1UEAxMVVENTLUNBIE9DU1AgUmVzcG9uZGVyMSQwIgYJKoZIhvcNAQkBFhVvY3NwQHRjcy1jYS50Y3MuY28uaW4wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAM+XWW4caMRv46D7L6Bv8iwtKgmQu0SAybmFRJiz12qXzdvTLt8C75OdgmUomxp0+gW/4XlTPUqOMQWv463aZRv9Ust4f8MHEJh4ekP/NS9+d8vEO3P40ntQkmSMcFmtA9E1koUtQ3MSJlcs441JjbgUaVnmjDmmniQnZY4bU3tVAgMBAAGjgZowgZcwDAYDVR0TAQH/BAIwADALBgNVHQ8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwkwNgYIKwYBBQUHAQEEKjAoMCYGCCsGAQUFBzABhhpodHRwOi8vMTcyLjE5LjQwLjExMDo3NzAwLzAtBgNVHR8EJjAkMCKgIKAehhxodHRwOi8vMTcyLjE5LjQwLjExMC9jcmwuY3JsMA0GCSqGSIb3DQEBBQUAA4IBAQB6FovM3B4VDDZ15o12gnADZsIk9fTAczLlcrmXLNN4PgmqgnwF0Ymj3bD5SavDOXxbA65AZJ7rBNAguLUo+xVkgxmoBH7R2sBxjTCcr07NEadxM3HQkt0aX5XYEl8eRoifwqYAI9h0ziZfTNes8elNfb3DoPPjqq6VmMg0f0iMS4W8LjNPorjRB+kIosa1deAGPhq0eJ8yr0/s2QR2/WFD5P4aXc8IKWleklnIImS3zqiPrq6tl2Bm8DZj7vXlTOwmraSQxUwzCKwYob1yGvNOUQTqpG6jxn7jgDawHU1+WjWQe4Q34/pWeGLysxTraMa+Ug9kPe+jy/qRX2xwvKBZ====");
    byte[] testResp2 = Base64.decode("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==");

    public String getName() {
        return "OCSP";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        OCSPTest oCSPTest = new OCSPTest();
        TestResult testResult = oCSPTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        try {
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = OCSPTestUtil.makeKeyPair();
            X509Certificate x509Certificate = OCSPTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            GeneralName generalName = new GeneralName(new X509Name(string2));
            CertificateID certificateID = new CertificateID(CertificateID.HASH_SHA1, x509Certificate, BigInteger.valueOf(1L));
            OCSPReqGenerator oCSPReqGenerator = new OCSPReqGenerator();
            oCSPReqGenerator.addRequest(new CertificateID(CertificateID.HASH_SHA1, x509Certificate, BigInteger.valueOf(1L)));
            OCSPReq oCSPReq = oCSPReqGenerator.generate();
            if (oCSPReq.isSigned()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": signed but shouldn't be");
            }
            Req[] reqArray = oCSPReq.getRequestList();
            if (!reqArray[0].getCertID().equals(certificateID)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed isFor test");
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[1];
            oCSPReqGenerator = new OCSPReqGenerator();
            oCSPReqGenerator.addRequest(new CertificateID(CertificateID.HASH_SHA1, x509Certificate, BigInteger.valueOf(1L)));
            x509CertificateArray[0] = x509Certificate;
            oCSPReq = oCSPReqGenerator.generate("SHA1withRSA", keyPair.getPrivate(), x509CertificateArray, "BC");
            if (!oCSPReq.isSigned()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": not signed but should be");
            }
            if (!oCSPReq.verify(keyPair.getPublic(), "BC")) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": signature failed to verify");
            }
            reqArray = oCSPReq.getRequestList();
            if (!reqArray[0].getCertID().equals(certificateID)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed isFor test");
            }
            x509CertificateArray = new X509Certificate[1];
            oCSPReqGenerator = new OCSPReqGenerator();
            Hashtable<DERObjectIdentifier, X509Extension> hashtable = new Hashtable<DERObjectIdentifier, X509Extension>();
            hashtable.put(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, new X509Extension(false, (ASN1OctetString)new DEROctetString(new byte[16])));
            oCSPReqGenerator.addRequest(new CertificateID(CertificateID.HASH_SHA1, x509Certificate, BigInteger.valueOf(1L)), new X509Extensions(hashtable));
            x509CertificateArray[0] = x509Certificate;
            oCSPReq = oCSPReqGenerator.generate("SHA1withRSA", keyPair.getPrivate(), x509CertificateArray, "BC");
            if (!oCSPReq.isSigned()) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": not signed but should be");
            }
            if (!oCSPReq.verify(keyPair.getPublic(), "BC")) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": signature failed to verify");
            }
            reqArray = oCSPReq.getRequestList();
            if (!reqArray[0].getCertID().equals(certificateID)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed isFor test");
            }
            OCSPResp oCSPResp = new OCSPResp(new ByteArrayInputStream(this.testResp1));
            if (oCSPResp.getStatus() != 0) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": response status not zero.");
            }
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)oCSPResp.getResponseObject();
            if (!basicOCSPResp.verify((x509CertificateArray = basicOCSPResp.getCerts("BC"))[0].getPublicKey(), "BC")) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": response 1 failed to verify.");
            }
            RespData respData = basicOCSPResp.getResponseData();
            SingleResp[] singleRespArray = respData.getResponses();
            oCSPResp = new OCSPResp(new ByteArrayInputStream(this.testResp2));
            if (oCSPResp.getStatus() != 0) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": response status not zero.");
            }
            basicOCSPResp = (BasicOCSPResp)oCSPResp.getResponseObject();
            if (!basicOCSPResp.verify((x509CertificateArray = basicOCSPResp.getCerts("BC"))[0].getPublicKey(), "BC")) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": response 2 failed to verify.");
            }
            respData = basicOCSPResp.getResponseData();
            singleRespArray = respData.getResponses();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Exception " + exception);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

