/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AttCertIssuer;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.V2Form;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertSelector;

public class AttributeCertificateIssuer
implements CertSelector {
    ASN1Encodable form;

    AttributeCertificateIssuer(AttCertIssuer attCertIssuer) {
        this.form = attCertIssuer.getIssuer();
    }

    public AttributeCertificateIssuer(X509Principal x509Principal) {
        this.form = new V2Form(new GeneralNames(new DERSequence(new GeneralName(x509Principal))));
    }

    public Object clone() {
        return new AttributeCertificateIssuer(AttCertIssuer.getInstance(this.form));
    }

    private Object[] getNames() {
        GeneralNames generalNames = this.form instanceof V2Form ? ((V2Form)this.form).getIssuerName() : (GeneralNames)this.form;
        GeneralName[] generalNameArray = generalNames.getNames();
        ArrayList<X509Principal> arrayList = new ArrayList<X509Principal>(generalNameArray.length);
        int n = 0;
        while (n != generalNameArray.length) {
            if (generalNameArray[n].getName() instanceof X509Name) {
                try {
                    arrayList.add(new X509Principal(((X509Name)generalNameArray[n].getName()).getEncoded()));
                }
                catch (IOException iOException) {
                    throw new RuntimeException("badly formed Name object");
                }
            }
            ++n;
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public Principal[] getPrincipals() {
        Object[] objectArray = this.getNames();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n = 0;
        while (n != objectArray.length) {
            if (objectArray[n] instanceof Principal) {
                arrayList.add(objectArray);
            }
            ++n;
        }
        return arrayList.toArray(new Principal[arrayList.size()]);
    }

    public boolean match(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        try {
            if (this.form instanceof V2Form) {
                V2Form v2Form = (V2Form)this.form;
                if (v2Form.getBaseCertificateID() != null) {
                    return v2Form.getBaseCertificateID().getSerial().getValue().equals(x509Certificate.getSerialNumber()) && this.matchesDN(PrincipalUtil.getIssuerX509Principal(x509Certificate), v2Form.getBaseCertificateID().getIssuer());
                }
                GeneralNames generalNames = v2Form.getIssuerName();
                if (this.matchesDN(PrincipalUtil.getSubjectX509Principal(x509Certificate), generalNames)) {
                    return true;
                }
            } else {
                GeneralNames generalNames = (GeneralNames)this.form;
                if (this.matchesDN(PrincipalUtil.getSubjectX509Principal(x509Certificate), generalNames)) {
                    return true;
                }
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
        return false;
    }

    private boolean matchesDN(X509Principal x509Principal, GeneralNames generalNames) {
        GeneralName[] generalNameArray = generalNames.getNames();
        int n = 0;
        while (n != generalNameArray.length) {
            GeneralName generalName = generalNameArray[n];
            if (generalName.getTagNo() == 4) {
                try {
                    if (new X509Principal(((ASN1Encodable)generalName.getName()).getEncoded()).equals(x509Principal)) {
                        return true;
                    }
                }
                catch (IOException iOException) {}
            }
            ++n;
        }
        return false;
    }
}

