/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GenerationTest
implements Test {
    private byte[] v1Cert = Base64.decode((String)"MIGtAgEBMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMTAkFVMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAxMlowNjELMAkGA1UEAxMCQVUxFjAUBgNVBAoTDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsTBlRlc3QgMTAaMA0GCSqGSIb3DQEBAQUAAwkAMAYCAQECAQI=");
    private byte[] v3Cert = Base64.decode((String)"MIIBSKADAgECAgECMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMTAkFVMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAwMlowNjELMAkGA1UEAxMCQVUxFjAUBgNVBAoTDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsTBlRlc3QgMjAYMBAGBisOBwIBATAGAgEBAgECAwQAAgEDo4GVMIGSMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAyggECMCAGA1UdDgEB/wQWBBQ2T3aRz8you6PBCaJJEFNrqgh0UTALBgNVHQ8EBAMCBBA=");
    private byte[] v2CertList = Base64.decode((String)"MIIBRQIBATANBgkqhkiG9w0BAQUFADAlMQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZRcNNzAwMTAxMDAwMDAwWhcNNzAwMTAxMDAwMDAyWjAkMCICAQEXDTcwMDEwMTAwMDAwMVowDjAMBgNVHRUEBQoDAIAAoIHFMIHCMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAyggECMEMGA1UdEgQ8MDqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAzMAoGA1UdFAQDAgEBMAwGA1UdHAEB/wQCMAA=");

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private TestResult tbsV1CertGen() {
        try {
            V1TBSCertificateGenerator v1TBSCertificateGenerator = new V1TBSCertificateGenerator();
            Date date = new Date(1000L);
            Date date2 = new Date(12000L);
            v1TBSCertificateGenerator.setSerialNumber(new DERInteger(1));
            v1TBSCertificateGenerator.setStartDate(new Time(date));
            v1TBSCertificateGenerator.setEndDate(new Time(date2));
            v1TBSCertificateGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            v1TBSCertificateGenerator.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 1"));
            v1TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, (DEREncodable)new DERNull()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (DEREncodable)new DERNull()), (DEREncodable)new RSAPublicKeyStructure(BigInteger.valueOf(1L), BigInteger.valueOf(2L)));
            v1TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
            TBSCertificateStructure tBSCertificateStructure = v1TBSCertificateGenerator.generateTBSCertificate();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)tBSCertificateStructure);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v1Cert)) {
                return new SimpleTestResult(false, this.getName() + ": failed v1 cert generation");
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.v2CertList));
            DERObject dERObject = aSN1InputStream.readObject();
            byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dERObject);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v1 cert read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": v1 cert list failed " + exception.toString(), exception);
        }
    }

    private AuthorityKeyIdentifier createAuthorityKeyId(SubjectPublicKeyInfo subjectPublicKeyInfo, X509Name x509Name, int n) {
        GeneralName generalName = new GeneralName(x509Name);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)generalName);
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo, new GeneralNames((ASN1Sequence)new DERSequence((DEREncodableVector)aSN1EncodableVector)), BigInteger.valueOf(n));
    }

    private TestResult tbsV3CertGen() {
        try {
            V3TBSCertificateGenerator v3TBSCertificateGenerator = new V3TBSCertificateGenerator();
            Date date = new Date(1000L);
            Date date2 = new Date(2000L);
            v3TBSCertificateGenerator.setSerialNumber(new DERInteger(2));
            v3TBSCertificateGenerator.setStartDate(new Time(date));
            v3TBSCertificateGenerator.setEndDate(new Time(date2));
            v3TBSCertificateGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            v3TBSCertificateGenerator.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"));
            v3TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, (DEREncodable)new DERNull()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, (DEREncodable)new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), (DEREncodable)new DERInteger(3));
            v3TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
            Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
            Hashtable<DERObjectIdentifier, X509Extension> hashtable = new Hashtable<DERObjectIdentifier, X509Extension>();
            vector.add(X509Extensions.AuthorityKeyIdentifier);
            vector.add(X509Extensions.SubjectKeyIdentifier);
            vector.add(X509Extensions.KeyUsage);
            hashtable.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString((DEREncodable)this.createAuthorityKeyId(subjectPublicKeyInfo, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
            hashtable.put(X509Extensions.SubjectKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString((DEREncodable)new SubjectKeyIdentifier(subjectPublicKeyInfo))));
            hashtable.put(X509Extensions.KeyUsage, new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new KeyUsage(16))));
            X509Extensions x509Extensions = new X509Extensions(vector, hashtable);
            v3TBSCertificateGenerator.setExtensions(x509Extensions);
            TBSCertificateStructure tBSCertificateStructure = v3TBSCertificateGenerator.generateTBSCertificate();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)tBSCertificateStructure);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v3Cert)) {
                return new SimpleTestResult(false, this.getName() + ": failed v3 cert generation");
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.v2CertList));
            DERObject dERObject = aSN1InputStream.readObject();
            byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dERObject);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v3 cert read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": v3 cert list failed " + exception.toString(), exception);
        }
    }

    private TestResult tbsV2CertListGen() {
        try {
            V2TBSCertListGenerator v2TBSCertListGenerator = new V2TBSCertListGenerator();
            v2TBSCertListGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            v2TBSCertListGenerator.addCRLEntry(new DERInteger(1), new Time(new Date(1000L)), 32768);
            v2TBSCertListGenerator.setNextUpdate(new Time(new Date(2000L)));
            v2TBSCertListGenerator.setThisUpdate(new Time(new Date(500L)));
            v2TBSCertListGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (DEREncodable)new DERNull()));
            Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
            Hashtable<DERObjectIdentifier, X509Extension> hashtable = new Hashtable<DERObjectIdentifier, X509Extension>();
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, (DEREncodable)new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), (DEREncodable)new DERInteger(3));
            vector.add(X509Extensions.AuthorityKeyIdentifier);
            vector.add(X509Extensions.IssuerAlternativeName);
            vector.add(X509Extensions.CRLNumber);
            vector.add(X509Extensions.IssuingDistributionPoint);
            hashtable.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString((DEREncodable)this.createAuthorityKeyId(subjectPublicKeyInfo, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
            hashtable.put(X509Extensions.IssuerAlternativeName, new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new GeneralNames((ASN1Sequence)new DERSequence((DEREncodable)new GeneralName(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 3")))))));
            hashtable.put(X509Extensions.CRLNumber, new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new DERInteger(1))));
            hashtable.put(X509Extensions.IssuingDistributionPoint, new X509Extension(true, (ASN1OctetString)new DEROctetString((DEREncodable)new IssuingDistributionPoint((ASN1Sequence)new DERSequence()))));
            X509Extensions x509Extensions = new X509Extensions(vector, hashtable);
            v2TBSCertListGenerator.setExtensions(x509Extensions);
            TBSCertList tBSCertList = v2TBSCertListGenerator.generateTBSCertList();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)tBSCertList);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v2 cert list generation");
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.v2CertList));
            DERObject dERObject = aSN1InputStream.readObject();
            byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dERObject);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v2 cert list read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": v2 cert list failed " + exception.toString(), exception);
        }
    }

    public TestResult perform() {
        TestResult testResult = this.tbsV1CertGen();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.tbsV3CertGen();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return this.tbsV2CertListGen();
    }

    public String getName() {
        return "Generation";
    }

    public static void main(String[] stringArray) {
        GenerationTest generationTest = new GenerationTest();
        TestResult testResult = generationTest.perform();
        System.out.println(testResult);
    }
}

