/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class BlockCipherMonteCarloTest
implements Test {
    int id;
    int iterations;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherMonteCarloTest(int n, int n2, BlockCipher blockCipher, CipherParameters cipherParameters, String string, String string2) {
        this.id = n;
        this.iterations = n2;
        this.engine = blockCipher;
        this.param = cipherParameters;
        this.input = Hex.decode((String)string);
        this.output = Hex.decode((String)string2);
    }

    public String getName() {
        return this.engine.getAlgorithmName() + " Monte Carlo Test " + this.id;
    }

    public TestResult perform() {
        int n;
        int n2;
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(this.engine);
        bufferedBlockCipher.init(true, this.param);
        byte[] byArray = new byte[this.input.length];
        System.arraycopy(this.input, 0, byArray, 0, byArray.length);
        for (n2 = 0; n2 != this.iterations; ++n2) {
            n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray, 0);
            try {
                bufferedBlockCipher.doFinal(byArray, n);
                continue;
            }
            catch (CryptoException cryptoException) {
                return new SimpleTestResult(false, this.getName() + ": failed - exception " + cryptoException.toString());
            }
        }
        if (!this.isEqualArray(byArray, this.output)) {
            return new SimpleTestResult(false, this.getName() + ": failed - " + "expected " + new String(Hex.encode((byte[])this.output)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        bufferedBlockCipher.init(false, this.param);
        for (n2 = 0; n2 != this.iterations; ++n2) {
            n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray, 0);
            try {
                bufferedBlockCipher.doFinal(byArray, n);
                continue;
            }
            catch (CryptoException cryptoException) {
                return new SimpleTestResult(false, this.getName() + ": failed reversal - exception " + cryptoException.toString());
            }
        }
        if (!this.isEqualArray(this.input, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": failed reversal");
        }
        return new SimpleTestResult(true, this.getName() + ": OKAY");
    }

    private boolean isEqualArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

