/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientId;

public abstract class RecipientInformation {
    private static ASN1Null asn1Null = new DERNull();
    protected RecipientId rid = new RecipientId();
    protected AlgorithmIdentifier keyEncAlg;
    protected EncryptedContentInfo data;

    protected RecipientInformation(AlgorithmIdentifier algorithmIdentifier, EncryptedContentInfo encryptedContentInfo) {
        this.keyEncAlg = algorithmIdentifier;
        this.data = encryptedContentInfo;
    }

    public RecipientId getRID() {
        return this.rid;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dEREncodable);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public String getKeyEncryptionAlgOID() {
        return this.keyEncAlg.getObjectId().getId();
    }

    public byte[] getKeyEncryptionAlgParams() {
        try {
            return this.encodeObj(this.keyEncAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this.encodeObj(this.keyEncAlg.getParameters());
            if (byArray == null) {
                return null;
            }
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.getKeyEncryptionAlgOID(), string);
            algorithmParameters.init(byArray, "ASN.1");
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find parameters for algorithm", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't find parse parameters", iOException);
        }
    }

    protected byte[] getContentFromSessionKey(Key key, String string) throws CMSException, NoSuchProviderException {
        AlgorithmIdentifier algorithmIdentifier = this.data.getContentEncryptionAlgorithm();
        String string2 = algorithmIdentifier.getObjectId().getId();
        byte[] byArray = this.data.getEncryptedContent().getOctets();
        try {
            Cipher cipher = Cipher.getInstance(string2, string);
            DEREncodable dEREncodable = algorithmIdentifier.getParameters();
            if (dEREncodable != null && !asn1Null.equals((Object)dEREncodable)) {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string2, string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)algorithmIdentifier.getParameters());
                algorithmParameters.init(byteArrayOutputStream.toByteArray(), "ASN.1");
                cipher.init(2, key, algorithmParameters);
            } else if (string2.equals("1.2.840.113549.3.7") || string2.equals("1.3.6.1.4.1.188.7.1.1.2") || string2.equals("1.2.840.113533.7.66.10")) {
                cipher.init(2, key, new IvParameterSpec(new byte[8]));
            } else {
                cipher.init(2, key);
            }
            return cipher.doFinal(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CMSException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CMSException("bad padding in message.", badPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("error decoding algorithm parameters.", iOException);
        }
    }

    public abstract byte[] getContent(Key var1, String var2) throws CMSException, NoSuchProviderException;
}

