/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.util;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static String TAB = "    ";

    static String _dumpAsString(String string, DERObject dERObject) {
        if (dERObject instanceof ASN1Sequence) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Sequence)dERObject).getObjects();
            String string2 = String.valueOf(string) + TAB;
            stringBuffer.append(string);
            if (dERObject instanceof BERConstructedSequence) {
                stringBuffer.append("BER ConstructedSequence");
            } else if (dERObject instanceof DERConstructedSequence) {
                stringBuffer.append("DER ConstructedSequence");
            } else if (dERObject instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else if (dERObject instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(System.getProperty("line.separator"));
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || e.equals(new DERNull())) {
                    stringBuffer.append(string2);
                    stringBuffer.append("NULL");
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string2, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string2, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERTaggedObject) {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = String.valueOf(string) + TAB;
            stringBuffer.append(string);
            if (dERObject instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged [");
            } else {
                stringBuffer.append("Tagged [");
            }
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
            stringBuffer.append(Integer.toString(dERTaggedObject.getTagNo()));
            stringBuffer.append("]");
            if (!dERTaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT ");
            }
            stringBuffer.append(System.getProperty("line.separator"));
            if (dERTaggedObject.isEmpty()) {
                stringBuffer.append(string3);
                stringBuffer.append("EMPTY");
                stringBuffer.append(System.getProperty("line.separator"));
            } else {
                stringBuffer.append(ASN1Dump._dumpAsString(string3, dERTaggedObject.getObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERConstructedSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string4 = String.valueOf(string) + TAB;
            stringBuffer.append(string);
            stringBuffer.append("ConstructedSet");
            stringBuffer.append(System.getProperty("line.separator"));
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string4);
                    stringBuffer.append("NULL");
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string4, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string4, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof BERSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string5 = String.valueOf(string) + TAB;
            stringBuffer.append(string);
            stringBuffer.append("BER Set");
            stringBuffer.append(System.getProperty("line.separator"));
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string5);
                    stringBuffer.append("NULL");
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string5, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string5, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string6 = String.valueOf(string) + TAB;
            stringBuffer.append(string);
            stringBuffer.append("DER Set");
            stringBuffer.append(System.getProperty("line.separator"));
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string6);
                    stringBuffer.append("NULL");
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string6, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string6, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERObjectIdentifier) {
            return String.valueOf(string) + "ObjectIdentifier(" + ((DERObjectIdentifier)dERObject).getId() + ")" + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERBoolean) {
            return String.valueOf(string) + "Boolean(" + ((DERBoolean)dERObject).isTrue() + ")" + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERInteger) {
            return String.valueOf(string) + "Integer(" + ((DERInteger)dERObject).getValue() + ")" + System.getProperty("line.separator");
        }
        if (dERObject instanceof BERConstructedOctetString) {
            return String.valueOf(string) + "BER Constructed Octet String" + "[" + ((ASN1OctetString)dERObject).getOctets().length + "] " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DEROctetString) {
            return String.valueOf(string) + "DER Octet String" + "[" + ((ASN1OctetString)dERObject).getOctets().length + "] " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERBitString) {
            return String.valueOf(string) + "DER Bit String" + "[" + ((DERBitString)dERObject).getBytes().length + ", " + ((DERBitString)dERObject).getPadBits() + "] " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERIA5String) {
            return String.valueOf(string) + "IA5String(" + ((DERIA5String)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERUTF8String) {
            return String.valueOf(string) + "UTF8String(" + ((DERUTF8String)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERPrintableString) {
            return String.valueOf(string) + "PrintableString(" + ((DERPrintableString)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERVisibleString) {
            return String.valueOf(string) + "VisibleString(" + ((DERVisibleString)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERBMPString) {
            return String.valueOf(string) + "BMPString(" + ((DERBMPString)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERT61String) {
            return String.valueOf(string) + "T61String(" + ((DERT61String)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERUTCTime) {
            return String.valueOf(string) + "UTCTime(" + ((DERUTCTime)dERObject).getTime() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERGeneralizedTime) {
            return String.valueOf(string) + "GeneralizedTime(" + ((DERGeneralizedTime)dERObject).getTime() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERUnknownTag) {
            return String.valueOf(string) + "Unknown " + Integer.toString(((DERUnknownTag)dERObject).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)dERObject).getData())) + System.getProperty("line.separator");
        }
        return String.valueOf(string) + dERObject.toString() + System.getProperty("line.separator");
    }

    public static String dumpAsString(Object object) {
        if (object instanceof DERObject) {
            return ASN1Dump._dumpAsString("", (DERObject)object);
        }
        if (object instanceof DEREncodable) {
            return ASN1Dump._dumpAsString("", ((DEREncodable)object).getDERObject());
        }
        return "unknown object type " + object.toString();
    }
}

