/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.OCSPRequest;
import org.bouncycastle.asn1.ocsp.Request;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.Req;

public class OCSPReq {
    private OCSPRequest req;
    private X509Certificate[] chain = null;

    public OCSPReq(InputStream inputStream) throws IOException {
        this.req = OCSPRequest.getInstance(new ASN1InputStream(inputStream).readObject());
    }

    public OCSPReq(OCSPRequest oCSPRequest) {
        this.req = oCSPRequest;
    }

    public OCSPReq(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public X509Certificate[] getCerts(String string) throws OCSPException, NoSuchProviderException {
        if (!this.isSigned()) {
            return null;
        }
        if (this.chain == null) {
            CertificateFactory certificateFactory;
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            try {
                certificateFactory = CertificateFactory.getInstance("X.509", string);
            }
            catch (CertificateException certificateException) {
                throw new OCSPException("can't get certificate factory.", certificateException);
            }
            ASN1Sequence aSN1Sequence = this.req.getOptionalSignature().getCerts();
            if (aSN1Sequence != null) {
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    try {
                        aSN1OutputStream.writeObject(enumeration.nextElement());
                        arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
                    }
                    catch (IOException iOException) {
                        throw new OCSPException("can't re-encode certificate!", iOException);
                    }
                    catch (CertificateException certificateException) {
                        throw new OCSPException("can't re-encode certificate!", certificateException);
                    }
                    byteArrayOutputStream.reset();
                }
            }
            this.chain = arrayList.toArray(new X509Certificate[arrayList.size()]);
        }
        return this.chain;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this.req);
        return byteArrayOutputStream.toByteArray();
    }

    public X509Extensions getRequestExtensions() {
        return X509Extensions.getInstance(this.req.getTbsRequest().getRequestExtensions());
    }

    public Req[] getRequestList() {
        ASN1Sequence aSN1Sequence = this.req.getTbsRequest().getRequestList();
        Req[] reqArray = new Req[aSN1Sequence.size()];
        int n = 0;
        while (n != reqArray.length) {
            reqArray[n] = new Req(Request.getInstance(aSN1Sequence.getObjectAt(n)));
            ++n;
        }
        return reqArray;
    }

    public GeneralName getRequestorName() {
        return GeneralName.getInstance(this.req.getTbsRequest().getRequestorName());
    }

    public byte[] getSignature() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignature().getBytes();
    }

    public String getSignatureAlgOID() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignatureAlgorithm().getObjectId().getId();
    }

    public int getVersion() {
        return this.req.getTbsRequest().getVersion().getValue().intValue() + 1;
    }

    public boolean isSigned() {
        return this.req.getOptionalSignature() != null;
    }

    public boolean verify(PublicKey publicKey, String string) throws OCSPException, NoSuchProviderException {
        if (!this.isSigned()) {
            throw new OCSPException("attempt to verify signature on unsigned object");
        }
        try {
            Signature signature = Signature.getInstance(this.getSignatureAlgOID(), string);
            signature.initVerify(publicKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.req.getTbsRequest());
            signature.update(byteArrayOutputStream.toByteArray());
            return signature.verify(this.getSignature());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing sig: " + exception, exception);
        }
    }
}

