/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartOutbound;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.util.encoders.Base64;

public class SMIMESignedGenerator
extends SMIMEGenerator {
    public static final String DIGEST_SHA1 = "1.3.14.3.2.26";
    public static final String DIGEST_MD5 = "1.2.840.113549.2.5";
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String ENCRYPTION_RSA = "1.2.840.113549.1.1.1";
    public static final String ENCRYPTION_DSA = "1.2.840.10040.4.3";
    private CMSSignedDataGenerator fact = new CMSSignedDataGenerator();
    private String defaultContentTransferEncoding = "7bit";

    public SMIMESignedGenerator() {
    }

    public SMIMESignedGenerator(String string) {
        this.defaultContentTransferEncoding = string;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        this.fact.addSigner(privateKey, x509Certificate, string);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.fact.addSigner(privateKey, x509Certificate, string, attributeTable, attributeTable2);
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, SMIMEException {
        try {
            this.fact.addCertificatesAndCRLs(certStore);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage(), cMSException.getUnderlyingException());
        }
    }

    private void addHashHeader(StringBuffer stringBuffer, CMSSignedData cMSSignedData) {
        int n = 0;
        Iterator iterator = cMSSignedData.getSignerInfos().getSigners().iterator();
        while (iterator.hasNext()) {
            SignerInformation signerInformation = (SignerInformation)iterator.next();
            if (n == 0) {
                stringBuffer.append("; micalg=\"");
            } else {
                stringBuffer.append(",");
            }
            if (signerInformation.getDigestAlgOID().equals(DIGEST_SHA1)) {
                stringBuffer.append("sha1");
            } else if (signerInformation.getDigestAlgOID().equals(DIGEST_MD5)) {
                stringBuffer.append("md5");
            } else {
                stringBuffer.append("unknown");
            }
            ++n;
        }
        if (n != 0) {
            stringBuffer.append("\"");
        }
    }

    private MimeMultipart make(MimeBodyPart mimeBodyPart, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        CMSSignedData cMSSignedData;
        try {
            cMSSignedData = this.fact.generate(new CMSProcessableBodyPartOutbound((BodyPart)mimeBodyPart, this.defaultContentTransferEncoding), string);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage(), cMSException.getUnderlyingException());
        }
        StringBuffer stringBuffer = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
        this.addHashHeader(stringBuffer, cMSSignedData);
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.addHeader("Content-Type", "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data");
        internetHeaders.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
        internetHeaders.addHeader("Content-Description", "S/MIME Cryptographic Signature");
        try {
            MimeBodyPart mimeBodyPart2;
            if (this.useBase64) {
                internetHeaders.addHeader("Content-Transfer-Encoding", "base64");
                mimeBodyPart2 = new MimeBodyPart(internetHeaders, Base64.encode((byte[])cMSSignedData.getEncoded()));
            } else {
                internetHeaders.addHeader("Content-Transfer-Encoding", this.encoding);
                mimeBodyPart2 = new MimeBodyPart(internetHeaders, cMSSignedData.getEncoded());
            }
            MimeMultipart mimeMultipart = new MimeMultipart(stringBuffer.toString());
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            return mimeMultipart;
        }
        catch (IOException iOException) {
            throw new SMIMEException("exception encoding signature.", iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
    }

    private MimeBodyPart makeEncapsulated(MimeBodyPart mimeBodyPart, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        CMSSignedData cMSSignedData;
        try {
            cMSSignedData = this.fact.generate(new CMSProcessableBodyPart((BodyPart)mimeBodyPart), true, string);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage(), cMSException.getUnderlyingException());
        }
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.addHeader("Content-Type", "application/pkcs7-mime; name=smime.p7m; smime-type=signed-data");
        internetHeaders.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
        internetHeaders.addHeader("Content-Description", "S/MIME Cryptographic Signed Data");
        try {
            MimeBodyPart mimeBodyPart2;
            if (this.useBase64) {
                internetHeaders.addHeader("Content-Transfer-Encoding", "base64");
                mimeBodyPart2 = new MimeBodyPart(internetHeaders, Base64.encode((byte[])cMSSignedData.getEncoded()));
            } else {
                internetHeaders.addHeader("Content-Transfer-Encoding", this.encoding);
                mimeBodyPart2 = new MimeBodyPart(internetHeaders, cMSSignedData.getEncoded());
            }
            return mimeBodyPart2;
        }
        catch (IOException iOException) {
            throw new SMIMEException("exception encoding signature.", iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
    }

    public MimeMultipart generate(MimeBodyPart mimeBodyPart, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), string);
    }

    public MimeMultipart generate(MimeMessage mimeMessage, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), string);
    }

    public MimeBodyPart generateEncapsulated(MimeBodyPart mimeBodyPart, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(mimeBodyPart), string);
    }

    public MimeBodyPart generateEncapsulated(MimeMessage mimeMessage, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.makeEncapsulated(this.makeContentBodyPart(mimeMessage), string);
    }
}

