/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class OAEPTest
implements Test {
    static byte[] pubKeyEnc1 = new byte[]{48, 90, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, 73, 0, 48, 70, 2, 65, 0, -86, 54, -85, -50, -120, -84, -3, -1, 85, 82, 60, 127, -60, 82, 63, -112, -17, -96, 13, -13, 119, 74, 37, -97, 46, 98, -76, -59, -39, -100, -75, -83, -77, 0, -96, 40, 94, 83, 1, -109, 14, 12, 112, -5, 104, 118, -109, -100, -26, 22, -50, 98, 74, 17, -32, 8, 109, 52, 30, -68, -84, -96, -95, -11, 2, 1, 17};
    static byte[] privKeyEnc1 = new byte[]{48, -126, 1, 82, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 1, 60, 48, -126, 1, 56, 2, 1, 0, 2, 65, 0, -86, 54, -85, -50, -120, -84, -3, -1, 85, 82, 60, 127, -60, 82, 63, -112, -17, -96, 13, -13, 119, 74, 37, -97, 46, 98, -76, -59, -39, -100, -75, -83, -77, 0, -96, 40, 94, 83, 1, -109, 14, 12, 112, -5, 104, 118, -109, -100, -26, 22, -50, 98, 74, 17, -32, 8, 109, 52, 30, -68, -84, -96, -95, -11, 2, 1, 17, 2, 64, 10, 3, 55, 72, 98, 100, -121, 105, 95, 95, 48, -68, 56, -71, -117, 68, -62, -51, 45, -1, 67, 64, -104, -51, 32, -40, -95, 56, -48, -112, -65, 100, 121, 124, 63, -89, -94, -51, -53, 60, -47, -32, -67, -70, 38, 84, -76, -7, -33, -114, -118, -27, -99, 115, 61, -97, 51, -77, 1, 98, 74, -3, 29, 81, 2, 33, 0, -40, 64, -76, 22, 102, -76, 46, -110, -22, 13, -93, -76, 50, 4, -75, -49, -50, 51, 82, 82, 77, 4, 22, -91, -92, 65, -25, 0, -81, 70, 18, 13, 2, 33, 0, -55, 127, -79, -16, 39, -12, 83, -10, 52, 18, 51, -22, -86, -47, -39, 53, 63, 108, 66, -48, -120, 102, -79, -48, 90, 15, 32, 53, 2, -117, -99, -119, 2, 32, 89, 11, -107, 114, -94, -62, -87, -60, 6, 5, -99, -62, -85, 47, 29, -81, -21, 126, -117, 79, 16, -89, 84, -98, -114, -19, -11, -76, -4, -32, -98, 5, 2, 33, 0, -114, 60, 5, 33, -2, 21, -32, -22, 6, -93, 111, -16, -15, 12, -103, 82, -61, 91, 122, 117, 20, -3, 50, 56, -72, 10, -83, 82, -104, 98, -115, 81, 2, 32, 54, 63, -9, 24, -99, -88, -23, 11, 29, 52, 31, 113, -48, -101, 118, -88, -87, 67, -31, 29, 16, -78, 77, 36, -97, 45, -22, -2, -8, 12, 24, 38};
    static byte[] output1 = new byte[]{27, -113, 5, -7, -54, 26, 121, 82, 110, 83, -13, -52, 81, 79, -37, -119, 43, -5, -111, -109, 35, 30, 120, -71, -110, -26, -115, 80, -92, -128, -53, 82, 51, -119, 92, 116, -107, -115, 93, 2, -85, -116, 15, -48, 64, -21, 88, 68, -80, 5, -61, -98, -40, 39, 74, -99, -65, -88, 6, 113, 64, -108, 57, -46};
    static byte[] pubKeyEnc2 = new byte[]{48, 76, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, 59, 0, 48, 56, 2, 51, 0, -93, 7, -102, -112, -33, 13, -3, 114, -84, 9, 12, -52, 42, 120, -72, 116, 19, 19, 62, 64, 117, -100, -104, -6, -8, 32, 79, 53, -118, 11, 38, 60, 103, 112, -25, -125, -87, 59, 105, 113, -73, 55, 121, -46, 113, 123, -24, 52, 119, -49, 2, 1, 3};
    static byte[] privKeyEnc2 = new byte[]{48, -126, 1, 19, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -127, -2, 48, -127, -5, 2, 1, 0, 2, 51, 0, -93, 7, -102, -112, -33, 13, -3, 114, -84, 9, 12, -52, 42, 120, -72, 116, 19, 19, 62, 64, 117, -100, -104, -6, -8, 32, 79, 53, -118, 11, 38, 60, 103, 112, -25, -125, -87, 59, 105, 113, -73, 55, 121, -46, 113, 123, -24, 52, 119, -49, 2, 1, 3, 2, 50, 108, -81, -68, 96, -108, -77, -2, 76, 114, -80, -77, 50, -58, -5, 37, -94, -73, 98, 41, -128, 78, 104, 101, -4, -92, 90, 116, -33, 15, -113, -72, 65, 59, 82, -64, -48, -27, 61, -101, 89, 15, -15, -101, -25, -97, 73, -35, 33, -27, -21, 2, 26, 0, -49, 32, 53, 2, -117, -99, -122, -104, 64, -76, 22, 102, -76, 46, -110, -22, 13, -93, -76, 50, 4, -75, -49, -50, -111, 2, 26, 0, -55, 127, -79, -16, 39, -12, 83, -10, 52, 18, 51, -22, -86, -47, -39, 53, 63, 108, 66, -48, -120, 102, -79, -48, 95, 2, 26, 0, -118, 21, 120, -84, 93, 19, -81, 16, 43, 34, -71, -103, -51, 116, 97, -15, 94, 109, 34, -52, 3, 35, -33, -33, 11, 2, 26, 0, -122, 85, 33, 74, -59, 77, -115, 78, -51, 97, 119, -15, -57, 54, -112, -50, 42, 72, 44, -117, 5, -103, -53, -32, 63, 2, 26, 0, -125, -17, -17, -72, -87, -92, 13, 29, -74, -19, -104, -83, -124, -19, 19, 53, -36, -63, 8, -13, 34, -48, 87, -49, -115};
    static byte[] output2 = new byte[]{20, -67, -35, 40, -55, -125, 53, 25, 35, -128, -24, -27, 73, -79, 88, 42, -117, 64, -76, 72, 109, 3, -90, -91, 49, 31, 31, -43, -16, -95, -128, -28, 23, 83, 3, 41, -87, 52, -112, 116, -79, 82, 19, 84, 41, 8, 36, 82, 98, 81};
    static byte[] pubKeyEnc3 = new byte[]{48, -127, -99, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -117, 0, 48, -127, -121, 2, -127, -127, 0, -69, -8, 47, 9, 6, -126, -50, -100, 35, 56, -84, 43, -99, -88, 113, -9, 54, -115, 7, -18, -44, 16, 67, -92, 64, -42, -74, -16, 116, 84, -11, 31, -72, -33, -70, -81, 3, 92, 2, -85, 97, -22, 72, -50, -21, 111, -51, 72, 118, -19, 82, 13, 96, -31, -20, 70, 25, 113, -99, -118, 91, -117, -128, 127, -81, -72, -32, -93, -33, -57, 55, 114, 62, -26, -76, -73, -39, 58, 37, -124, -18, 106, 100, -99, 6, 9, 83, 116, -120, 52, -78, 69, 69, -104, 57, 78, -32, -86, -79, 45, 123, 97, -91, 31, 82, 122, -102, 65, -10, -63, 104, 127, -30, 83, 114, -104, -54, 42, -113, 89, 70, -8, -27, -3, 9, 29, -67, -53, 2, 1, 17};
    static byte[] privKeyEnc3 = new byte[]{48, -126, 2, 117, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 2, 95, 48, -126, 2, 91, 2, 1, 0, 2, -127, -127, 0, -69, -8, 47, 9, 6, -126, -50, -100, 35, 56, -84, 43, -99, -88, 113, -9, 54, -115, 7, -18, -44, 16, 67, -92, 64, -42, -74, -16, 116, 84, -11, 31, -72, -33, -70, -81, 3, 92, 2, -85, 97, -22, 72, -50, -21, 111, -51, 72, 118, -19, 82, 13, 96, -31, -20, 70, 25, 113, -99, -118, 91, -117, -128, 127, -81, -72, -32, -93, -33, -57, 55, 114, 62, -26, -76, -73, -39, 58, 37, -124, -18, 106, 100, -99, 6, 9, 83, 116, -120, 52, -78, 69, 69, -104, 57, 78, -32, -86, -79, 45, 123, 97, -91, 31, 82, 122, -102, 65, -10, -63, 104, 127, -30, 83, 114, -104, -54, 42, -113, 89, 70, -8, -27, -3, 9, 29, -67, -53, 2, 1, 17, 2, -127, -127, 0, -91, -38, -4, 83, 65, -6, -14, -119, -60, -71, -120, -37, 48, -63, -51, -8, 63, 49, 37, 30, 6, 104, -76, 39, -124, -127, 56, 1, 87, -106, 65, -78, -108, 16, -77, -57, -103, -115, 107, -60, 101, 116, 94, 92, 57, 38, 105, -42, -121, 13, -94, -64, -126, -87, 57, -29, 127, -36, -72, 46, -55, 62, -38, -55, 127, -13, -83, 89, 80, -84, -49, -68, 17, 28, 118, -15, -87, 82, -108, 68, -27, 106, -81, 104, -59, 108, 9, 44, -45, -115, -61, -66, -11, -46, 10, -109, -103, 38, -19, 79, 116, -95, 62, -35, -5, -31, -95, -50, -52, 72, -108, -81, -108, 40, -62, -73, -72, -120, 63, -28, 70, 58, 75, -56, 91, 28, -77, -63, 2, 65, 0, -18, -49, -82, -127, -79, -71, -77, -55, 8, -127, 11, 16, -95, -75, 96, 1, -103, -21, -97, 68, -82, -12, -3, -92, -109, -72, 26, -98, 61, -124, -10, 50, 18, 78, -16, 35, 110, 93, 30, 59, 126, 40, -6, -25, -86, 4, 10, 45, 91, 37, 33, 118, 69, -99, 31, 57, 117, 65, -70, 42, 88, -5, 101, -103, 2, 65, 0, -55, 127, -79, -16, 39, -12, 83, -10, 52, 18, 51, -22, -86, -47, -39, 53, 63, 108, 66, -48, -120, 102, -79, -48, 90, 15, 32, 53, 2, -117, -99, -122, -104, 64, -76, 22, 102, -76, 46, -110, -22, 13, -93, -76, 50, 4, -75, -49, -50, 51, 82, 82, 77, 4, 22, -91, -92, 65, -25, 0, -81, 70, 21, 3, 2, 64, 84, 73, 76, -90, 62, -70, 3, 55, -28, -30, 64, 35, -4, -42, -102, 90, -21, 7, -35, -36, 1, -125, -92, -48, -84, -101, 84, -80, 81, -14, -79, 62, -39, 73, 9, 117, -22, -73, 116, 20, -1, 89, -63, -9, 105, 46, -102, 46, 32, 43, 56, -4, -111, 10, 71, 65, 116, -83, -55, 60, 31, 103, -55, -127, 2, 64, 71, 30, 2, -112, -1, 10, -16, 117, 3, 81, -73, -8, 120, -122, 76, -87, 97, -83, -67, 58, -118, 126, -103, 28, 92, 5, 86, -87, 76, 49, 70, -89, -7, -128, 63, -113, 111, -118, -29, 66, -23, 49, -3, -118, -28, 122, 34, 13, 27, -103, -92, -107, -124, -104, 7, -2, 57, -7, 36, 90, -104, 54, -38, 61, 2, 65, 0, -80, 108, 79, -38, -69, 99, 1, 25, -115, 38, 91, -37, -82, -108, 35, -77, -128, -14, 113, -9, 52, 83, -120, 80, -109, 7, 127, -51, 57, -30, 17, -97, -55, -122, 50, 21, 79, 88, -125, -79, 103, -87, 103, -65, 64, 43, 78, -98, 46, 15, -106, 86, -26, -104, -22, 54, 102, -19, -5, 37, 121, -128, 57, -9};
    static byte[] output3 = Hex.decode((String)"b8246b56a6ed5881aeb585d9a25b2ad790c417e080681bf1ac2bc3deb69d8bcef0c4366fec400af052a72e9b0effb5b3f2f192dbeaca03c12740057113bf1f0669ac22e9f3a7852e3c15d913cab0b8863a95c99294ce8674214954610346f4d474b26f7c48b42ee68e1f572a1fc4026ac456b4f59f7b621ea1b9d88f64202fb1");

    public String getName() {
        return "OAEP";
    }

    public TestResult perform() {
        OAEPTester oAEPTester = new OAEPTester(1, pubKeyEnc1, privKeyEnc1, output1);
        TestResult testResult = oAEPTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        oAEPTester = new OAEPTester(2, pubKeyEnc2, privKeyEnc2, output2);
        testResult = oAEPTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        oAEPTester = new OAEPTester(3, pubKeyEnc3, privKeyEnc3, output3);
        testResult = oAEPTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, "OAEP: Okay");
    }

    public static void main(String[] stringArray) {
        OAEPTest oAEPTest = new OAEPTest();
        TestResult testResult = oAEPTest.perform();
        System.out.println(testResult);
    }

    private class OAEPTester
    implements Test {
        private int id;
        private byte[] pubKeyEnc;
        private byte[] privKeyEnc;
        private byte[] output;

        OAEPTester(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            this.id = n;
            this.pubKeyEnc = byArray;
            this.privKeyEnc = byArray2;
            this.output = byArray3;
        }

        public String getName() {
            return "OAEPTest " + this.id;
        }

        public TestResult perform() {
            int n;
            byte[] byArray;
            RSAPrivateKeyStructure rSAPrivateKeyStructure;
            RSAPublicKeyStructure rSAPublicKeyStructure;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pubKeyEnc);
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            try {
                rSAPublicKeyStructure = new RSAPublicKeyStructure((ASN1Sequence)new SubjectPublicKeyInfo((ASN1Sequence)aSN1InputStream.readObject()).getPublicKey());
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            byteArrayInputStream = new ByteArrayInputStream(this.privKeyEnc);
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            try {
                rSAPrivateKeyStructure = new RSAPrivateKeyStructure((ASN1Sequence)new PrivateKeyInfo((ASN1Sequence)aSN1InputStream.readObject()).getPrivateKey());
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, rSAPublicKeyStructure.getModulus(), rSAPublicKeyStructure.getPublicExponent());
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(rSAPrivateKeyStructure.getModulus(), rSAPrivateKeyStructure.getPublicExponent(), rSAPrivateKeyStructure.getPrivateExponent(), rSAPrivateKeyStructure.getPrime1(), rSAPrivateKeyStructure.getPrime2(), rSAPrivateKeyStructure.getExponent1(), rSAPrivateKeyStructure.getExponent2(), rSAPrivateKeyStructure.getCoefficient());
            OAEPEncoding oAEPEncoding = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine());
            oAEPEncoding.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)rSAKeyParameters, (SecureRandom)new Rand()));
            byte[] byArray2 = new byte[]{84, -123, -101, 52, 44, 73, -22, 42};
            try {
                byArray = oAEPEncoding.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            for (n = 0; n != this.output.length; ++n) {
                if (byArray[n] == this.output[n]) continue;
                return new SimpleTestResult(false, this.getName() + ": failed encryption");
            }
            oAEPEncoding.init(false, (CipherParameters)rSAPrivateCrtKeyParameters);
            try {
                byArray = oAEPEncoding.processBlock(this.output, 0, this.output.length);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            for (n = 0; n != byArray2.length; ++n) {
                if (byArray[n] == byArray2[n]) continue;
                return new SimpleTestResult(false, this.getName() + ": failed decoding");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }

    private class Rand
    extends SecureRandom {
        byte[] seed = new byte[]{-86, -3, 18, -10, 89, -54, -26, 52, -119, -76, 121, -27, 7, 109, -34, -62, -16, 108, -75, -113};

        private Rand() {
        }

        public void nextBytes(byte[] byArray) {
            System.arraycopy(this.seed, 0, byArray, 0, byArray.length);
        }
    }
}

