/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;

public class KeyBasedFileProcessor {
    private static PGPPublicKey readPublicKey(InputStream inputStream) throws IOException, PGPException {
        inputStream = PGPUtil.getDecoderStream(inputStream);
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(inputStream);
        PGPPublicKey pGPPublicKey = null;
        Iterator iterator = pGPPublicKeyRingCollection.getKeyRings();
        while (pGPPublicKey == null && iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            Iterator iterator2 = pGPPublicKeyRing.getPublicKeys();
            boolean bl = false;
            while (pGPPublicKey == null && iterator2.hasNext()) {
                PGPPublicKey pGPPublicKey2 = (PGPPublicKey)iterator2.next();
                if (!pGPPublicKey2.isEncryptionKey()) continue;
                pGPPublicKey = pGPPublicKey2;
            }
        }
        if (pGPPublicKey == null) {
            throw new IllegalArgumentException("Can't find encryption key in key ring.");
        }
        return pGPPublicKey;
    }

    private static PGPPrivateKey findSecretKey(InputStream inputStream, long l, char[] cArray) throws IOException, PGPException, NoSuchProviderException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(inputStream));
        PGPSecretKey pGPSecretKey = pGPSecretKeyRingCollection.getSecretKey(l);
        if (pGPSecretKey == null) {
            return null;
        }
        return pGPSecretKey.extractPrivateKey(cArray, "BC");
    }

    private static void decryptFile(InputStream inputStream, InputStream inputStream2, char[] cArray) throws Exception {
        block13: {
            inputStream = PGPUtil.getDecoderStream(inputStream);
            try {
                Object object;
                Object object2;
                PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
                Object object3 = pGPObjectFactory.nextObject();
                PGPEncryptedDataList pGPEncryptedDataList = object3 instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object3 : (PGPEncryptedDataList)pGPObjectFactory.nextObject();
                Iterator iterator = pGPEncryptedDataList.getEncyptedDataObjects();
                PGPPrivateKey pGPPrivateKey = null;
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = null;
                while (pGPPrivateKey == null && iterator.hasNext()) {
                    pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)iterator.next();
                    pGPPrivateKey = KeyBasedFileProcessor.findSecretKey(inputStream2, pGPPublicKeyEncryptedData.getKeyID(), cArray);
                }
                if (pGPPrivateKey == null) {
                    throw new IllegalArgumentException("secret key for message not found.");
                }
                InputStream inputStream3 = pGPPublicKeyEncryptedData.getDataStream(pGPPrivateKey, "BC");
                PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(inputStream3);
                Object object4 = pGPObjectFactory2.nextObject();
                if (object4 instanceof PGPCompressedData) {
                    object2 = (PGPCompressedData)object4;
                    object = new PGPObjectFactory(((PGPCompressedData)object2).getDataStream());
                    object4 = ((PGPObjectFactory)object).nextObject();
                }
                if (object4 instanceof PGPLiteralData) {
                    int n;
                    object2 = (PGPLiteralData)object4;
                    object = new FileOutputStream(((PGPLiteralData)object2).getFileName());
                    InputStream inputStream4 = ((PGPLiteralData)object2).getInputStream();
                    while ((n = inputStream4.read()) >= 0) {
                        ((FileOutputStream)object).write(n);
                    }
                } else {
                    if (object4 instanceof PGPOnePassSignatureList) {
                        throw new PGPException("encrypted message contains a signed message - not literal data.");
                    }
                    throw new PGPException("message is not a simple encrypted file - type unknown.");
                }
                if (pGPPublicKeyEncryptedData.isIntegrityProtected()) {
                    if (!pGPPublicKeyEncryptedData.verify()) {
                        System.err.println("message failed integrity check");
                    } else {
                        System.err.println("message integrity check passed");
                    }
                } else {
                    System.err.println("no message integrity check");
                }
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block13;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    private static void encryptFile(OutputStream outputStream, String string, PGPPublicKey pGPPublicKey, boolean bl, boolean bl2) throws IOException, NoSuchProviderException {
        block3: {
            if (bl) {
                outputStream = new ArmoredOutputStream(outputStream);
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
                PGPUtil.writeFileToLiteralData(pGPCompressedDataGenerator.open(byteArrayOutputStream), 'b', new File(string));
                pGPCompressedDataGenerator.close();
                PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(3, bl2, new SecureRandom(), "BC");
                pGPEncryptedDataGenerator.addMethod(pGPPublicKey);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, byArray.length);
                outputStream2.write(byArray);
                pGPEncryptedDataGenerator.close();
                outputStream.close();
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block3;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray.length == 0) {
            System.err.println("usage: KeyBasedFileProcessor -e|-d [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
            return;
        }
        if (stringArray[0].equals("-e")) {
            if (stringArray[1].equals("-a") || stringArray[1].equals("-ai") || stringArray[1].equals("-ia")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2] + ".asc");
                KeyBasedFileProcessor.encryptFile(fileOutputStream, stringArray[2], KeyBasedFileProcessor.readPublicKey(fileInputStream), true, stringArray[1].indexOf(105) > 0);
            } else if (stringArray[1].equals("-i")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2] + ".bpg");
                KeyBasedFileProcessor.encryptFile(fileOutputStream, stringArray[2], KeyBasedFileProcessor.readPublicKey(fileInputStream), false, true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".bpg");
                KeyBasedFileProcessor.encryptFile(fileOutputStream, stringArray[1], KeyBasedFileProcessor.readPublicKey(fileInputStream), false, false);
            }
        } else if (stringArray[0].equals("-d")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            FileInputStream fileInputStream2 = new FileInputStream(stringArray[2]);
            KeyBasedFileProcessor.decryptFile(fileInputStream, fileInputStream2, stringArray[3].toCharArray());
        } else {
            System.err.println("usage: KeyBasedFileProcessor -d|-e [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
        }
    }
}

