/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;

public abstract class ASN1Set
extends DERObject {
    protected Vector set = new Vector();

    protected void addObject(DEREncodable dEREncodable) {
        this.set.addElement(dEREncodable);
    }

    abstract void encode(DEROutputStream var1) throws IOException;

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ASN1Set)) {
            return false;
        }
        ASN1Set aSN1Set = (ASN1Set)object;
        if (this.size() != aSN1Set.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().equals(enumeration2.nextElement())) continue;
            return false;
        }
        return true;
    }

    private byte[] getEncoded(DEREncodable dEREncodable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(dEREncodable);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static ASN1Set getInstance(Object object) {
        if (object == null || object instanceof ASN1Set) {
            return (ASN1Set)object;
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static ASN1Set getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            if (!aSN1TaggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)aSN1TaggedObject.getObject();
        }
        if (aSN1TaggedObject.isExplicit()) {
            DERSet dERSet = new DERSet(aSN1TaggedObject.getObject());
            return dERSet;
        }
        if (aSN1TaggedObject.getObject() instanceof ASN1Set) {
            return (ASN1Set)aSN1TaggedObject.getObject();
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (aSN1TaggedObject.getObject() instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1TaggedObject.getObject();
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((DEREncodable)enumeration.nextElement());
            }
            return new DERSet(aSN1EncodableVector);
        }
        throw new IllegalArgumentException("unknown object in getInstanceFromTagged");
    }

    public DEREncodable getObjectAt(int n) {
        return (DEREncodable)this.set.elementAt(n);
    }

    public Enumeration getObjects() {
        return this.set.elements();
    }

    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            n ^= enumeration.nextElement().hashCode();
        }
        return n;
    }

    private boolean lessThanOrEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length <= byArray2.length) {
            int n = 0;
            while (n != byArray.length) {
                int n2 = byArray2[n] & 0xFF;
                int n3 = byArray[n] & 0xFF;
                if (n2 > n3) {
                    return true;
                }
                if (n3 > n2) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        int n = 0;
        while (n != byArray2.length) {
            int n4 = byArray2[n] & 0xFF;
            int n5 = byArray[n] & 0xFF;
            if (n4 > n5) {
                return true;
            }
            if (n5 > n4) {
                return false;
            }
            ++n;
        }
        return false;
    }

    public int size() {
        return this.set.size();
    }

    protected void sort() {
        if (this.set.size() > 1) {
            boolean bl = true;
            while (bl) {
                int n = 0;
                byte[] byArray = this.getEncoded((DEREncodable)this.set.elementAt(0));
                bl = false;
                while (n != this.set.size() - 1) {
                    byte[] byArray2 = this.getEncoded((DEREncodable)this.set.elementAt(n + 1));
                    if (this.lessThanOrEqual(byArray, byArray2)) {
                        byArray = byArray2;
                    } else {
                        Object e = this.set.elementAt(n);
                        this.set.setElementAt(this.set.elementAt(n + 1), n);
                        this.set.setElementAt(e, n + 1);
                        bl = true;
                    }
                    ++n;
                }
            }
        }
    }
}

