/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SMIMETest
implements Test {
    byte[] attrBytes = Base64.decode((String)"MDQGCSqGSIb3DQEJDzEnMCUwCgYIKoZIhvcNAwcwDgYIKoZIhvcNAwICAgCAMAcGBSsOAwIH");
    byte[] prefBytes = Base64.decode((String)"MCwGCyqGSIb3DQEJEAILMR2hGwQIAAAAAAAAAAAYDzE5NzAwMTAxMDAwMDAxWg==");

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult perform() {
        SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
        sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
        SMIMECapabilitiesAttribute sMIMECapabilitiesAttribute = new SMIMECapabilitiesAttribute(sMIMECapabilityVector);
        SMIMEEncryptionKeyPreferenceAttribute sMIMEEncryptionKeyPreferenceAttribute = new SMIMEEncryptionKeyPreferenceAttribute(new RecipientKeyIdentifier((ASN1OctetString)new DEROctetString(new byte[8]), new DERGeneralizedTime(new Date(1000L)), null));
        try {
            if (!this.isSameAs(sMIMECapabilitiesAttribute.getEncoded(), this.attrBytes)) {
                return new SimpleTestResult(false, this.getName() + ": Failed attr data check");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.attrBytes);
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            DERObject dERObject = aSN1InputStream.readObject();
            if (!sMIMECapabilitiesAttribute.equals((Object)dERObject)) {
                return new SimpleTestResult(false, this.getName() + ": Failed equality test for attr");
            }
            if (!this.isSameAs(sMIMEEncryptionKeyPreferenceAttribute.getEncoded(), this.prefBytes)) {
                return new SimpleTestResult(false, this.getName() + ": Failed attr data check");
            }
            byteArrayInputStream = new ByteArrayInputStream(this.prefBytes);
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            dERObject = aSN1InputStream.readObject();
            if (!sMIMEEncryptionKeyPreferenceAttribute.equals((Object)dERObject)) {
                return new SimpleTestResult(false, this.getName() + ": Failed equality test for pref");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
    }

    public String getName() {
        return "SMIME";
    }

    public static void main(String[] stringArray) {
        SMIMETest sMIMETest = new SMIMETest();
        TestResult testResult = sMIMETest.perform();
        System.out.println(testResult);
    }
}

