/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;

public class PBEFileProcessor {
    private static void decryptFile(InputStream inputStream, char[] cArray) throws Exception {
        int n;
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream = PGPUtil.getDecoderStream(inputStream));
        Object object = pGPObjectFactory.nextObject();
        PGPEncryptedDataList pGPEncryptedDataList = object instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object : (PGPEncryptedDataList)pGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream2 = pGPPBEEncryptedData.getDataStream(cArray, "BC");
        PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(inputStream2);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory2.nextObject();
        pGPObjectFactory2 = new PGPObjectFactory(pGPCompressedData.getDataStream());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory2.nextObject();
        FileOutputStream fileOutputStream = new FileOutputStream(pGPLiteralData.getFileName());
        InputStream inputStream3 = pGPLiteralData.getInputStream();
        while ((n = inputStream3.read()) >= 0) {
            fileOutputStream.write(n);
        }
        if (pGPPBEEncryptedData.isIntegrityProtected()) {
            if (!pGPPBEEncryptedData.verify()) {
                System.err.println("message failed integrity check");
            } else {
                System.err.println("message integrity check passed");
            }
        } else {
            System.err.println("no message integrity check");
        }
    }

    private static void encryptFile(OutputStream outputStream, String string, char[] cArray, boolean bl, boolean bl2) throws IOException, NoSuchProviderException, PGPException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        PGPUtil.writeFileToLiteralData(pGPCompressedDataGenerator.open(byteArrayOutputStream), 'b', new File(string));
        pGPCompressedDataGenerator.close();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(3, bl2, new SecureRandom(), "BC");
        pGPEncryptedDataGenerator.addMethod(cArray);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, byArray.length);
        outputStream2.write(byArray);
        pGPEncryptedDataGenerator.close();
        outputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-e")) {
            if (stringArray[1].equals("-a") || stringArray[1].equals("-ai") || stringArray[1].equals("-ia")) {
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(stringArray[2]) + ".asc");
                PBEFileProcessor.encryptFile(fileOutputStream, stringArray[2], stringArray[3].toCharArray(), true, stringArray[1].indexOf(105) > 0);
            } else if (stringArray[1].equals("-i")) {
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(stringArray[2]) + ".bpg");
                PBEFileProcessor.encryptFile(fileOutputStream, stringArray[2], stringArray[3].toCharArray(), false, true);
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(stringArray[1]) + ".bpg");
                PBEFileProcessor.encryptFile(fileOutputStream, stringArray[1], stringArray[2].toCharArray(), false, false);
            }
        } else if (stringArray[0].equals("-d")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            PBEFileProcessor.decryptFile(fileInputStream, stringArray[2].toCharArray());
        } else {
            System.err.println("usage: PBEFileProcessor -e [-ai]|-d file passPhrase");
        }
    }
}

