/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MD5HMacTest
implements Test {
    static final String[] keys = new String[]{"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "4a656665", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "0102030405060708090a0b0c0d0e0f10111213141516171819", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
    static final String[] digests = new String[]{"9294727a3638bb1c13f48ef8158bfc9d", "750c783e6ab0b503eaa86e310a5db738", "56be34521d144c88dbb8c733f0e8b3f6", "697eaf0aca3a3aea3a75164746ffaa79", "56461ef2342edc00f9bab995690efd4c", "6b1ab7fe4bd7bf8f0b62e6ce61b9d0cd", "6f630fad67cda0ee1fb1f562db3aa53e"};
    static final String[] messages = new String[]{"Hi There", "what do ya want for nothing?", "0xdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", "0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd", "Test With Truncation", "Test Using Larger Than Block-Size Key - Hash Key First", "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data"};

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return "MD5HMac";
    }

    public TestResult perform() {
        byte[] byArray;
        int n;
        HMac hMac = new HMac((Digest)new MD5Digest());
        byte[] byArray2 = new byte[hMac.getMacSize()];
        for (n = 0; n < messages.length; ++n) {
            byArray = messages[n].getBytes();
            if (messages[n].startsWith("0x")) {
                byArray = Hex.decode((String)messages[n].substring(2));
            }
            hMac.init((CipherParameters)new KeyParameter(Hex.decode((String)keys[n])));
            hMac.update(byArray, 0, byArray.length);
            hMac.doFinal(byArray2, 0);
            if (MD5HMacTest.arraysEqual(byArray2, Hex.decode((String)digests[n]))) continue;
            return new SimpleTestResult(false, this.getName() + "Vector " + n + " failed");
        }
        n = 0;
        byArray = messages[n].getBytes();
        if (messages[n].startsWith("0x")) {
            byArray = Hex.decode((String)messages[n].substring(2));
        }
        hMac.init((CipherParameters)new KeyParameter(Hex.decode((String)keys[n])));
        hMac.update(byArray, 0, byArray.length);
        hMac.doFinal(byArray2, 0);
        hMac.reset();
        hMac.update(byArray, 0, byArray.length);
        hMac.doFinal(byArray2, 0);
        if (!MD5HMacTest.arraysEqual(byArray2, Hex.decode((String)digests[n]))) {
            return new SimpleTestResult(false, this.getName() + "Reset with vector " + n + " failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        MD5HMacTest mD5HMacTest = new MD5HMacTest();
        TestResult testResult = mD5HMacTest.perform();
        System.out.println(testResult);
    }
}

