/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class AESSICTest
implements Test {
    private byte[][] keys = new byte[][]{Hex.decode((String)"2b7e151628aed2a6abf7158809cf4f3c"), Hex.decode((String)"8e73b0f7da0e6452c810f32b809079e562f8ead2522c6b7b"), Hex.decode((String)"603deb1015ca71be2b73aef0857d77811f352c073b6108d72d9810a30914dff4")};
    private byte[][] plain = new byte[][]{Hex.decode((String)"6bc1bee22e409f96e93d7e117393172a"), Hex.decode((String)"ae2d8a571e03ac9c9eb76fac45af8e51"), Hex.decode((String)"30c81c46a35ce411e5fbc1191a0a52ef"), Hex.decode((String)"f69f2445df4f9b17ad2b417be66c3710")};
    private byte[][][] cipher = new byte[][][]{new byte[][]{Hex.decode((String)"874d6191b620e3261bef6864990db6ce"), Hex.decode((String)"9806f66b7970fdff8617187bb9fffdff"), Hex.decode((String)"5ae4df3edbd5d35e5b4f09020db03eab"), Hex.decode((String)"1e031dda2fbe03d1792170a0f3009cee")}, new byte[][]{Hex.decode((String)"1abc932417521ca24f2b0459fe7e6e0b"), Hex.decode((String)"090339ec0aa6faefd5ccc2c6f4ce8e94"), Hex.decode((String)"1e36b26bd1ebc670d1bd1d665620abf7"), Hex.decode((String)"4f78a7f6d29809585a97daec58c6b050")}, new byte[][]{Hex.decode((String)"601ec313775789a5b7a7f504bbf3d228"), Hex.decode((String)"f443e3ca4d62b59aca84e990cacaf5c5"), Hex.decode((String)"2b0930daa23de94ce87017ba2d84988d"), Hex.decode((String)"dfc9c58db67aada613c2dd08457941a6")}};

    public String getName() {
        return "AESSIC";
    }

    private boolean sameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult perform() {
        try {
            Object object;
            Cipher cipher = Cipher.getInstance("AES/SIC/NoPadding", "BC");
            for (int i = 0; i != this.keys.length; ++i) {
                byte[] byArray;
                int n;
                object = new SecretKeySpec(this.keys[i], "AES");
                cipher.init(1, (Key)object, new IvParameterSpec(Hex.decode((String)"F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF")));
                for (n = 0; n != this.plain.length; ++n) {
                    byArray = cipher.update(this.plain[n]);
                    if (this.sameAs(byArray, this.cipher[i][n])) continue;
                    return new SimpleTestResult(false, this.getName() + ": AESSIC encrypt failed: key " + i + " block " + n);
                }
                cipher.init(2, (Key)object, new IvParameterSpec(Hex.decode((String)"F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF")));
                for (n = 0; n != this.plain.length; ++n) {
                    byArray = cipher.update(this.cipher[i][n]);
                    if (this.sameAs(byArray, this.plain[n])) continue;
                    return new SimpleTestResult(false, this.getName() + ": AESSIC decrypt failed: key " + i + " block " + n);
                }
            }
            cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(Hex.decode((String)"2B7E151628AED2A6ABF7158809CF4F3C"), "AES");
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(Hex.decode((String)"F0F1F2F3F4F5F6F7F8F9FAFBFCFD0001")));
            object = cipher.doFinal(Hex.decode((String)"00000000000000000000000000000000"));
            if (!this.sameAs((byte[])object, Hex.decode((String)"D23513162B02D0F72A43A2FE4A5F97AB"))) {
                return new SimpleTestResult(false, this.getName() + ": AESSIC failed test 2");
            }
            cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
            secretKeySpec = new SecretKeySpec(Hex.decode((String)"2B7E151628AED2A6ABF7158809CF4F3C"), "AES");
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(Hex.decode((String)"F0F1F2F3F4F5F6F7F8F9FAFBFCFD0001")));
            object = cipher.doFinal(Hex.decode((String)"12345678"));
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(Hex.decode((String)"F0F1F2F3F4F5F6F7F8F9FAFBFCFD0001")));
            object = cipher.doFinal((byte[])object);
            if (!this.sameAs((byte[])object, Hex.decode((String)"12345678"))) {
                return new SimpleTestResult(false, this.getName() + ": AESSIC failed partial test");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": AESSIC failed " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        AESSICTest aESSICTest = new AESSICTest();
        TestResult testResult = aESSICTest.perform();
        System.out.println(testResult.toString());
    }
}

